/*
 * Decompiled with CFR 0.152.
 */
package com.criobite.joshxmas.block;

import com.criobite.joshxmas.tileentity.PresentTileEntity;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.ContainerBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public class PresentBlock
extends ContainerBlock {
    protected static final VoxelShape SHAPE = Block.func_208617_a((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)8.0, (double)12.0);
    public final Color color;

    public PresentBlock(Color color) {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151594_q).func_200947_a(SoundType.field_222470_q).func_200948_a(0.5f, 2.0f));
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)BlockStateProperties.field_208138_am, (Comparable)Integer.valueOf(0)));
        this.color = color;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return SHAPE;
    }

    public VoxelShape func_196247_c(BlockState state, IBlockReader worldIn, BlockPos pos) {
        return VoxelShapes.func_197880_a();
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{BlockStateProperties.field_208138_am});
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        return !stateIn.func_196955_c((IWorldReader)worldIn, currentPos) ? Blocks.field_150350_a.func_176223_P() : stateIn;
    }

    public boolean func_196260_a(BlockState state, IWorldReader world, BlockPos pos) {
        return world.func_180495_p(pos.func_177977_b()).func_224755_d((IBlockReader)world, pos.func_177977_b(), Direction.UP);
    }

    public boolean func_196266_a(BlockState state, IBlockReader worldIn, BlockPos pos, PathType type) {
        return false;
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        BlockState state = (BlockState)this.func_176223_P().func_206870_a((Property)BlockStateProperties.field_208138_am, (Comparable)Integer.valueOf(MathHelper.func_76128_c((double)((double)(context.func_195999_j().field_70177_z * 16.0f / 360.0f) + 0.5)) & 0xF));
        return this.func_196260_a(state, (IWorldReader)context.func_195991_k(), context.func_195995_a()) ? state : null;
    }

    @Nullable
    public TileEntity func_196283_a_(IBlockReader worldIn) {
        return new PresentTileEntity(this.color);
    }

    public void func_180633_a(World worldIn, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        TileEntity tileentity;
        if (stack.func_82837_s() && (tileentity = worldIn.func_175625_s(pos)) instanceof PresentTileEntity) {
            ((PresentTileEntity)tileentity).func_213903_a(stack.func_200301_q());
        }
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        if (worldIn.field_72995_K) {
            return ActionResultType.SUCCESS;
        }
        TileEntity tileentity = worldIn.func_175625_s(pos);
        if (tileentity instanceof PresentTileEntity) {
            player.func_213829_a((INamedContainerProvider)((PresentTileEntity)tileentity));
        }
        return ActionResultType.CONSUME;
    }

    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.func_203425_a(newState.func_177230_c())) {
            TileEntity tileentity = worldIn.func_175625_s(pos);
            if (tileentity instanceof PresentTileEntity) {
                InventoryHelper.func_180175_a((World)worldIn, (BlockPos)pos, (IInventory)((PresentTileEntity)tileentity));
            }
            super.func_196243_a(state, worldIn, pos, newState, isMoving);
        }
    }

    public static enum Color {
        WHITE,
        RED,
        YELLOW,
        GREEN,
        BLUE,
        PURPLE;


        public String getName() {
            return this == WHITE ? "white" : (this == RED ? "red" : (this == YELLOW ? "yellow" : (this == GREEN ? "green" : (this == BLUE ? "blue" : "purple"))));
        }
    }
}

