/*
 * Decompiled with CFR 0.152.
 */
package com.criobite.joshxmas.block;

import com.criobite.joshxmas.block.DoorWreathBlock;
import com.criobite.joshxmas.tileentity.StockingTileEntity;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.ContainerBlock;
import net.minecraft.block.FenceBlock;
import net.minecraft.block.SlabBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.StairsBlock;
import net.minecraft.block.WallBlock;
import net.minecraft.block.material.Material;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.Half;
import net.minecraft.state.properties.SlabType;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public class StockingBlock
extends ContainerBlock {
    public static final BooleanProperty FLIP = BooleanProperty.func_177716_a((String)"flip");
    protected static final VoxelShape WEST_AABB = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)16.0, (double)16.0);
    protected static final VoxelShape EAST_AABB = Block.func_208617_a((double)15.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape NORTH_AABB = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)1.0);
    protected static final VoxelShape SOUTH_AABB = Block.func_208617_a((double)0.0, (double)0.0, (double)15.0, (double)16.0, (double)16.0, (double)16.0);

    public StockingBlock(Material material) {
        super(AbstractBlock.Properties.func_200945_a((Material)material).func_200947_a(SoundType.field_185854_g).func_226896_b_().func_200942_a());
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)FLIP, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)BlockStateProperties.field_208157_J, (Comparable)Direction.NORTH));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{FLIP, BlockStateProperties.field_208157_J});
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        return !stateIn.func_196955_c((IWorldReader)worldIn, currentPos) ? Blocks.field_150350_a.func_176223_P() : stateIn;
    }

    public boolean func_196260_a(BlockState state, IWorldReader world, BlockPos pos) {
        Direction dir = (Direction)state.func_177229_b((Property)BlockStateProperties.field_208157_J);
        BlockPos blockpos = pos.func_177972_a(dir);
        return this.canPlaceOn(world.func_180495_p(blockpos), world, blockpos, dir.func_176734_d());
    }

    public boolean canPlaceOn(BlockState state, IWorldReader world, BlockPos pos, Direction dir) {
        Block block = state.func_177230_c();
        if (block instanceof DoorWreathBlock) {
            return false;
        }
        if (state.func_224755_d((IBlockReader)world, pos, dir) && state.func_185904_a().func_76230_c()) {
            return true;
        }
        return block instanceof StairsBlock && state.func_177229_b((Property)StairsBlock.field_176308_b) == Half.TOP || block instanceof SlabBlock && state.func_177229_b((Property)SlabBlock.field_196505_a) == SlabType.TOP || block instanceof FenceBlock || block instanceof WallBlock;
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        Direction side = context.func_196000_l().func_176734_d();
        if (side == Direction.UP || side == Direction.DOWN) {
            return null;
        }
        Vector3d hit = context.func_221532_j().func_178786_a((double)context.func_195995_a().func_177958_n(), (double)context.func_195995_a().func_177956_o(), (double)context.func_195995_a().func_177952_p());
        BlockState state = (BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)BlockStateProperties.field_208157_J, (Comparable)side)).func_206870_a((Property)FLIP, (Comparable)Boolean.valueOf(side == Direction.SOUTH ? hit.field_72450_a < 0.5 : (side == Direction.WEST ? hit.field_72449_c < 0.5 : (side == Direction.NORTH ? hit.field_72450_a > 0.5 : hit.field_72449_c > 0.5))));
        return this.func_196260_a(state, (IWorldReader)context.func_195991_k(), context.func_195995_a()) ? state : null;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        Direction dir = (Direction)state.func_177229_b((Property)BlockStateProperties.field_208157_J);
        return dir == Direction.WEST ? WEST_AABB : (dir == Direction.EAST ? EAST_AABB : (dir == Direction.NORTH ? NORTH_AABB : SOUTH_AABB));
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.MODEL;
    }

    @Nullable
    public TileEntity func_196283_a_(IBlockReader worldIn) {
        return new StockingTileEntity();
    }

    public void func_180633_a(World worldIn, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        TileEntity tileentity;
        if (stack.func_82837_s() && (tileentity = worldIn.func_175625_s(pos)) instanceof StockingTileEntity) {
            ((StockingTileEntity)tileentity).func_213903_a(stack.func_200301_q());
        }
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        if (worldIn.field_72995_K) {
            return ActionResultType.SUCCESS;
        }
        TileEntity tileentity = worldIn.func_175625_s(pos);
        if (tileentity instanceof StockingTileEntity) {
            player.func_213829_a((INamedContainerProvider)((StockingTileEntity)tileentity));
        }
        return ActionResultType.CONSUME;
    }

    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.func_203425_a(newState.func_177230_c())) {
            TileEntity tileentity = worldIn.func_175625_s(pos);
            if (tileentity instanceof StockingTileEntity) {
                InventoryHelper.func_180175_a((World)worldIn, (BlockPos)pos, (IInventory)((StockingTileEntity)tileentity));
            }
            super.func_196243_a(state, worldIn, pos, newState, isMoving);
        }
    }
}

