/*
 * Decompiled with CFR 0.152.
 */
package com.criobite.joshxmas.block;

import com.criobite.joshxmas.block.DoorWreathBlock;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FenceBlock;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.PaneBlock;
import net.minecraft.block.SlabBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.StairsBlock;
import net.minecraft.block.WallBlock;
import net.minecraft.block.material.Material;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.Half;
import net.minecraft.state.properties.SlabType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;

public class WreathBlock
extends HorizontalBlock {
    protected static final VoxelShape WEST_AABB = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)16.0, (double)16.0);
    protected static final VoxelShape EAST_AABB = Block.func_208617_a((double)15.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape NORTH_AABB = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)1.0);
    protected static final VoxelShape SOUTH_AABB = Block.func_208617_a((double)0.0, (double)0.0, (double)15.0, (double)16.0, (double)16.0, (double)16.0);

    public WreathBlock() {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151585_k).func_200947_a(SoundType.field_185850_c).func_200942_a().func_200943_b(0.0f));
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)field_185512_D, (Comparable)Direction.NORTH));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{field_185512_D});
    }

    public boolean canPlaceOn(BlockState state, IWorldReader world, BlockPos pos, Direction dir) {
        Block block = state.func_177230_c();
        if (block instanceof DoorWreathBlock) {
            return false;
        }
        if (state.func_224755_d((IBlockReader)world, pos, dir) && state.func_185904_a().func_76230_c()) {
            return true;
        }
        return block instanceof PaneBlock || block instanceof StairsBlock && state.func_177229_b((Property)StairsBlock.field_176308_b) == Half.TOP || block instanceof SlabBlock && state.func_177229_b((Property)SlabBlock.field_196505_a) == SlabType.TOP || block instanceof FenceBlock || block instanceof WallBlock;
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        return !stateIn.func_196955_c((IWorldReader)worldIn, currentPos) ? Blocks.field_150350_a.func_176223_P() : stateIn;
    }

    public boolean func_196260_a(BlockState state, IWorldReader world, BlockPos pos) {
        Direction dir = (Direction)state.func_177229_b((Property)field_185512_D);
        BlockPos blockpos = pos.func_177972_a(dir);
        return this.canPlaceOn(world.func_180495_p(blockpos), world, blockpos, dir.func_176734_d());
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        Direction side = context.func_196000_l().func_176734_d();
        if (side == Direction.UP || side == Direction.DOWN) {
            return null;
        }
        BlockState state = (BlockState)this.func_176223_P().func_206870_a((Property)field_185512_D, (Comparable)side);
        return this.func_196260_a(state, (IWorldReader)context.func_195991_k(), context.func_195995_a()) ? state : null;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        Direction dir = (Direction)state.func_177229_b((Property)field_185512_D);
        return dir == Direction.WEST ? WEST_AABB : (dir == Direction.EAST ? EAST_AABB : (dir == Direction.NORTH ? NORTH_AABB : SOUTH_AABB));
    }
}

