/*
 * Decompiled with CFR 0.152.
 */
package com.criobite.joshxmas.block;

import com.criobite.joshxmas.block.XMasTreeBlock;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FenceBlock;
import net.minecraft.block.PaneBlock;
import net.minecraft.block.SlabBlock;
import net.minecraft.block.StairsBlock;
import net.minecraft.block.WallBlock;
import net.minecraft.block.material.Material;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.Half;
import net.minecraft.state.properties.SlabType;
import net.minecraft.util.Direction;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;

public class XMasLightsBlock
extends Block {
    public static final EnumProperty<LightsConnect> CONNECT = EnumProperty.func_177709_a((String)"connect", LightsConnect.class);
    public static final EnumProperty<LightsSide> SIDE = EnumProperty.func_177709_a((String)"side", LightsSide.class);
    protected static final VoxelShape WEST_AABB = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)16.0, (double)16.0);
    protected static final VoxelShape EAST_AABB = Block.func_208617_a((double)15.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape NORTH_AABB = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)1.0);
    protected static final VoxelShape SOUTH_AABB = Block.func_208617_a((double)0.0, (double)0.0, (double)15.0, (double)16.0, (double)16.0, (double)16.0);
    protected final XMasTreeBlock.TreeLights treeLights;

    public XMasLightsBlock(XMasTreeBlock.TreeLights treeLights) {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151594_q).func_200942_a().func_200946_b().func_235838_a_(state -> 11));
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a(CONNECT, (Comparable)((Object)LightsConnect.NONE))).func_206870_a(SIDE, (Comparable)((Object)LightsSide.SOUTH)));
        treeLights.lightsBlock = this;
        this.treeLights = treeLights;
    }

    public XMasTreeBlock.TreeLights getTreeLights() {
        return this.treeLights;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{CONNECT, SIDE});
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        if (state.func_177229_b(CONNECT) != LightsConnect.NONE) {
            return VoxelShapes.func_197868_b();
        }
        LightsSide side = (LightsSide)((Object)state.func_177229_b(SIDE));
        return side == LightsSide.SOUTH ? SOUTH_AABB : (side == LightsSide.WEST ? WEST_AABB : (side == LightsSide.NORTH ? NORTH_AABB : EAST_AABB));
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        return stateIn.func_196955_c((IWorldReader)worldIn, currentPos) ? (BlockState)stateIn.func_206870_a(CONNECT, (Comparable)((Object)this.getConnect(worldIn, stateIn, currentPos))) : Blocks.field_150350_a.func_176223_P();
    }

    public boolean func_196260_a(BlockState stateIn, IWorldReader world, BlockPos pos) {
        LightsSide side = (LightsSide)((Object)stateIn.func_177229_b(SIDE));
        Direction dir = side.toDirection();
        BlockPos pos2 = pos.func_177972_a(dir);
        BlockState state2 = world.func_180495_p(pos2);
        if (state2.func_224755_d((IBlockReader)world, pos2, dir.func_176734_d()) && state2.func_185904_a().func_76230_c()) {
            return true;
        }
        Block block2 = state2.func_177230_c();
        return block2 instanceof PaneBlock || block2 instanceof StairsBlock && state2.func_177229_b((Property)StairsBlock.field_176308_b) == Half.TOP || block2 instanceof SlabBlock && state2.func_177229_b((Property)SlabBlock.field_196505_a) != SlabType.BOTTOM || block2 instanceof FenceBlock || block2 instanceof WallBlock;
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        Direction side = context.func_196000_l().func_176734_d();
        if (side == Direction.UP || side == Direction.DOWN) {
            return null;
        }
        Direction face = context.func_196000_l();
        Direction dir = face.func_176734_d();
        BlockState state = (BlockState)this.func_176223_P().func_206870_a(SIDE, (Comparable)((Object)LightsSide.SOUTH));
        if (dir == Direction.WEST) {
            state = (BlockState)state.func_206870_a(SIDE, (Comparable)((Object)LightsSide.WEST));
        } else if (dir == Direction.NORTH) {
            state = (BlockState)state.func_206870_a(SIDE, (Comparable)((Object)LightsSide.NORTH));
        } else if (dir == Direction.EAST) {
            state = (BlockState)state.func_206870_a(SIDE, (Comparable)((Object)LightsSide.EAST));
        }
        return (BlockState)state.func_206870_a(CONNECT, (Comparable)((Object)this.getConnect((IWorld)context.func_195991_k(), state, context.func_195995_a())));
    }

    protected LightsConnect getConnect(IWorld world, BlockState state, BlockPos pos) {
        LightsSide side = (LightsSide)((Object)state.func_177229_b(SIDE));
        BlockPos testPos = pos.func_177972_a(side.toDirection().func_176734_d());
        BlockState testState = world.func_180495_p(testPos);
        LightsConnect connect = LightsConnect.NONE;
        if (testState.func_177230_c() == this) {
            LightsSide testSide = (LightsSide)((Object)testState.func_177229_b(SIDE));
            switch (side) {
                case SOUTH: {
                    if (testSide == LightsSide.EAST) {
                        connect = LightsConnect.LEFT;
                        break;
                    }
                    if (testSide != LightsSide.WEST) break;
                    connect = LightsConnect.RIGHT;
                    break;
                }
                case WEST: {
                    if (testSide == LightsSide.SOUTH) {
                        connect = LightsConnect.LEFT;
                        break;
                    }
                    if (testSide != LightsSide.NORTH) break;
                    connect = LightsConnect.RIGHT;
                    break;
                }
                case NORTH: {
                    if (testSide == LightsSide.WEST) {
                        connect = LightsConnect.LEFT;
                        break;
                    }
                    if (testSide != LightsSide.EAST) break;
                    connect = LightsConnect.RIGHT;
                    break;
                }
                case EAST: {
                    if (testSide == LightsSide.NORTH) {
                        connect = LightsConnect.LEFT;
                        break;
                    }
                    if (testSide != LightsSide.SOUTH) break;
                    connect = LightsConnect.RIGHT;
                }
            }
        }
        return connect;
    }

    public static enum LightsSide implements IStringSerializable
    {
        SOUTH("south"),
        WEST("west"),
        NORTH("north"),
        EAST("east");

        private final String name;

        private LightsSide(String name) {
            this.name = name;
        }

        public String func_176610_l() {
            return this.name;
        }

        public Direction toDirection() {
            return this == SOUTH ? Direction.SOUTH : (this == WEST ? Direction.WEST : (this == NORTH ? Direction.NORTH : Direction.EAST));
        }
    }

    public static enum LightsConnect implements IStringSerializable
    {
        NONE("none"),
        LEFT("left"),
        RIGHT("right");

        private final String name;

        private LightsConnect(String name) {
            this.name = name;
        }

        public String func_176610_l() {
            return this.name;
        }
    }
}

