/*
 * Decompiled with CFR 0.152.
 */
package com.criobite.joshxmas.block;

import com.criobite.joshxmas.XMasItems;
import com.criobite.joshxmas.block.XMasLightsBlock;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.DoubleBlockHalf;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public class XMasTreeBlock
extends Block {
    public static final EnumProperty<DoubleBlockHalf> HALF = BlockStateProperties.field_208163_P;
    public static final EnumProperty<TreeLights> LIGHTS = EnumProperty.func_177709_a((String)"lights", TreeLights.class);
    public static final BooleanProperty STAR = BooleanProperty.func_177716_a((String)"star");
    protected static final VoxelShape TOP_AABB = Block.func_208617_a((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);
    protected static final VoxelShape TOP_COLLIDE = Block.func_208617_a((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)14.0, (double)12.0);
    protected static final VoxelShape BOTTOM_COLLIDE = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)14.0, (double)16.0);

    public XMasTreeBlock() {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151584_j).func_200948_a(0.5f, 2.0f).func_200942_a().func_226896_b_().func_200947_a(SoundType.field_185850_c).func_235838_a_(state -> state.func_177229_b(LIGHTS) != TreeLights.NONE ? (state.func_177229_b(HALF) == DoubleBlockHalf.LOWER ? 11 : 3) : 0));
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a(HALF, (Comparable)DoubleBlockHalf.LOWER)).func_206870_a(LIGHTS, (Comparable)((Object)TreeLights.NONE))).func_206870_a((Property)STAR, (Comparable)Boolean.valueOf(false)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{HALF, LIGHTS, STAR});
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)((BlockState)((BlockState)this.func_176223_P().func_206870_a(HALF, (Comparable)DoubleBlockHalf.LOWER)).func_206870_a(LIGHTS, (Comparable)((Object)TreeLights.NONE))).func_206870_a((Property)STAR, (Comparable)Boolean.valueOf(false));
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return state.func_177229_b(HALF) == DoubleBlockHalf.LOWER ? VoxelShapes.func_197868_b() : TOP_AABB;
    }

    public VoxelShape func_220071_b(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return state.func_177229_b(HALF) == DoubleBlockHalf.LOWER ? BOTTOM_COLLIDE : TOP_COLLIDE;
    }

    public boolean func_196260_a(BlockState state, IWorldReader worldIn, BlockPos pos) {
        BlockPos posDown = pos.func_177977_b();
        BlockState stateUp = worldIn.func_180495_p(pos.func_177984_a());
        BlockState stateDown = worldIn.func_180495_p(posDown);
        return stateUp.func_196958_f() && stateDown.func_224755_d((IBlockReader)worldIn, posDown, Direction.UP) && stateDown.func_185904_a().func_76230_c();
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (stateIn.func_177229_b(HALF) == DoubleBlockHalf.LOWER) {
            BlockPos posDown = currentPos.func_177977_b();
            BlockState stateUp = worldIn.func_180495_p(currentPos.func_177984_a());
            BlockState stateDown = worldIn.func_180495_p(posDown);
            return stateUp.func_177230_c() == this && stateUp.func_177229_b(HALF) == DoubleBlockHalf.UPPER && stateDown.func_224755_d((IBlockReader)worldIn, posDown, Direction.UP) && stateDown.func_185904_a().func_76230_c() ? stateIn : Blocks.field_150350_a.func_176223_P();
        }
        BlockState stateDown = worldIn.func_180495_p(currentPos.func_177977_b());
        return stateDown.func_177230_c() == this && stateDown.func_177229_b(HALF) == DoubleBlockHalf.LOWER ? stateIn : Blocks.field_150350_a.func_176223_P();
    }

    public void func_180633_a(World worldIn, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        worldIn.func_180501_a(pos.func_177984_a(), (BlockState)state.func_206870_a(HALF, (Comparable)DoubleBlockHalf.UPPER), 3);
    }

    public void func_176208_a(World worldIn, BlockPos pos, BlockState state, PlayerEntity player) {
        if (!worldIn.field_72995_K && player.func_184812_l_()) {
            BlockPos pos2 = state.func_177229_b(HALF) == DoubleBlockHalf.LOWER ? pos.func_177984_a() : pos.func_177977_b();
            BlockState state2 = Blocks.field_150350_a.func_176223_P();
            worldIn.func_180501_a(pos2, state2, 19);
            worldIn.func_217378_a(player, 2001, pos2, Block.func_196246_j((BlockState)state2));
        }
        super.func_176208_a(worldIn, pos, state, player);
    }

    public void func_196270_a(BlockState state, World worldIn, BlockPos pos, PlayerEntity playerIn) {
        BlockPos posLower;
        if (!playerIn.func_175142_cm()) {
            return;
        }
        boolean upper = state.func_177229_b(HALF) == DoubleBlockHalf.UPPER;
        BlockPos posUpper = upper ? pos : pos.func_177984_a();
        BlockPos blockPos = posLower = upper ? pos.func_177977_b() : pos;
        if (((Boolean)state.func_177229_b((Property)STAR)).booleanValue() && (upper || state.func_177229_b(LIGHTS) == TreeLights.NONE)) {
            Direction direction = playerIn.func_174811_aO().func_176734_d();
            ItemEntity itemEntity = new ItemEntity(worldIn, (double)posUpper.func_177958_n() + 0.5 + (double)direction.func_82601_c() * 0.65, (double)posUpper.func_177956_o() + 0.1, (double)posUpper.func_177952_p() + 0.5 + (double)direction.func_82599_e() * 0.65, new ItemStack((IItemProvider)XMasItems.XMAS_TREE_STAR));
            itemEntity.func_213293_j(0.05 * (double)direction.func_82601_c() + worldIn.field_73012_v.nextDouble() * 0.02, 0.05, 0.05 * (double)direction.func_82599_e() + worldIn.field_73012_v.nextDouble() * 0.02);
            worldIn.func_217376_c((Entity)itemEntity);
            this.playRustleSound(worldIn, playerIn, posUpper);
            state = (BlockState)state.func_206870_a((Property)STAR, (Comparable)Boolean.valueOf(false));
        } else if (state.func_177229_b(LIGHTS) != TreeLights.NONE) {
            Direction direction = playerIn.func_174811_aO().func_176734_d();
            ItemEntity itemEntity = new ItemEntity(worldIn, (double)posLower.func_177958_n() + 0.5 + (double)direction.func_82601_c() * 0.65, (double)posLower.func_177956_o() + 0.1, (double)posLower.func_177952_p() + 0.5 + (double)direction.func_82599_e() * 0.65, new ItemStack((IItemProvider)((TreeLights)((Object)state.func_177229_b(XMasTreeBlock.LIGHTS))).lightsBlock));
            itemEntity.func_213293_j(0.05 * (double)direction.func_82601_c() + worldIn.field_73012_v.nextDouble() * 0.02, 0.05, 0.05 * (double)direction.func_82599_e() + worldIn.field_73012_v.nextDouble() * 0.02);
            worldIn.func_217376_c((Entity)itemEntity);
            this.playRustleSound(worldIn, playerIn, posLower);
            state = (BlockState)state.func_206870_a(LIGHTS, (Comparable)((Object)TreeLights.NONE));
        } else {
            return;
        }
        worldIn.func_175656_a(posUpper, (BlockState)state.func_206870_a(HALF, (Comparable)DoubleBlockHalf.UPPER));
        worldIn.func_175656_a(posLower, (BlockState)state.func_206870_a(HALF, (Comparable)DoubleBlockHalf.LOWER));
        worldIn.func_184138_a(posUpper, state, state, 3);
        worldIn.func_184138_a(posLower, state, state, 3);
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity playerIn, Hand handIn, BlockRayTraceResult hit) {
        BlockPos posLower;
        if (!playerIn.func_175142_cm() || handIn != Hand.MAIN_HAND) {
            return ActionResultType.PASS;
        }
        ItemStack stack = playerIn.func_184586_b(handIn);
        boolean upper = state.func_177229_b(HALF) == DoubleBlockHalf.UPPER;
        BlockPos posUpper = upper ? pos : pos.func_177984_a();
        BlockPos blockPos = posLower = upper ? pos.func_177977_b() : pos;
        if (!stack.func_190926_b()) {
            Item item = stack.func_77973_b();
            if (item == XMasItems.XMAS_TREE_STAR) {
                if (((Boolean)state.func_177229_b((Property)STAR)).booleanValue()) {
                    return ActionResultType.PASS;
                }
                if (!playerIn.func_184812_l_()) {
                    stack.func_190918_g(1);
                }
                this.playRustleSound(worldIn, playerIn, posUpper);
                state = (BlockState)state.func_206870_a((Property)STAR, (Comparable)Boolean.valueOf(true));
            } else {
                if (state.func_177229_b(LIGHTS) != TreeLights.NONE || !(item instanceof BlockItem) || !(((BlockItem)item).func_179223_d() instanceof XMasLightsBlock)) {
                    return ActionResultType.PASS;
                }
                if (!playerIn.func_184812_l_()) {
                    stack.func_190918_g(1);
                }
                this.playRustleSound(worldIn, playerIn, posLower);
                state = (BlockState)state.func_206870_a(LIGHTS, (Comparable)((Object)((XMasLightsBlock)((BlockItem)item).func_179223_d()).getTreeLights()));
            }
        } else {
            return ActionResultType.PASS;
        }
        worldIn.func_175656_a(posUpper, (BlockState)state.func_206870_a(HALF, (Comparable)DoubleBlockHalf.UPPER));
        worldIn.func_175656_a(posLower, (BlockState)state.func_206870_a(HALF, (Comparable)DoubleBlockHalf.LOWER));
        worldIn.func_184138_a(posUpper, state, state, 3);
        worldIn.func_184138_a(posLower, state, state, 3);
        return ActionResultType.CONSUME;
    }

    protected void playRustleSound(World worldIn, PlayerEntity playerIn, BlockPos pos) {
        SoundType soundtype = SoundType.field_185850_c;
        worldIn.func_184133_a(playerIn, pos, soundtype.func_185841_e(), SoundCategory.BLOCKS, (soundtype.func_185843_a() + 1.0f) / 2.0f, soundtype.func_185847_b() * 0.8f);
    }

    public static enum TreeLights implements IStringSerializable
    {
        NONE("none"),
        RAINBOW("rainbow"),
        RED_GREEN("red_green"),
        WHITE("white"),
        RED("red"),
        YELLOW("yellow"),
        GREEN("green"),
        BLUE("blue"),
        PURPLE("purple");

        private final String name;
        public XMasLightsBlock lightsBlock;

        private TreeLights(String name) {
            this.name = name;
        }

        public String func_176610_l() {
            return this.name;
        }
    }
}

