/*
 * Decompiled with CFR 0.152.
 */
package com.criobite.joshxmas.world.gen.feature;

import com.criobite.joshxmas.XMasBlocks;
import com.criobite.joshxmas.block.WildMistletoeBlock;
import com.mojang.serialization.Codec;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.BushBlock;
import net.minecraft.state.Property;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;

public class WildMistletoeFeature
extends Feature<NoFeatureConfig> {
    public static final BlockState[] STATES;
    private static final Random random;

    public WildMistletoeFeature(Codec<NoFeatureConfig> codec) {
        super(codec);
    }

    public boolean generate(ISeedReader reader, ChunkGenerator generator, Random rand, BlockPos pos, NoFeatureConfig config) {
        int i = 0;
        if (reader.func_230315_m_().func_236043_f_() && this.isMistletoeChunk(reader.func_72905_C(), pos.func_177958_n() / 16, pos.func_177952_p() / 16)) {
            BlockPos.Mutable pos$mutable = pos.func_239590_i_();
            for (int x = 0; x != 16; ++x) {
                block1: for (int z = 0; z != 16; ++z) {
                    int x2 = pos.func_177958_n() + x;
                    int z2 = pos.func_177952_p() + z;
                    if (!this.isMistletoeColumn(reader.func_72905_C(), x2, z2)) continue;
                    for (int y = reader.func_217301_I() - 1; y > 1; --y) {
                        BlockState below;
                        if (!reader.func_180495_p((BlockPos)pos$mutable.func_181079_c(x2, y, z2)).func_196958_f() || !STATES[0].func_196955_c((IWorldReader)reader, (BlockPos)pos$mutable) || !(below = reader.func_180495_p(pos$mutable.func_177977_b())).func_185904_a().func_76222_j() && !(below.func_177230_c() instanceof BushBlock)) continue;
                        reader.func_180501_a((BlockPos)pos$mutable.func_181079_c(x2, y, z2), STATES[rand.nextInt(STATES.length)], 2);
                        ++i;
                        continue block1;
                    }
                }
            }
        }
        return i != 0;
    }

    protected boolean isMistletoeChunk(long seed, int chunkX, int chunkZ) {
        random.setSeed(seed + (long)(chunkX * chunkX * 4987142) + (long)(chunkX * 5947611) + (long)(chunkZ * chunkZ) * 4392871L + (long)(chunkZ * 389711) ^ 0x3AD8025FL);
        return random.nextInt(31) == 0;
    }

    protected boolean isMistletoeColumn(long seed, int x, int z) {
        random.setSeed(seed + (long)(x * x * 4987142) + (long)(x * 5947611) + (long)(z * z) * 4392871L + (long)(z * 389711) ^ 0x3AD8025FL);
        return random.nextInt(63) < 2;
    }

    static {
        BlockState[] blockStateArray = new BlockState[3];
        blockStateArray[0] = (BlockState)XMasBlocks.WILD_MISTLETOE.func_176223_P().func_206870_a((Property)WildMistletoeBlock.AGE, (Comparable)Integer.valueOf(0));
        blockStateArray[1] = (BlockState)XMasBlocks.WILD_MISTLETOE.func_176223_P().func_206870_a((Property)WildMistletoeBlock.AGE, (Comparable)Integer.valueOf(1));
        blockStateArray[2] = (BlockState)XMasBlocks.WILD_MISTLETOE.func_176223_P().func_206870_a((Property)WildMistletoeBlock.AGE, (Comparable)Integer.valueOf(2));
        STATES = blockStateArray;
        random = new Random();
    }
}

