/*
 * Decompiled with CFR 0.152.
 */
package yourmediocrepal.noel.blocks;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityTNTPrimed;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import yourmediocrepal.noel.Noel;
import yourmediocrepal.noel.init.BlockInit;
import yourmediocrepal.noel.init.ItemInit;
import yourmediocrepal.noel.util.interfaces.IHasModel;

public class BlockPresent
extends Block
implements IHasModel {
    private static final AxisAlignedBB BOUNDING_BOX = new AxisAlignedBB(0.25, 0.0, 0.25, 0.75, 0.4375, 0.75);
    private static final AxisAlignedBB COLLISION_BOX = new AxisAlignedBB(0.0, 0.0, 0.0, 0.8125, 0.5, 0.8125);
    private final boolean isTrap;

    public BlockPresent(String name, boolean isTrap) {
        super(Material.field_151580_n);
        this.func_149663_c(name);
        this.setRegistryName(name);
        this.func_149647_a(Noel.NoelTab);
        BlockInit.BLOCKS.add(this);
        ItemInit.ITEMS.add((Item)new ItemBlock((Block)this).setRegistryName(name));
        this.func_149711_c(0.25f);
        this.func_149672_a(SoundType.field_185854_g);
        this.isTrap = isTrap;
    }

    @Override
    public void registerModels() {
        Noel.proxy.registerModel(Item.func_150898_a((Block)this), 0);
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT_MIPPED;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return BOUNDING_BOX;
    }

    public int func_149745_a(Random random) {
        return 1 + random.nextInt(3);
    }

    public void explode(World worldIn, BlockPos pos, EntityLivingBase igniter) {
        if (!worldIn.field_72995_K) {
            EntityTNTPrimed entitytntprimed = new EntityTNTPrimed(worldIn, (double)((float)pos.func_177958_n() + 0.5f), (double)pos.func_177956_o(), (double)((float)pos.func_177952_p() + 0.5f), igniter);
            worldIn.func_72838_d((Entity)entitytntprimed);
            worldIn.func_184133_a((EntityPlayer)null, entitytntprimed.func_180425_c(), SoundEvents.field_187904_gd, SoundCategory.HOSTILE, 1.0f, 1.0f);
        }
    }

    public void func_176208_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer player) {
        if (this.isTrap) {
            this.explode(worldIn, pos, (EntityLivingBase)player);
        }
    }

    @Nullable
    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        if (!this.isTrap) {
            float randnum = (float)Math.random();
            if (randnum < 1.0f && (double)randnum > 0.75) {
                return Items.field_151044_h;
            }
            if ((double)randnum < 0.75 && (double)randnum > 0.5) {
                return Items.field_151137_ax;
            }
            if ((double)randnum < 0.5 && (double)randnum > 0.25) {
                return Items.field_151043_k;
            }
            if ((double)randnum < 0.25 && (double)randnum > 0.1) {
                return Items.field_151042_j;
            }
            if ((double)randnum < 0.1 && randnum > 0.0f) {
                return Items.field_151045_i;
            }
        }
        return null;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }
}

