/*
 * Decompiled with CFR 0.152.
 */
package yourmediocrepal.noel.tileentity;

import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import yourmediocrepal.noel.init.ItemInit;

public class TileEntityKettle
extends TileEntity {
    private int cocoaCount = 0;
    private int waterCount = 0;
    private int milkCount = 0;

    public int getCocoaCount() {
        return this.cocoaCount;
    }

    public int getWaterCount() {
        return this.waterCount;
    }

    public int getMilkCount() {
        return this.milkCount;
    }

    public boolean addCocoa() {
        if (this.cocoaCount < 1) {
            ++this.cocoaCount;
            return true;
        }
        return false;
    }

    public boolean addWater() {
        if (this.waterCount < 1) {
            ++this.waterCount;
            return true;
        }
        return false;
    }

    public boolean addMilk() {
        if (this.milkCount < 1) {
            ++this.milkCount;
            return true;
        }
        return false;
    }

    public String ingredientsCheck() {
        String type = null;
        if (this.cocoaCount == 1 && this.waterCount == 1 && this.milkCount == 1) {
            type = "hot_choc";
        }
        if (this.cocoaCount == 0 && this.waterCount == 0 && this.milkCount == 1) {
            type = "warm_milk";
        }
        if (type != null) {
            this.clearContents();
        }
        return type;
    }

    public void clearContents() {
        this.waterCount = 0;
        this.cocoaCount = 0;
        this.milkCount = 0;
    }

    public boolean isOccupied() {
        if (this.waterCount == 1) {
            return true;
        }
        if (this.milkCount == 1) {
            return true;
        }
        return this.cocoaCount == 1;
    }

    public boolean onBlockActivated(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack heldItem = playerIn.func_184586_b(hand);
        TileEntity tileEntity = worldIn.func_175625_s(pos);
        if (!worldIn.field_72995_K && tileEntity instanceof TileEntityKettle) {
            TileEntityKettle kettle = (TileEntityKettle)tileEntity;
            System.out.println("kettle isOccupied = " + this.isOccupied());
            if (playerIn.func_70093_af() && heldItem.func_190926_b()) {
                this.clearContents();
                worldIn.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, 0.0, 0.0, 0.0, new int[0]);
                System.out.println("kettle was emptied");
            }
            if (heldItem != null) {
                Item copyItem = heldItem.func_77973_b();
                EnumDyeColor enumdyecolor = EnumDyeColor.func_176766_a((int)heldItem.func_77952_i());
                if (copyItem == Items.field_151100_aR && enumdyecolor == EnumDyeColor.BROWN && kettle.addCocoa()) {
                    if (!playerIn.func_184812_l_()) {
                        heldItem.func_190918_g(1);
                    }
                    return true;
                }
                if (copyItem == Items.field_151131_as && kettle.addWater()) {
                    if (!playerIn.func_184812_l_()) {
                        playerIn.func_184611_a(hand, new ItemStack(Items.field_151133_ar));
                    }
                    return true;
                }
                if (copyItem == Items.field_151117_aB && kettle.addMilk()) {
                    if (!playerIn.func_184812_l_()) {
                        playerIn.func_184611_a(hand, new ItemStack(Items.field_151133_ar));
                    }
                    return true;
                }
                if (copyItem == ItemInit.MUG) {
                    if (kettle.ingredientsCheck() == "hot_choc") {
                        playerIn.func_184611_a(hand, new ItemStack(ItemInit.HOT_CHOCOLATE));
                    } else if (kettle.ingredientsCheck() == "warm_milk") {
                        playerIn.func_184611_a(hand, new ItemStack(ItemInit.WARM_MILK));
                    }
                    return true;
                }
            }
        }
        return true;
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74768_a("CocoaCount", this.cocoaCount);
        compound.func_74768_a("WaterCount", this.waterCount);
        compound.func_74768_a("MilkCount", this.milkCount);
        return compound;
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.cocoaCount = compound.func_74762_e("CocoaCount");
        this.waterCount = compound.func_74762_e("WaterCount");
        this.milkCount = compound.func_74762_e("MilkCount");
    }
}

