/*
 * Decompiled with CFR 0.152.
 */
package mod.yourmediocrepal.noel.blocks;

import javax.annotation.Nullable;
import mod.yourmediocrepal.noel.tileentity.AdventCalendarTileEntity;
import mod.yourmediocrepal.noel.tileentity.ModTileEntityTypes;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public class BlockAdventCalendar
extends Block {
    protected static final VoxelShape CALENDAR_EAST_AABB = Block.func_208617_a((double)0.0, (double)1.0, (double)1.0, (double)1.0, (double)15.0, (double)15.0);
    protected static final VoxelShape CALENDAR_WEST_AABB = Block.func_208617_a((double)15.0, (double)1.0, (double)1.0, (double)15.0, (double)15.0, (double)15.0);
    protected static final VoxelShape CALENDAR_SOUTH_AABB = Block.func_208617_a((double)1.0, (double)1.0, (double)0.0, (double)15.0, (double)15.0, (double)1.0);
    protected static final VoxelShape CALENDAR_NORTH_AABB = Block.func_208617_a((double)1.0, (double)1.0, (double)15.0, (double)15.0, (double)15.0, (double)16.0);
    private static final DirectionProperty FACING = HorizontalBlock.field_185512_D;

    public BlockAdventCalendar() {
        super(Block.Properties.func_200945_a((Material)Material.field_151594_q).func_200948_a(0.2f, 0.2f).func_200947_a(SoundType.field_185854_g).harvestLevel(0));
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)this.func_176223_P().func_206870_a((IProperty)FACING, (Comparable)context.func_195992_f().func_176734_d());
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        switch ((Direction)state.func_177229_b((IProperty)FACING)) {
            case NORTH: {
                return CALENDAR_NORTH_AABB;
            }
            case SOUTH: {
                return CALENDAR_SOUTH_AABB;
            }
            case WEST: {
                return CALENDAR_WEST_AABB;
            }
        }
        return CALENDAR_EAST_AABB;
    }

    private boolean canAttachTo(IBlockReader p_196471_1_, BlockPos p_196471_2_, Direction p_196471_3_) {
        BlockState blockstate = p_196471_1_.func_180495_p(p_196471_2_);
        return !blockstate.func_185897_m() && blockstate.func_224755_d(p_196471_1_, p_196471_2_, p_196471_3_);
    }

    public boolean func_196260_a(BlockState state, IWorldReader worldIn, BlockPos pos) {
        Direction direction = (Direction)state.func_177229_b((IProperty)FACING);
        return this.canAttachTo((IBlockReader)worldIn, pos.func_177972_a(direction.func_176734_d()), direction);
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (facing.func_176734_d() == stateIn.func_177229_b((IProperty)FACING) && !stateIn.func_196955_c((IWorldReader)worldIn, currentPos)) {
            return Blocks.field_150350_a.func_176223_P();
        }
        return super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public BlockState func_185499_a(BlockState state, Rotation rot) {
        return (BlockState)state.func_206870_a((IProperty)FACING, (Comparable)rot.func_185831_a((Direction)state.func_177229_b((IProperty)FACING)));
    }

    public BlockState func_185471_a(BlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((Direction)state.func_177229_b((IProperty)FACING)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{FACING});
    }

    public float func_220080_a(BlockState state, IBlockReader worldIn, BlockPos pos) {
        return 0.6f;
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return ((TileEntityType)ModTileEntityTypes.ADVENT_CALENDAR.get()).func_200968_a();
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        if (worldIn.field_72995_K) {
            return ActionResultType.SUCCESS;
        }
        TileEntity advent = worldIn.func_175625_s(pos);
        if (advent instanceof AdventCalendarTileEntity) {
            ((AdventCalendarTileEntity)advent).onBlockActivated(state, worldIn, pos, player, handIn, hit);
        }
        return ActionResultType.SUCCESS;
    }
}

