/*
 * Decompiled with CFR 0.152.
 */
package mod.yourmediocrepal.noel.blocks;

import java.util.Random;
import javax.annotation.Nullable;
import mod.yourmediocrepal.noel.tileentity.KettleTileEntity;
import mod.yourmediocrepal.noel.tileentity.ModTileEntityTypes;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class BlockKettle
extends Block {
    protected static final VoxelShape SHAPE = Block.func_208617_a((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)8.0, (double)12.0);
    private static final DirectionProperty FACING = HorizontalBlock.field_185512_D;
    public static final BooleanProperty COOKING = BooleanProperty.func_177716_a((String)"cooking");
    public static final BooleanProperty IGNITED = BooleanProperty.func_177716_a((String)"ignited");

    public BlockKettle() {
        super(Block.Properties.func_200945_a((Material)Material.field_151573_f).func_200948_a(2.0f, 3.0f).func_200947_a(SoundType.field_185852_e).func_226896_b_().func_200944_c());
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)FACING, (Comparable)Direction.NORTH)).func_206870_a((IProperty)COOKING, (Comparable)Boolean.valueOf(false)));
    }

    public static void updateState(BlockState blockstate, World world, BlockPos pos, Boolean isCooking, Boolean ignited) {
        world.func_175656_a(pos, (BlockState)blockstate.func_206870_a((IProperty)COOKING, (Comparable)isCooking));
        world.func_175656_a(pos, (BlockState)blockstate.func_206870_a((IProperty)IGNITED, (Comparable)ignited));
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return SHAPE;
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)this.func_176223_P().func_206870_a((IProperty)FACING, (Comparable)context.func_195992_f().func_176734_d());
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (facing.func_176734_d() == stateIn.func_177229_b((IProperty)FACING) && !stateIn.func_196955_c((IWorldReader)worldIn, currentPos)) {
            return Blocks.field_150350_a.func_176223_P();
        }
        return super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public BlockState func_185499_a(BlockState state, Rotation rot) {
        return (BlockState)state.func_206870_a((IProperty)FACING, (Comparable)rot.func_185831_a((Direction)state.func_177229_b((IProperty)FACING)));
    }

    public BlockState func_185471_a(BlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((Direction)state.func_177229_b((IProperty)FACING)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{FACING, COOKING, IGNITED});
    }

    public float func_220080_a(BlockState state, IBlockReader worldIn, BlockPos pos) {
        return 0.6f;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_229870_f_(BlockState state, IBlockReader worldIn, BlockPos pos) {
        return false;
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return ((TileEntityType)ModTileEntityTypes.KETTLE.get()).func_200968_a();
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        TileEntity tile;
        if (worldIn != null && !worldIn.field_72995_K && (tile = worldIn.func_175625_s(pos)) instanceof KettleTileEntity) {
            if (player.func_184586_b(player.field_184622_au) != null) {
                ((KettleTileEntity)tile).useItem(player.func_184586_b(player.field_184622_au).func_77973_b(), player);
            } else {
                ((KettleTileEntity)tile).attemptCook();
            }
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.SUCCESS;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        if (((Boolean)stateIn.func_177229_b((IProperty)COOKING)).booleanValue()) {
            if (rand.nextInt(10) == 0) {
                worldIn.func_184134_a((double)((float)pos.func_177958_n() + 0.5f), (double)((float)pos.func_177956_o() + 0.5f), (double)((float)pos.func_177952_p() + 0.5f), SoundEvents.field_219605_aC, SoundCategory.BLOCKS, 0.5f + rand.nextFloat(), rand.nextFloat() * 0.7f + 0.6f, false);
            }
            if (rand.nextInt(5) == 0) {
                worldIn.func_195594_a((IParticleData)ParticleTypes.field_218417_ae, (double)((float)pos.func_177958_n() + 0.5f), (double)((float)pos.func_177956_o() + 0.5f), (double)((float)pos.func_177952_p() + 0.5f), 0.0, 0.0, 0.0);
            }
        }
        if (((Boolean)stateIn.func_177229_b((IProperty)IGNITED)).booleanValue()) {
            if (rand.nextInt(10) == 0) {
                worldIn.func_184134_a((double)((float)pos.func_177958_n() + 0.5f), (double)((float)pos.func_177956_o() + 0.5f), (double)((float)pos.func_177952_p() + 0.5f), SoundEvents.field_187652_bv, SoundCategory.BLOCKS, 0.5f + rand.nextFloat(), rand.nextFloat() * 0.7f + 0.6f, false);
            }
            if (rand.nextInt(5) == 0) {
                worldIn.func_195594_a((IParticleData)ParticleTypes.field_197601_L, (double)((float)pos.func_177958_n() + 0.5f), (double)((float)pos.func_177956_o() + 0.5f), (double)((float)pos.func_177952_p() + 0.5f), 0.0, 0.0, 0.0);
            }
        }
    }
}

