/*
 * Decompiled with CFR 0.152.
 */
package mod.yourmediocrepal.noel.blocks;

import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.HorizontalFaceBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.AttachFace;
import net.minecraft.util.Direction;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class BlockOrnament
extends HorizontalFaceBlock {
    protected static final VoxelShape FLOOR = Block.func_208617_a((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)6.0, (double)11.0);
    protected static final VoxelShape CEILING = Block.func_208617_a((double)5.0, (double)9.0, (double)5.0, (double)11.0, (double)15.0, (double)11.0);
    protected static final VoxelShape SHAPE_WALL_NORTH = Block.func_208617_a((double)5.0, (double)5.0, (double)10.0, (double)11.0, (double)11.0, (double)16.0);
    protected static final VoxelShape SHAPE_WALL_SOUTH = Block.func_208617_a((double)5.0, (double)5.0, (double)0.0, (double)11.0, (double)11.0, (double)6.0);
    protected static final VoxelShape SHAPE_WALL_EAST = Block.func_208617_a((double)0.0, (double)5.0, (double)5.0, (double)6.0, (double)11.0, (double)11.0);
    protected static final VoxelShape SHAPE_WALL_WEST = Block.func_208617_a((double)10.0, (double)5.0, (double)5.0, (double)16.0, (double)11.0, (double)11.0);

    public BlockOrnament() {
        super(Block.Properties.func_200945_a((Material)Material.field_151594_q).func_200948_a(0.3f, 0.3f).func_200947_a(SoundType.field_185853_f).func_226896_b_());
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)field_185512_D, (Comparable)Direction.NORTH)).func_206870_a((IProperty)field_196366_M, (Comparable)AttachFace.WALL));
    }

    @OnlyIn(value=Dist.CLIENT)
    public float func_220080_a(BlockState state, IBlockReader worldIn, BlockPos pos) {
        return 1.0f;
    }

    public boolean func_220081_d(BlockState state, IBlockReader worldIn, BlockPos pos) {
        return false;
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.MODEL;
    }

    private VoxelShape getShapeFromState(BlockState state) {
        Direction direction = (Direction)state.func_177229_b((IProperty)field_185512_D);
        switch ((AttachFace)state.func_177229_b((IProperty)field_196366_M)) {
            case FLOOR: {
                return FLOOR;
            }
            case WALL: {
                if (direction == Direction.NORTH) {
                    return SHAPE_WALL_NORTH;
                }
                if (direction == Direction.SOUTH) {
                    return SHAPE_WALL_SOUTH;
                }
                if (direction == Direction.EAST) {
                    return SHAPE_WALL_EAST;
                }
                return SHAPE_WALL_WEST;
            }
            case CEILING: {
                return CEILING;
            }
        }
        return CEILING;
    }

    public VoxelShape func_220071_b(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return this.getShapeFromState(state);
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return this.getShapeFromState(state);
    }

    public boolean func_196260_a(BlockState state, IWorldReader worldIn, BlockPos pos) {
        return true;
    }

    public BlockState func_185499_a(BlockState state, Rotation rot) {
        return (BlockState)state.func_206870_a((IProperty)field_185512_D, (Comparable)rot.func_185831_a((Direction)state.func_177229_b((IProperty)field_185512_D)));
    }

    public BlockState func_185471_a(BlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((Direction)state.func_177229_b((IProperty)field_185512_D)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{field_185512_D, field_196366_M});
    }

    public boolean func_196266_a(BlockState state, IBlockReader worldIn, BlockPos pos, PathType type) {
        return false;
    }
}

