/*
 * Decompiled with CFR 0.152.
 */
package mod.yourmediocrepal.noel.tileentity;

import mod.yourmediocrepal.noel.blocks.BlockKettle;
import mod.yourmediocrepal.noel.tileentity.ModTileEntityTypes;
import mod.yourmediocrepal.noel.util.NoelItemHandler;
import mod.yourmediocrepal.noel.util.RegistryHandler;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;

public class KettleTileEntity
extends TileEntity
implements ITickableTileEntity {
    public int currentSmeltTime;
    private final int maxSmeltTime = 100;
    private NoelItemHandler inventory;
    private boolean hasMilk;
    private boolean hasCocoa;
    private boolean hasHotCocoa;
    private boolean canCook = true;
    private int ignitionTime;
    private boolean isCooking;
    private String activeParticle;

    public KettleTileEntity(TileEntityType<?> tileEntityTypeIn) {
        super(tileEntityTypeIn);
    }

    public KettleTileEntity() {
        this((TileEntityType)ModTileEntityTypes.KETTLE.get());
    }

    public void useItem(Item item, PlayerEntity player) {
        if (item == Items.field_151033_d.getItem() || item == Items.field_151059_bz) {
            this.ignitionTime = 400;
            this.playSound(SoundEvents.field_187649_bu);
            System.out.println("Used flint...");
        } else if (item == Items.field_196130_bo && !this.hasCocoa) {
            this.hasCocoa = true;
            this.playSound(SoundEvents.field_187624_K);
            if (!player.func_184812_l_()) {
                player.func_184586_b(player.field_184622_au).func_190918_g(1);
            }
            System.out.println("Used Cocoa...");
        } else if (item == Items.field_151117_aB && !this.hasMilk) {
            this.playSound(SoundEvents.field_187624_K);
            this.hasMilk = true;
            if (!player.func_184812_l_()) {
                player.func_184611_a(player.field_184622_au, new ItemStack((IItemProvider)Items.field_151133_ar));
            }
            System.out.println("Used Milk...");
        } else if (item == RegistryHandler.MUG.get() && this.hasHotCocoa) {
            player.func_184611_a(player.field_184622_au, new ItemStack((IItemProvider)RegistryHandler.HOT_CHOCHOLATE.get()));
            this.playSound(SoundEvents.field_187630_M);
            this.canCook = true;
            this.hasHotCocoa = false;
            System.out.println("Used Mug...");
        }
        this.attemptCook();
    }

    public void attemptCook() {
        if (this.hasMilk && this.hasCocoa && this.ignitionTime > 0 && this.canCook) {
            BlockState blockstate;
            Block block;
            this.canCook = false;
            this.isCooking = true;
            System.out.println("Attempt to Cook...");
            if (this.field_145850_b != null && !this.field_145850_b.field_72995_K && (block = (blockstate = this.func_195044_w()).func_177230_c()) instanceof BlockKettle) {
                BlockKettle.updateState(blockstate, this.field_145850_b, this.field_174879_c, this.isCooking, this.getIgnition());
            }
        }
    }

    public boolean getIsCooking() {
        return this.isCooking;
    }

    public boolean getHasHotCocoa() {
        return this.hasHotCocoa;
    }

    public boolean getIgnition() {
        return this.ignitionTime >= 1;
    }

    public void func_73660_a() {
        boolean dirty = false;
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            BlockState blockstate;
            Block block;
            if (this.isCooking) {
                if (this.currentSmeltTime != this.maxSmeltTime) {
                    this.activeParticle = "CLOUD";
                    ++this.currentSmeltTime;
                    System.out.println("Smelting...");
                    dirty = true;
                } else {
                    this.hasHotCocoa = true;
                    this.hasMilk = false;
                    this.hasCocoa = false;
                    this.currentSmeltTime = 0;
                    this.isCooking = false;
                    this.activeParticle = "HAPPY_VILLAGER";
                    this.currentSmeltTime = 0;
                    this.playSound(SoundEvents.field_187646_bt);
                    System.out.println("Done!");
                    dirty = true;
                }
            }
            if (this.ignitionTime >= 0) {
                --this.ignitionTime;
                dirty = true;
            }
            if ((block = (blockstate = this.func_195044_w()).func_177230_c()) instanceof BlockKettle) {
                BlockKettle.updateState(blockstate, this.field_145850_b, this.field_174879_c, this.isCooking, this.getIgnition());
            }
        }
    }

    public int getIgnitionTime() {
        return this.ignitionTime;
    }

    public void playSound(SoundEvent soundEvent) {
        this.field_145850_b.func_184133_a((PlayerEntity)null, this.field_174879_c, soundEvent, SoundCategory.BLOCKS, 1.0f, 1.0f);
    }

    public void func_145839_a(CompoundNBT compound) {
        super.func_145839_a(compound);
        this.canCook = compound.func_74767_n("CanCook");
        this.hasMilk = compound.func_74767_n("HasMilk");
        this.hasCocoa = compound.func_74767_n("HasCocoa");
        this.hasHotCocoa = compound.func_74767_n("HasHotCocoa");
        this.isCooking = compound.func_74767_n("IsCooking");
        this.currentSmeltTime = compound.func_74762_e("CurrentSmeltTime");
        this.ignitionTime = compound.func_74762_e("IgnitionTime");
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        compound.func_74757_a("CanCook", this.canCook);
        compound.func_74757_a("HasMilk", this.hasMilk);
        compound.func_74757_a("HasCocoa", this.hasCocoa);
        compound.func_74757_a("HasHotCocoa", this.hasHotCocoa);
        compound.func_74757_a("IsCooking", this.isCooking);
        compound.func_74768_a("CurrentSmeltTime", this.currentSmeltTime);
        compound.func_74768_a("IgnitionTime", this.ignitionTime);
        return compound;
    }
}

