/*
 * Decompiled with CFR 0.152.
 */
package com.willr27.blocklings.client.gui;

import com.willr27.blocklings.Blocklings;
import com.willr27.blocklings.client.gui.containers.EquipmentContainer;
import com.willr27.blocklings.client.gui.screens.EquipmentScreen;
import com.willr27.blocklings.client.gui.screens.SkillsScreen;
import com.willr27.blocklings.client.gui.screens.StatsScreen;
import com.willr27.blocklings.client.gui.screens.TasksScreen;
import com.willr27.blocklings.entity.blockling.BlocklingEntity;
import com.willr27.blocklings.entity.blockling.skill.BlocklingSkills;
import com.willr27.blocklings.network.BlocklingMessage;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class BlocklingGuiHandler {
    public static final int STATS_ID = 0;
    public static final int TASKS_ID = 1;
    public static final int EQUIPMENT_ID = 2;
    public static final int GENERAL_ID = 4;
    public static final int COMBAT_ID = 5;
    public static final int MINING_ID = 6;
    public static final int WOODCUTTING_ID = 7;
    public static final int FARMING_ID = 8;
    @Nonnull
    public final BlocklingEntity blockling;
    private int recentGuiId = 0;

    public BlocklingGuiHandler(@Nonnull BlocklingEntity blockling) {
        this.blockling = blockling;
    }

    public void openGui(@Nonnull PlayerEntity player) {
        this.openGui(this.recentGuiId, -1, player);
    }

    public void openGui(int guiId, @Nonnull PlayerEntity player) {
        this.openGui(guiId, -1, player);
    }

    private void openGui(int guiId, int windowId, @Nonnull PlayerEntity player) {
        if (!this.blockling.field_70170_p.func_201670_d()) {
            this.recentGuiId = guiId;
            ServerPlayerEntity serverPlayer = (ServerPlayerEntity)player;
            serverPlayer.func_71117_bO();
            windowId = serverPlayer.field_71139_cq;
            Container container = this.createContainer(guiId, windowId, player);
            if (container != null) {
                player.field_71070_bA = container;
            }
            new OpenMessage(this.blockling, guiId, windowId, player.func_110124_au()).sendToClient(player);
        } else {
            this.recentGuiId = guiId;
            if (windowId == -1) {
                new OpenMessage(this.blockling, guiId, windowId, player.func_110124_au()).sendToServer();
                return;
            }
            Container container = this.createContainer(guiId, windowId, player);
            if (container != null) {
                player.field_71070_bA = container;
            }
            this.openScreen(guiId, player, container);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void openScreen(int guiId, @Nonnull PlayerEntity player, @Nullable Container container) {
        Screen screen = this.createScreen(guiId, container, player);
        if (screen != null) {
            Minecraft.func_71410_x().func_147108_a(screen);
        } else {
            Blocklings.LOGGER.warn("No screen exists for gui id: " + guiId);
        }
    }

    @Nullable
    private Container createContainer(int guiId, int windowId, @Nonnull PlayerEntity player) {
        switch (guiId) {
            case 2: {
                return new EquipmentContainer(windowId, player, this.blockling);
            }
        }
        return null;
    }

    @OnlyIn(value=Dist.CLIENT)
    @Nullable
    private Screen createScreen(int guiId, @Nullable Container container, @Nonnull PlayerEntity player) {
        switch (guiId) {
            case 0: {
                return new StatsScreen(this.blockling);
            }
            case 1: {
                return new TasksScreen(this.blockling);
            }
            case 2: {
                return new EquipmentScreen((EquipmentContainer)container, this.blockling);
            }
            case 4: {
                return new SkillsScreen(this.blockling, BlocklingSkills.Groups.GENERAL);
            }
            case 5: {
                return new SkillsScreen(this.blockling, BlocklingSkills.Groups.COMBAT);
            }
            case 6: {
                return new SkillsScreen(this.blockling, BlocklingSkills.Groups.MINING);
            }
            case 7: {
                return new SkillsScreen(this.blockling, BlocklingSkills.Groups.WOODCUTTING);
            }
            case 8: {
                return new SkillsScreen(this.blockling, BlocklingSkills.Groups.FARMING);
            }
        }
        return null;
    }

    public int getRecentGuiId() {
        return this.recentGuiId;
    }

    public static class OpenMessage
    extends BlocklingMessage<OpenMessage> {
        private int guiId;
        private int windowId;
        private UUID playerId;

        public OpenMessage() {
            super(null);
        }

        public OpenMessage(@Nonnull BlocklingEntity blockling, int guiId, int windowId, @Nonnull UUID playerId) {
            super(blockling, false);
            this.guiId = guiId;
            this.windowId = windowId;
            this.playerId = playerId;
        }

        @Override
        public void encode(@Nonnull PacketBuffer buf) {
            super.encode(buf);
            buf.writeInt(this.guiId);
            buf.writeInt(this.windowId);
            buf.func_179252_a(this.playerId);
        }

        @Override
        public void decode(@Nonnull PacketBuffer buf) {
            super.decode(buf);
            this.guiId = buf.readInt();
            this.windowId = buf.readInt();
            this.playerId = buf.func_179253_g();
        }

        @Override
        protected void handle(@Nonnull PlayerEntity player, @Nonnull BlocklingEntity blockling) {
            if (blockling.field_70170_p.func_201670_d()) {
                blockling.guiHandler.openGui(this.guiId, this.windowId, player);
            } else {
                PlayerEntity targetedPlayer = blockling.field_70170_p.func_217369_A().stream().filter(serverPlayer -> serverPlayer.func_110124_au().equals(this.playerId)).findFirst().orElse(null);
                if (targetedPlayer != null) {
                    blockling.guiHandler.openGui(this.guiId, this.windowId, targetedPlayer);
                } else {
                    Blocklings.LOGGER.warn("Tried opening a gui for a player that does not exist on the server with id: " + this.playerId);
                }
            }
        }
    }
}

