/*
 * Decompiled with CFR 0.152.
 */
package com.willr27.blocklings.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.Color;
import javax.annotation.Nonnull;

public class Colour {
    private float r;
    private float g;
    private float b;
    private float a;

    public Colour(@Nonnull Color colour) {
        this.setColour(colour);
    }

    public Colour(float r, float g, float b) {
        this(r, g, b, 1.0f);
    }

    public Colour(float r, float g, float b, float a) {
        this.r = r;
        this.g = g;
        this.b = b;
        this.a = a;
    }

    public void apply() {
        RenderSystem.color4f((float)this.r, (float)this.g, (float)this.b, (float)this.a);
    }

    public void setColour(@Nonnull Color colour) {
        this.r = (float)colour.getRed() / 255.0f;
        this.g = (float)colour.getGreen() / 255.0f;
        this.b = (float)colour.getBlue() / 255.0f;
        this.a = (float)colour.getAlpha() / 255.0f;
    }

    public float getR() {
        return this.r;
    }

    public float getG() {
        return this.g;
    }

    public float getB() {
        return this.b;
    }

    public float getA() {
        return this.a;
    }

    public void setR(float r) {
        this.r = r;
    }

    public void setG(float g) {
        this.g = g;
    }

    public void setB(float b) {
        this.b = b;
    }

    public void setA(float a) {
        this.a = a;
    }
}

