/*
 * Decompiled with CFR 0.152.
 */
package com.willr27.blocklings.client.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.willr27.blocklings.client.gui.Colour;
import com.willr27.blocklings.client.gui.GuiTexture;
import com.willr27.blocklings.client.gui.GuiUtil;
import com.willr27.blocklings.client.gui.IControl;
import com.willr27.blocklings.client.gui.IScreen;
import com.willr27.blocklings.client.gui.controls.common.ScrollbarControl;
import com.willr27.blocklings.util.event.EventHandler;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class Control
extends AbstractGui
implements IControl {
    @Nonnull
    public final Screen screen;
    @Nonnull
    public final FontRenderer font;
    @Nullable
    public IControl parent;
    @Nonnull
    protected final ArrayList<Control> children = new ArrayList();
    @Nullable
    protected ScrollbarControl scrollbarControlY = null;
    @Nonnull
    private Colour backgroundColour = new Colour(Color.white);
    @Nonnull
    private Colour foregroundColour = new Colour(Color.white);
    private int x;
    private int y;
    private int scrollX;
    private int scrollY;
    private int maxScrollX;
    private int maxScrollY;
    public int screenX;
    public int screenY;
    public int width;
    public int height;
    private float scale;
    private final Map<IControl.Side, Integer> padding = new HashMap<IControl.Side, Integer>(4);
    private final Map<IControl.Side, Integer> margins = new HashMap<IControl.Side, Integer>(4);
    private boolean isVisible = true;
    private boolean isInteractive = true;
    private boolean isScrollableX = false;
    private boolean isScrollableY = false;
    private final EventHandler<IControl.MouseEvent> onControlHover = new EventHandler();
    private final EventHandler<IControl.MouseEvent> onControlHoverStart = new EventHandler();
    private final EventHandler<IControl.MouseEvent> onControlHoverStop = new EventHandler();
    private final EventHandler<IControl.MouseButtonEvent> onControlMouseClicked = new EventHandler();
    private final EventHandler<IControl.MouseButtonEvent> onControlMouseReleased = new EventHandler();
    private final EventHandler<IControl.MouseScrollEvent> onControlMouseScrolled = new EventHandler();
    private final EventHandler<IControl.KeyEvent> onControlKeyPressed = new EventHandler();
    private final EventHandler<IControl.KeyEvent> onControlKeyReleased = new EventHandler();
    private final EventHandler<IControl.KeyEvent> onControlKeyHeld = new EventHandler();
    private final EventHandler<IControl.CharEvent> onControlCharTyped = new EventHandler();

    public Control() {
        this(null, 0, 0, 0, 0);
    }

    public Control(@Nullable IControl parent, int x, int y, int width, int height) {
        this.screen = Objects.requireNonNull(Minecraft.func_71410_x().field_71462_r);
        this.font = Minecraft.func_71410_x().field_71466_p;
        this.scale = 1.0f;
        this.padding.put(IControl.Side.LEFT, 0);
        this.padding.put(IControl.Side.TOP, 0);
        this.padding.put(IControl.Side.RIGHT, 0);
        this.padding.put(IControl.Side.BOTTOM, 0);
        this.margins.put(IControl.Side.LEFT, 0);
        this.margins.put(IControl.Side.TOP, 0);
        this.margins.put(IControl.Side.RIGHT, 0);
        this.margins.put(IControl.Side.BOTTOM, 0);
        this.setParent(parent);
        this.setX(x);
        this.setY(y);
        this.setWidth(width);
        this.setHeight(height);
        this.setupEventHandlers();
    }

    public void remove() {
        this.parent.removeChild(this);
    }

    @Override
    public void render(@Nonnull MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
    }

    public void renderTexture(@Nonnull MatrixStack matrixStack, @Nonnull GuiTexture texture) {
        this.renderTexture(matrixStack, 0, 0, texture);
    }

    public void renderTexture(@Nonnull MatrixStack matrixStack, int dx, int dy, @Nonnull GuiTexture texture) {
        GuiUtil.bindTexture(texture.texture);
        this.renderTexture(matrixStack, texture, this.screenX + dx, this.screenY + dy);
    }

    public void renderTexture(@Nonnull MatrixStack matrixStack, @Nonnull GuiTexture texture, int x, int y) {
        GuiUtil.bindTexture(texture.texture);
        this.func_238474_b_(matrixStack, x, y, texture.x, texture.y, texture.width, texture.height);
    }

    public void renderText(MatrixStack matrixStack, String text, int dx, int dy, boolean right, int colour) {
        int bonusX = right ? -this.font.func_78256_a(text) - dx + this.width : dx;
        this.font.func_238421_b_(matrixStack, text, (float)(this.screenX + bonusX), (float)(this.screenY + dy), colour);
        RenderSystem.enableDepthTest();
    }

    public void renderShadowedText(MatrixStack matrixStack, String text, int dx, int dy, boolean right, int colour) {
        int bonusX = right ? -this.font.func_78256_a(text) - dx + this.width : dx;
        this.font.func_238405_a_(matrixStack, text, (float)(this.screenX + bonusX), (float)(this.screenY + dy), colour);
        RenderSystem.enableDepthTest();
    }

    public void renderCenteredText(MatrixStack matrixStack, String text, int dx, int dy, boolean right, int colour) {
        int bonusX = right ? -dx : this.width + dx;
        Control.func_238471_a_((MatrixStack)matrixStack, (FontRenderer)this.font, (String)text, (int)(this.screenX + bonusX), (int)(this.screenY + dy), (int)colour);
        RenderSystem.enableDepthTest();
    }

    public void resetRenderColour() {
        this.setRenderColour(Color.white);
    }

    public void setRenderColour(@Nonnull Color colour) {
        new Colour(colour).apply();
    }

    public void setRenderColour(float r, float g, float b) {
        new Colour(r, g, b).apply();
    }

    public void setRenderColour(float r, float g, float b, float a) {
        new Colour(r, g, b, a).apply();
    }

    @Override
    public ScrollbarControl getScrollbarY() {
        return this.scrollbarControlY != null ? this.scrollbarControlY : (this.parent != null ? this.parent.getScrollbarY() : null);
    }

    @Override
    public void setScrollbarY(@Nullable ScrollbarControl scrollbarControlY) {
        this.scrollbarControlY = scrollbarControlY;
    }

    @Nonnull
    public Colour getBackgroundColour() {
        return this.backgroundColour;
    }

    public void setBackgroundColour(float r, float g, float b) {
        this.backgroundColour = new Colour(r, g, b);
    }

    @Nonnull
    public Colour getForegroundColour() {
        return this.foregroundColour;
    }

    public void setForegroundColour(float r, float g, float b) {
        this.foregroundColour = new Colour(r, g, b);
    }

    public int toLocalX(int x) {
        return x - this.screenX;
    }

    public int toLocalY(int y) {
        return y - this.screenY;
    }

    public boolean isMouseOver(int mouseX, int mouseY, float scale) {
        return GuiUtil.isMouseOver((int)((float)mouseX / scale), (int)((float)mouseY / scale), this.screenX, this.screenY, this.width, this.height);
    }

    public boolean isTopControlWithMouseOver(int mouseX, int mouseY) {
        boolean hasChildWithMouseOver = this.children.stream().anyMatch(control -> control.isTopControlWithMouseOver(mouseX, mouseY));
        return !hasChildWithMouseOver && GuiUtil.isMouseOver(mouseX, mouseY, this.screenX, this.screenY, this.width, this.height);
    }

    @Override
    @Nonnull
    public IScreen getScreen() {
        return (IScreen)this.screen;
    }

    @Override
    @Nullable
    public IControl getParent() {
        return this.parent;
    }

    @Override
    public void setParent(@Nullable IControl parent) {
        if (this.parent != null) {
            this.parent.removeChild(this);
        }
        this.parent = parent;
        if (this.parent != null) {
            this.parent.addChild(this);
        }
    }

    @Override
    @Nonnull
    public ArrayList<Control> getChildren() {
        return this.children;
    }

    @Override
    public void addChild(@Nonnull Control control) {
        if (!this.children.contains(control)) {
            this.children.add(control);
            control.parent = this;
        }
    }

    @Override
    public void removeChild(@Nullable Control control) {
        if (control != null) {
            control.parent = null;
            this.children.remove(control);
        }
    }

    public int getX() {
        return this.x;
    }

    public void setX(int x) {
        this.x = x;
        this.recalcScreenX();
    }

    public int getY() {
        return this.y;
    }

    public void setY(int y) {
        this.y = y;
        this.recalcScreenY();
    }

    @Override
    public int getScrollX() {
        return this.scrollX;
    }

    @Override
    public void setScrollX(int scroll) {
        this.scrollX = this.isScrollableX ? scroll : 0;
        this.scrollX = Math.min(this.scrollX, this.maxScrollX);
        this.scrollX = Math.max(this.scrollX, 0);
        this.recalcScreenX();
    }

    @Override
    public int getScrollY() {
        return this.scrollY;
    }

    @Override
    public void setScrollY(int scroll) {
        this.scrollY = this.isScrollableY ? scroll : 0;
        this.scrollY = Math.min(this.scrollY, this.maxScrollY);
        this.scrollY = Math.max(this.scrollY, 0);
        this.recalcScreenY();
    }

    @Override
    public int getMaxScrollX() {
        return this.maxScrollX;
    }

    @Override
    public void setMaxScrollX(int maxScroll) {
        this.maxScrollX = maxScroll;
        this.setScrollX(this.getScrollX());
    }

    @Override
    public int getMaxScrollY() {
        return this.maxScrollY;
    }

    @Override
    public void setMaxScrollY(int maYScroll) {
        this.maxScrollY = maYScroll;
        this.setScrollY(this.getScrollY());
    }

    public void recalcScreenX() {
        int parentOffset = 0;
        if (this.parent != null) {
            parentOffset = (int)((float)this.parent.getScreenX() - (float)(this.parent.getScrollX() - this.parent.getPadding(IControl.Side.LEFT)) * this.parent.getEffectiveScale());
        }
        this.screenX = parentOffset + (int)((float)(this.getMargin(IControl.Side.LEFT) + this.x) * this.getEffectiveScale());
        this.getChildren().forEach(Control::recalcScreenX);
    }

    @Override
    public int getScreenX() {
        return this.screenX;
    }

    public void recalcScreenY() {
        int parentOffset = 0;
        if (this.parent != null) {
            parentOffset = (int)((float)this.parent.getScreenY() - (float)(this.parent.getScrollY() - this.parent.getPadding(IControl.Side.TOP)) * this.parent.getEffectiveScale());
        }
        this.screenY = parentOffset + (int)((float)(this.getMargin(IControl.Side.TOP) + this.y) * this.getEffectiveScale());
        this.getChildren().forEach(Control::recalcScreenY);
    }

    @Override
    public int getScreenY() {
        return this.screenY;
    }

    public int getEffectiveWidth() {
        return this.width + this.getMargin(IControl.Side.LEFT) + this.getMargin(IControl.Side.RIGHT);
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getEffectiveHeight() {
        return this.height + this.getMargin(IControl.Side.TOP) + this.getMargin(IControl.Side.BOTTOM);
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    @Override
    public float getScale() {
        return this.scale;
    }

    @Override
    public void setScale(float scale) {
        this.scale = scale;
        this.recalcScreenX();
        this.recalcScreenY();
    }

    @Override
    public int getPadding(@Nonnull IControl.Side side) {
        return this.padding.get((Object)side);
    }

    @Override
    public void setPadding(@Nonnull IControl.Side side, int padding) {
        this.padding.put(side, padding);
        if (side == IControl.Side.LEFT || side == IControl.Side.RIGHT) {
            this.recalcScreenX();
        } else {
            this.recalcScreenY();
        }
    }

    public void setPadding(int left, int top, int right, int bottom) {
        this.padding.put(IControl.Side.LEFT, left);
        this.padding.put(IControl.Side.TOP, top);
        this.padding.put(IControl.Side.RIGHT, right);
        this.padding.put(IControl.Side.BOTTOM, bottom);
        this.recalcScreenX();
        this.recalcScreenY();
    }

    @Override
    public int getMargin(@Nonnull IControl.Side side) {
        return this.margins.get((Object)side);
    }

    @Override
    public void setMargin(@Nonnull IControl.Side side, int margin) {
        this.margins.put(side, margin);
        if (side == IControl.Side.LEFT || side == IControl.Side.RIGHT) {
            this.recalcScreenX();
        } else {
            this.recalcScreenY();
        }
    }

    @Override
    public void setMargins(int left, int top, int right, int bottom) {
        this.margins.put(IControl.Side.LEFT, left);
        this.margins.put(IControl.Side.TOP, top);
        this.margins.put(IControl.Side.RIGHT, right);
        this.margins.put(IControl.Side.BOTTOM, bottom);
        this.recalcScreenX();
        this.recalcScreenY();
    }

    @Override
    public boolean isInteractive() {
        return this.isInteractive;
    }

    @Override
    public void setIsInteractive(boolean isInteractive) {
        this.isInteractive = isInteractive;
    }

    @Override
    public boolean isVisible() {
        return this.isVisible;
    }

    @Override
    public void setIsVisible(boolean isVisible) {
        this.isVisible = isVisible;
    }

    @Override
    public boolean isScrollableX() {
        return this.isScrollableX;
    }

    @Override
    public void setIsScrollableX(boolean isScrollable) {
        this.isScrollableX = isScrollable;
        if (!this.isScrollableX) {
            this.setScrollX(0);
        }
    }

    @Override
    public boolean isScrollableY() {
        return this.isScrollableY;
    }

    @Override
    public void setIsScrollableY(boolean isScrollable) {
        this.isScrollableY = isScrollable;
        if (!this.isScrollableY) {
            this.setScrollY(0);
        }
    }

    public void setZIndex(int index) {
        if (this.parent == null) {
            return;
        }
        ArrayList<Control> children = this.parent.getChildren();
        if (index > children.size()) {
            index = children.size();
        } else if (index < 0) {
            index = 0;
        }
        children.ensureCapacity(index + 1);
        children.set(children.indexOf(this), null);
        children.add(index, this);
        children.remove(null);
    }

    @Override
    @Nonnull
    public EventHandler<IControl.MouseEvent> getOnControlHover() {
        return this.onControlHover;
    }

    @Override
    @Nonnull
    public EventHandler<IControl.MouseEvent> getOnControlHoverStart() {
        return this.onControlHoverStart;
    }

    @Override
    @Nonnull
    public EventHandler<IControl.MouseEvent> getOnControlHoverStop() {
        return this.onControlHoverStop;
    }

    @Override
    @Nonnull
    public EventHandler<IControl.MouseButtonEvent> getOnControlMouseClicked() {
        return this.onControlMouseClicked;
    }

    @Override
    @Nonnull
    public EventHandler<IControl.MouseButtonEvent> getOnControlMouseReleased() {
        return this.onControlMouseReleased;
    }

    @Override
    @Nonnull
    public EventHandler<IControl.MouseScrollEvent> getOnControlMouseScrolled() {
        return this.onControlMouseScrolled;
    }

    @Override
    @Nonnull
    public EventHandler<IControl.KeyEvent> getOnControlKeyPressed() {
        return this.onControlKeyPressed;
    }

    @Override
    @Nonnull
    public EventHandler<IControl.KeyEvent> getOnControlKeyReleased() {
        return this.onControlKeyReleased;
    }

    @Override
    @Nonnull
    public EventHandler<IControl.KeyEvent> getOnControlKeyHeld() {
        return this.onControlKeyHeld;
    }

    @Override
    @Nonnull
    public EventHandler<IControl.CharEvent> getOnControlCharTyped() {
        return this.onControlCharTyped;
    }
}

