/*
 * Decompiled with CFR 0.152.
 */
package com.willr27.blocklings.client.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.util.InputMappings;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IReorderingProcessor;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.lwjgl.opengl.GL11;

@OnlyIn(value=Dist.CLIENT)
public class GuiUtil {
    public static int minScissorX;
    public static int minScissorY;
    public static int maxScissorX;
    public static int maxScissorY;
    private static List<ScissorBounds> stackedScissors;
    public static boolean useGuiScaleForScissor;

    public static int getMouseX() {
        return (int)Minecraft.func_71410_x().field_71417_B.func_198024_e();
    }

    public static int getMouseY() {
        return (int)Minecraft.func_71410_x().field_71417_B.func_198026_f();
    }

    public static void bindTexture(ResourceLocation texture) {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(texture);
    }

    public static boolean isCloseInventoryKey(int keyCode) {
        return keyCode == 256 || keyCode == Minecraft.func_71410_x().field_71474_y.field_151445_Q.getKey().func_197937_c();
    }

    public static List<String> splitText(FontRenderer font, String text, int maxWidth) {
        ArrayList<String> outText = new ArrayList<String>();
        String tempString = text;
        while (font.func_78256_a(tempString) > maxWidth) {
            int i;
            String trim = font.func_238412_a_(tempString, maxWidth);
            if (tempString.substring(trim.length(), trim.length() + 1) != " " && (i = trim.lastIndexOf(" ")) != -1) {
                trim = trim.substring(0, i);
            }
            outText.add(trim);
            tempString = tempString.substring(trim.length() + 1);
        }
        outText.add(tempString);
        return outText;
    }

    public static List<StringTextComponent> splitText(FontRenderer font, ITextComponent text, int maxWidth) {
        return GuiUtil.splitText(font, text.getString(), maxWidth).stream().map(s -> new StringTextComponent(s)).collect(Collectors.toList());
    }

    public static List<IReorderingProcessor> toReorderingProcessorList(List<? extends ITextComponent> list) {
        return list.stream().map(iTextComponent -> iTextComponent.func_241878_f()).collect(Collectors.toList());
    }

    public static String trimWithEllipses(FontRenderer font, String text, int maxWidth) {
        String trimmed = GuiUtil.trim(font, text, maxWidth);
        if (!trimmed.equals(text)) {
            return GuiUtil.appendOrReplace(font, trimmed, "...", maxWidth);
        }
        return trimmed;
    }

    public static String trim(FontRenderer font, String text, int maxWidth) {
        return font.func_238417_a_((ITextProperties)new StringTextComponent(text), maxWidth).getString();
    }

    public static String appendOrReplace(FontRenderer font, String text, String replace, int maxWidth) {
        int replaceWidth = font.func_78256_a(replace);
        int cumulativeWidth = 0;
        while (cumulativeWidth < replaceWidth && text.length() != 0 && font.func_78256_a(text + replace) > maxWidth) {
            cumulativeWidth += font.func_78256_a(text.substring(text.length() - 1));
            text = text.substring(0, text.length() - 1);
        }
        return text + replace;
    }

    public static boolean isKeyDown(int key) {
        return InputMappings.func_216506_a((long)Minecraft.func_71410_x().func_228018_at_().func_198092_i(), (int)key);
    }

    public static boolean isMouseOver(int mouseX, int mouseY, int left, int top, int width, int height) {
        return mouseX >= left && mouseX < left + width && mouseY >= top && mouseY <= top + height;
    }

    public static void renderItemStack(MatrixStack matrixStack, ItemStack stack, int x, int y, int i) {
        boolean flag;
        ItemRenderer itemRenderer = Minecraft.func_71410_x().func_175599_af();
        RenderSystem.pushMatrix();
        Minecraft.func_71410_x().field_71446_o.func_110577_a(AtlasTexture.field_110575_b);
        Minecraft.func_71410_x().field_71446_o.func_229267_b_(AtlasTexture.field_110575_b).func_174937_a(false, false);
        RenderSystem.enableRescaleNormal();
        RenderSystem.enableAlphaTest();
        RenderSystem.defaultAlphaFunc();
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.translatef((float)((float)x + 7.0f), (float)((float)y + 7.0f), (float)100.0f);
        RenderSystem.translatef((float)8.0f, (float)8.0f, (float)0.0f);
        RenderSystem.scalef((float)1.0f, (float)-1.0f, (float)1.0f);
        RenderSystem.scalef((float)24.0f, (float)24.0f, (float)24.0f);
        MatrixStack matrixstack = new MatrixStack();
        IRenderTypeBuffer.Impl irendertypebuffer$impl = Minecraft.func_71410_x().func_228019_au_().func_228487_b_();
        boolean bl = flag = !itemRenderer.func_184393_a(stack, null, null).func_230044_c_();
        if (flag) {
            RenderHelper.func_227783_c_();
        }
        itemRenderer.func_229111_a_(stack, ItemCameraTransforms.TransformType.GUI, false, matrixstack, (IRenderTypeBuffer)irendertypebuffer$impl, 0xF000F0, OverlayTexture.field_229196_a_, itemRenderer.func_184393_a(stack, null, null));
        irendertypebuffer$impl.func_228461_a_();
        RenderSystem.enableDepthTest();
        if (flag) {
            RenderHelper.func_227784_d_();
        }
        RenderSystem.disableAlphaTest();
        RenderSystem.disableRescaleNormal();
        RenderSystem.popMatrix();
    }

    public static void renderEntityOnScreen(MatrixStack matrixStack, int posX, int posY, int scale, float mouseX, float mouseY, LivingEntity entity) {
        String name = entity.func_200201_e() != null ? entity.func_200201_e().getString() : null;
        entity.func_200203_b(null);
        float f = (float)Math.atan(mouseX / 40.0f);
        float f1 = (float)Math.atan(mouseY / 40.0f);
        RenderSystem.pushMatrix();
        RenderSystem.translatef((float)posX, (float)posY, (float)1050.0f);
        RenderSystem.scalef((float)1.0f, (float)1.0f, (float)-1.0f);
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_(0.0, 0.0, 1000.0);
        float scale2 = 1.0f / Math.max(entity.func_213311_cf(), entity.func_213302_cg());
        matrixStack.func_227862_a_((float)scale * scale2, (float)scale * scale2, (float)scale * scale2);
        Quaternion quaternion = Vector3f.field_229183_f_.func_229187_a_(180.0f);
        Quaternion quaternion1 = Vector3f.field_229179_b_.func_229187_a_(f1 * 20.0f);
        quaternion.func_195890_a(quaternion1);
        matrixStack.func_227863_a_(quaternion);
        float f2 = entity.field_70761_aq;
        float f3 = entity.field_70177_z;
        float f4 = entity.field_70125_A;
        float f5 = entity.field_70758_at;
        float f6 = entity.field_70759_as;
        entity.field_70761_aq = 180.0f + f * 20.0f;
        entity.field_70177_z = 180.0f + f * 40.0f;
        entity.field_70125_A = -f1 * 20.0f;
        entity.field_70759_as = entity.field_70177_z;
        entity.field_70758_at = entity.field_70177_z;
        EntityRendererManager entityrenderermanager = Minecraft.func_71410_x().func_175598_ae();
        quaternion1.func_195892_e();
        entityrenderermanager.func_229089_a_(quaternion1);
        entityrenderermanager.func_178633_a(false);
        IRenderTypeBuffer.Impl irendertypebuffer$impl = Minecraft.func_71410_x().func_228019_au_().func_228487_b_();
        RenderSystem.runAsFancy(() -> entityrenderermanager.func_229084_a_((Entity)entity, 0.0, 0.0, 0.0, 0.0f, 1.0f, matrixStack, (IRenderTypeBuffer)irendertypebuffer$impl, 0xF000F0));
        irendertypebuffer$impl.func_228461_a_();
        entityrenderermanager.func_178633_a(true);
        entity.field_70761_aq = f2;
        entity.field_70177_z = f3;
        entity.field_70125_A = f4;
        entity.field_70758_at = f5;
        entity.field_70759_as = f6;
        RenderSystem.popMatrix();
        matrixStack.func_227865_b_();
        entity.func_200203_b((ITextComponent)new StringTextComponent(name));
    }

    public static void enableScissor() {
        GL11.glEnable((int)3089);
    }

    public static void disableScissor() {
        GL11.glDisable((int)3089);
    }

    public static void setScissorBounds(int minX, int minY, int maxX, int maxY) {
        MainWindow window = Minecraft.func_71410_x().func_228018_at_();
        int scale = (int)window.func_198100_s();
        minScissorX = minX * scale;
        minScissorY = window.func_198091_l() - maxY * scale;
        maxScissorX = maxX * scale;
        maxScissorY = window.func_198091_l() - minY * scale;
    }

    public static void clearScissorBounds() {
        stackedScissors.clear();
        GuiUtil.disableScissor();
    }

    public static void addScissorBounds(int x, int y, int width, int height) {
        stackedScissors.add(new ScissorBounds(x, y, width, height));
    }

    public static void removeScissorBounds(int x, int y, int width, int height) {
        ScissorBounds scissorBounds1 = stackedScissors.stream().filter(scissorBounds -> scissorBounds.equals(new ScissorBounds(x, y, width, height))).findFirst().orElse(null);
        stackedScissors.remove(scissorBounds1);
    }

    public static void enableStackedScissor() {
        int minX = 0;
        int minY = 0;
        int maxX = 10000;
        int maxY = 10000;
        for (ScissorBounds bounds : stackedScissors) {
            minX = Math.max(minX, bounds.x);
            minY = Math.max(minY, bounds.y);
            maxX = Math.min(maxX, bounds.x + bounds.width);
            maxY = Math.min(maxY, bounds.y + bounds.height);
        }
        if (minX < maxX && minY < maxY) {
            GuiUtil.scissor(minX, minY, maxX - minX, maxY - minY);
        } else {
            GuiUtil.scissor(0, 0, 0, 0);
        }
    }

    public static void scissor(int x, int y, int width, int height) {
        GuiUtil.scissor(x, y, width, height, false);
    }

    public static void scissor(int x, int y, int width, int height, boolean useMaxBounds) {
        MainWindow window = Minecraft.func_71410_x().func_228018_at_();
        float scale = useGuiScaleForScissor ? (float)((int)window.func_198100_s()) : 1.0f;
        int scissorX = (int)((float)x * scale);
        int scissorY = (int)((float)window.func_198091_l() - (float)(y + height) * scale);
        int scissorWidth = (int)((float)width * scale);
        int scissorHeight = (int)((float)height * scale);
        if (useMaxBounds) {
            scissorX = Math.max(scissorX, minScissorX);
            scissorY = Math.max(scissorY, minScissorY);
            scissorWidth = scissorX > maxScissorX ? 0 : Math.min(scissorWidth, maxScissorX - scissorX);
            scissorHeight = scissorY > maxScissorY ? 0 : Math.min(scissorHeight, maxScissorY - scissorY);
        }
        GuiUtil.enableScissor();
        GL11.glScissor((int)scissorX, (int)scissorY, (int)scissorWidth, (int)scissorHeight);
    }

    static {
        stackedScissors = new ArrayList<ScissorBounds>();
        useGuiScaleForScissor = true;
    }

    private static class ScissorBounds {
        public int x;
        public int y;
        public int width;
        public int height;

        public ScissorBounds(int x, int y, int width, int height) {
            this.x = x;
            this.y = y;
            this.width = width;
            this.height = height;
        }

        public boolean equals(Object obj) {
            if (obj instanceof ScissorBounds) {
                ScissorBounds scissorBounds = (ScissorBounds)obj;
                return this.x == scissorBounds.x && this.y == scissorBounds.y && this.width == scissorBounds.width && this.height == scissorBounds.height;
            }
            return super.equals(obj);
        }
    }
}

