/*
 * Decompiled with CFR 0.152.
 */
package com.willr27.blocklings.client.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.willr27.blocklings.client.gui.Control;
import com.willr27.blocklings.client.gui.GuiUtil;
import com.willr27.blocklings.client.gui.IScreen;
import com.willr27.blocklings.client.gui.controls.common.ScrollbarControl;
import com.willr27.blocklings.util.event.Event;
import com.willr27.blocklings.util.event.EventHandler;
import java.util.ArrayList;
import java.util.Collections;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public interface IControl {
    default public void setupEventHandlers() {
        this.getOnControlHover().subscribe(this::controlHover);
        this.getOnControlHoverStart().subscribe(this::controlHoverStart);
        this.getOnControlHoverStop().subscribe(this::controlHoverStop);
        this.getOnControlMouseClicked().subscribe(this::controlMouseClicked);
        this.getOnControlMouseReleased().subscribe(this::controlMouseReleased);
        this.getOnControlMouseScrolled().subscribe(this::controlMouseScrolled);
        this.getOnControlKeyPressed().subscribe(this::controlKeyPressed);
        this.getOnControlKeyReleased().subscribe(this::controlKeyReleased);
        this.getOnControlKeyHeld().subscribe(this::controlKeyHeld);
        this.getOnControlCharTyped().subscribe(this::controlCharTyped);
    }

    default public void forwardControlHover(@Nonnull MouseEvent e) {
        if (!this.isVisible()) {
            return;
        }
        if (!this.isMouseOver(e.mouseX, e.mouseY)) {
            return;
        }
        if (this.getReverseChildrenCopy().stream().anyMatch(control -> {
            control.forwardControlHover(e);
            return e.isHandled();
        })) {
            return;
        }
        if (!this.isInteractive()) {
            return;
        }
        this.setIsHovered(true, e.mouseX, e.mouseY);
        this.getOnControlHover().handle(e);
    }

    default public void controlHover(@Nonnull MouseEvent e) {
        e.setIsHandled(true);
    }

    default public void controlHoverStart(@Nonnull MouseEvent e) {
        e.setIsHandled(true);
    }

    default public void controlHoverStop(@Nonnull MouseEvent e) {
        e.setIsHandled(true);
    }

    default public void tickAll() {
        if (!this.isVisible()) {
            return;
        }
        if (this.getParent() != null) {
            this.tick();
        }
        this.getChildrenCopy().forEach(IControl::tickAll);
    }

    default public void tick() {
    }

    default public void preRenderAll(int mouseX, int mouseY, float partialTicks) {
        if (this.isVisible()) {
            this.preRender(mouseX, mouseY, partialTicks);
            this.getChildrenCopy().forEach(control -> control.preRenderAll(mouseX, mouseY, partialTicks));
        }
    }

    default public void preRender(int mouseX, int mouseY, float partialTicks) {
    }

    default public void renderAll(@Nonnull MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        matrixStack.func_227860_a_();
        if (this.getParent() == null) {
            GuiUtil.clearScissorBounds();
        } else {
            this.getParent().enableScissor();
            RenderSystem.enableDepthTest();
            if (this.isVisible()) {
                matrixStack.func_227862_a_(this.getEffectiveScale(), this.getEffectiveScale(), 1.0f);
                matrixStack.func_227861_a_((double)((float)this.getScreenX() / this.getEffectiveScale() - (float)this.getScreenX()), (double)((float)this.getScreenY() / this.getEffectiveScale() - (float)this.getScreenY()), 0.0);
                this.render(matrixStack, mouseX, mouseY, partialTicks);
                matrixStack.func_227861_a_((double)((float)this.getScreenX() - (float)this.getScreenX() / this.getEffectiveScale()), (double)((float)this.getScreenY() - (float)this.getScreenY() / this.getEffectiveScale()), 0.0);
                matrixStack.func_227862_a_(1.0f / this.getEffectiveScale(), 1.0f / this.getEffectiveScale(), 1.0f);
            }
        }
        if (this.isVisible()) {
            this.getChildrenCopy().forEach(control -> control.renderAll(matrixStack, mouseX, mouseY, partialTicks));
        }
        matrixStack.func_227865_b_();
        if (this.getParent() != null) {
            this.getParent().disableScissor();
        }
    }

    default public void render(@Nonnull MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
    }

    default public void renderTooltip(@Nonnull MatrixStack matrixStack, int mouseX, int mouseY) {
    }

    default public void forwardGlobalMouseClicked(@Nonnull MouseButtonEvent e) {
        this.getReverseChildrenCopy().forEach(control -> control.forwardGlobalMouseClicked(e));
        this.globalMouseClicked(e);
    }

    default public void globalMouseClicked(@Nonnull MouseButtonEvent e) {
    }

    default public void forwardControlMouseClicked(@Nonnull MouseButtonEvent e) {
        if (!this.isVisible()) {
            return;
        }
        if (!this.isMouseOver(e.mouseX, e.mouseY)) {
            return;
        }
        if (this.getReverseChildrenCopy().stream().anyMatch(control -> {
            control.forwardControlMouseClicked(e);
            return e.isHandled();
        })) {
            return;
        }
        if (!this.isInteractive()) {
            return;
        }
        this.getScreen().setRecentlyClickedControl(this);
        this.setIsFocused(true);
        this.setIsPressed(true, e.mouseX, e.mouseY);
        this.getOnControlMouseClicked().handle(e);
    }

    default public void controlMouseClicked(@Nonnull MouseButtonEvent e) {
        e.setIsHandled(true);
    }

    default public void forwardGlobalMouseReleased(@Nonnull MouseButtonEvent e) {
        this.getReverseChildrenCopy().forEach(control -> control.forwardGlobalMouseReleased(e));
        this.globalMouseReleased(e);
    }

    default public void globalMouseReleased(@Nonnull MouseButtonEvent e) {
    }

    default public void forwardControlMouseReleased(@Nonnull MouseButtonEvent e) {
        if (!this.isVisible()) {
            return;
        }
        if (!this.isMouseOver(e.mouseX, e.mouseY)) {
            return;
        }
        if (this.getReverseChildrenCopy().stream().anyMatch(control -> {
            control.forwardControlMouseReleased(e);
            return e.isHandled();
        })) {
            return;
        }
        if (!this.isInteractive()) {
            return;
        }
        if (this.getScreen().getRecentlyPressedControl() != this) {
            return;
        }
        this.setIsFocused(true);
        this.getOnControlMouseReleased().handle(e);
    }

    default public void controlMouseReleased(@Nonnull MouseButtonEvent e) {
        e.setIsHandled(true);
    }

    default public void forwardControlMouseScrolled(@Nonnull MouseScrollEvent e) {
        if (!this.isVisible()) {
            return;
        }
        if (!this.isMouseOver(e.mouseX, e.mouseY)) {
            return;
        }
        if (this.getReverseChildrenCopy().stream().anyMatch(control -> {
            control.forwardControlMouseScrolled(e);
            return e.isHandled();
        })) {
            return;
        }
        if (!this.isInteractive()) {
            return;
        }
        this.getOnControlMouseScrolled().handle(e);
    }

    default public void controlMouseScrolled(@Nonnull MouseScrollEvent e) {
        e.setIsHandled(false);
    }

    default public void forwardGlobalMouseScrolled(@Nonnull MouseScrollEvent e) {
        this.getReverseChildrenCopy().forEach(control -> control.forwardGlobalMouseScrolled(e));
        this.globalMouseScrolled(e);
    }

    default public void globalMouseScrolled(@Nonnull MouseScrollEvent e) {
    }

    default public void forwardControlKeyPressed(@Nonnull KeyEvent e) {
        if (this.isVisible() && this.isInteractive()) {
            this.controlKeyPressed(e);
        }
        if (e.isHandled()) {
            return;
        }
        if (this.hasParent()) {
            this.getParent().forwardControlKeyPressed(e);
        }
    }

    default public void controlKeyPressed(@Nonnull KeyEvent e) {
    }

    default public void forwardGlobalKeyPressed(@Nonnull KeyEvent e) {
        this.getReverseChildrenCopy().forEach(control -> control.forwardGlobalKeyPressed(e));
        this.globalKeyPressed(e);
    }

    default public void globalKeyPressed(@Nonnull KeyEvent e) {
    }

    default public void forwardControlKeyReleased(@Nonnull KeyEvent e) {
        if (this.isVisible() && this.isInteractive()) {
            this.controlKeyReleased(e);
        }
        if (e.isHandled()) {
            return;
        }
        if (this.hasParent()) {
            this.getParent().forwardControlKeyReleased(e);
        }
    }

    default public void controlKeyReleased(@Nonnull KeyEvent e) {
    }

    default public void forwardGlobalKeyReleased(@Nonnull KeyEvent e) {
        this.getReverseChildrenCopy().forEach(control -> control.forwardGlobalKeyReleased(e));
        this.globalKeyReleased(e);
    }

    default public void globalKeyReleased(@Nonnull KeyEvent e) {
    }

    default public void forwardControlKeyHeld(@Nonnull KeyEvent e) {
        if (this.isVisible() && this.isInteractive()) {
            this.controlKeyHeld(e);
        }
        if (e.isHandled()) {
            return;
        }
        if (this.hasParent()) {
            this.getParent().forwardControlKeyHeld(e);
        }
    }

    default public void controlKeyHeld(@Nonnull KeyEvent e) {
    }

    default public void forwardGlobalKeyHeld(@Nonnull KeyEvent e) {
        this.getReverseChildrenCopy().forEach(control -> control.forwardGlobalKeyHeld(e));
        this.globalKeyHeld(e);
    }

    default public void globalKeyHeld(@Nonnull KeyEvent e) {
    }

    default public void forwardControlCharTyped(@Nonnull CharEvent e) {
        if (this.isVisible() && this.isInteractive()) {
            this.controlCharTyped(e);
        }
        if (e.isHandled()) {
            return;
        }
        if (this.hasParent()) {
            this.getParent().forwardControlCharTyped(e);
        }
    }

    default public void controlCharTyped(@Nonnull CharEvent e) {
    }

    default public void forwardGlobalCharTyped(@Nonnull CharEvent e) {
        this.getReverseChildrenCopy().forEach(control -> control.forwardGlobalCharTyped(e));
        this.globalCharTyped(e);
    }

    default public void globalCharTyped(@Nonnull CharEvent e) {
    }

    default public void enableScissor() {
        GuiUtil.addScissorBounds(this.getScreenX(), this.getScreenY(), this.getScreenWidth(), this.getScreenHeight());
        GuiUtil.enableStackedScissor();
    }

    default public void disableScissor() {
        GuiUtil.removeScissorBounds(this.getScreenX(), this.getScreenY(), this.getScreenWidth(), this.getScreenHeight());
        GuiUtil.disableScissor();
    }

    default public boolean isMouseOver(int mouseX, int mouseY) {
        return GuiUtil.isMouseOver(mouseX, mouseY, this.getScreenX(), this.getScreenY(), this.getScreenWidth(), this.getScreenHeight());
    }

    @Nonnull
    public IScreen getScreen();

    default public boolean hasParent() {
        return this.getParent() != null;
    }

    @Nullable
    default public IControl getParent() {
        return null;
    }

    default public void setParent(@Nullable IControl parent) {
    }

    @Nonnull
    public ArrayList<Control> getChildren();

    @Nonnull
    default public ArrayList<Control> getReverseChildren() {
        ArrayList<Control> reverseChildren = new ArrayList<Control>(this.getChildren());
        Collections.reverse(reverseChildren);
        return reverseChildren;
    }

    @Nonnull
    default public ArrayList<Control> getChildrenCopy() {
        return new ArrayList<Control>(this.getChildren());
    }

    @Nonnull
    default public ArrayList<Control> getReverseChildrenCopy() {
        return new ArrayList<Control>(this.getReverseChildren());
    }

    public void addChild(@Nonnull Control var1);

    public void removeChild(@Nullable Control var1);

    default public void removeChildren() {
        for (Control control : this.getChildrenCopy()) {
            this.removeChild(control);
        }
    }

    @Nullable
    default public ScrollbarControl getScrollbarY() {
        return this.getParent() != null ? this.getParent().getScrollbarY() : null;
    }

    default public void setScrollbarY(@Nullable ScrollbarControl scrollbarControlY) {
    }

    default public int getScrollX() {
        return 0;
    }

    default public void setScrollX(int scroll) {
    }

    default public int getScrollY() {
        return 0;
    }

    default public void setScrollY(int scroll) {
    }

    default public int getMaxScrollX() {
        return 0;
    }

    default public void setMaxScrollX(int maxScroll) {
    }

    default public int getMaxScrollY() {
        return 0;
    }

    default public void setMaxScrollY(int maxScroll) {
    }

    public int getScreenX();

    public int getScreenY();

    public int getWidth();

    default public int getScreenWidth() {
        return (int)(this.getEffectiveScale() * (float)this.getWidth());
    }

    public int getHeight();

    default public int getScreenHeight() {
        return (int)(this.getEffectiveScale() * (float)this.getHeight());
    }

    default public float getEffectiveScale() {
        return this.getScale() * (this.getParent() != null ? this.getParent().getEffectiveScale() : 1.0f);
    }

    default public float getScale() {
        return 1.0f;
    }

    default public void setScale(float scale) {
    }

    default public int getPadding(@Nonnull Side side) {
        return 0;
    }

    default public void setPadding(@Nonnull Side side, int padding) {
    }

    default public int getMargin(@Nonnull Side side) {
        return 0;
    }

    default public void setMargin(@Nonnull Side side, int margin) {
    }

    default public void setMargins(int left, int top, int right, int bottom) {
    }

    default public boolean isVisible() {
        return true;
    }

    default public void setIsVisible(boolean isVisible) {
    }

    default public boolean isFocused() {
        return this.getScreen().getFocusedControl() == this;
    }

    default public void setIsFocused(boolean isFocused) {
        this.getScreen().setFocusedControl(isFocused ? this : null);
    }

    default public boolean isHovered() {
        return this.getScreen().getHoveredControl() == this;
    }

    default public void setIsHovered(boolean isHovered, int mouseX, int mouseY) {
        this.getScreen().setHoveredControl(isHovered ? this : null, mouseX, mouseY);
    }

    default public boolean isPressed() {
        return this.getScreen().getPressedControl() == this;
    }

    default public int getPressedMouseX() {
        return this.getScreen().getPressedMouseX();
    }

    default public int getPressedMouseY() {
        return this.getScreen().getPressedMouseY();
    }

    default public boolean isDragging() {
        return this.getScreen().getDraggedControl() == this;
    }

    default public void setIsDragging(boolean isDragging) {
        this.getScreen().setDraggedControl(isDragging ? this : null);
    }

    default public void setIsPressed(boolean isClicked, int mouseX, int mouseY) {
        this.getScreen().setPressedControl(isClicked ? this : null, mouseX, mouseY);
    }

    default public boolean isInteractive() {
        return true;
    }

    default public void setIsInteractive(boolean isInteractive) {
    }

    default public boolean isScrollableX() {
        return false;
    }

    default public void setIsScrollableX(boolean isScrollable) {
    }

    default public boolean isScrollableY() {
        return false;
    }

    default public void setIsScrollableY(boolean isScrollable) {
    }

    @Nonnull
    public EventHandler<MouseEvent> getOnControlHover();

    @Nonnull
    public EventHandler<MouseEvent> getOnControlHoverStart();

    @Nonnull
    public EventHandler<MouseEvent> getOnControlHoverStop();

    @Nonnull
    public EventHandler<MouseButtonEvent> getOnControlMouseClicked();

    @Nonnull
    public EventHandler<MouseButtonEvent> getOnControlMouseReleased();

    @Nonnull
    public EventHandler<MouseScrollEvent> getOnControlMouseScrolled();

    @Nonnull
    public EventHandler<KeyEvent> getOnControlKeyPressed();

    @Nonnull
    public EventHandler<KeyEvent> getOnControlKeyReleased();

    @Nonnull
    public EventHandler<KeyEvent> getOnControlKeyHeld();

    @Nonnull
    public EventHandler<CharEvent> getOnControlCharTyped();

    public static enum Side {
        LEFT,
        TOP,
        RIGHT,
        BOTTOM;

    }

    public static class CharEvent
    extends Event {
        public final char character;
        public final int keyCode;

        public CharEvent(char character, int keyCode) {
            this.character = character;
            this.keyCode = keyCode;
        }
    }

    public static class KeyEvent
    extends Event {
        public final int keyCode;
        public final int scanCode;
        public final int modifiers;

        public KeyEvent(int keyCode, int scanCode, int modifiers) {
            this.keyCode = keyCode;
            this.scanCode = scanCode;
            this.modifiers = modifiers;
        }
    }

    public static class MouseScrollEvent
    extends MouseEvent {
        public final double scroll;

        public MouseScrollEvent(int mouseX, int mouseY, double scroll) {
            super(mouseX, mouseY);
            this.scroll = scroll;
        }
    }

    public static class MouseButtonEvent
    extends MouseEvent {
        public final int button;

        public MouseButtonEvent(int mouseX, int mouseY, int button) {
            super(mouseX, mouseY);
            this.button = button;
        }
    }

    public static class MouseEvent
    extends Event {
        public final int mouseX;
        public final int mouseY;

        public MouseEvent(int mouseX, int mouseY) {
            this.mouseX = mouseX;
            this.mouseY = mouseY;
        }
    }
}

