/*
 * Decompiled with CFR 0.152.
 */
package com.willr27.blocklings.client.gui;

import com.willr27.blocklings.entity.blockling.skill.BlocklingSkills;
import com.willr27.blocklings.entity.blockling.skill.info.SkillGroupInfo;
import com.willr27.blocklings.util.BlocklingsTranslationTextComponent;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.text.TranslationTextComponent;

public enum Tab {
    STATS("stats", 0, null, 0, 0, true),
    TASKS("tasks", 1, null, 1, 0, true),
    EQUIPMENT("equipment", 2, null, 2, 0, true),
    GENERAL("general", 4, BlocklingSkills.Groups.GENERAL, 0, 1, false),
    COMBAT("combat", 5, BlocklingSkills.Groups.COMBAT, 1, 1, false),
    MINING("mining", 6, BlocklingSkills.Groups.MINING, 2, 1, false),
    WOODCUTTING("woodcutting", 7, BlocklingSkills.Groups.WOODCUTTING, 3, 1, false),
    FARMING("farming", 8, BlocklingSkills.Groups.FARMING, 4, 1, false);

    public final TranslationTextComponent name;
    public final int guiId;
    public final SkillGroupInfo skillGroup;
    public final int textureX;
    public final int textureY;
    public final boolean left;
    public static List<Tab> leftTabs;
    public static List<Tab> rightTabs;

    private Tab(String key, int guiId, SkillGroupInfo skillGroup, int textureX, int textureY, boolean left) {
        this.name = new TabTranslationTextComponent(key);
        this.guiId = guiId;
        this.skillGroup = skillGroup;
        this.textureX = textureX;
        this.textureY = textureY;
        this.left = left;
    }

    public int getIndex() {
        return this.left ? leftTabs.indexOf((Object)this) : rightTabs.indexOf((Object)this);
    }

    public static boolean hasTab(int guiId) {
        return Tab.getTab(guiId) != null;
    }

    public static Tab getTab(int guiId) {
        for (Tab tab : Tab.values()) {
            if (tab.guiId != guiId) continue;
            return tab;
        }
        return null;
    }

    static {
        leftTabs = new ArrayList<Tab>();
        rightTabs = new ArrayList<Tab>();
        for (Tab tab : Tab.values()) {
            if (tab.left) {
                leftTabs.add(tab);
                continue;
            }
            rightTabs.add(tab);
        }
    }

    public class TabTranslationTextComponent
    extends BlocklingsTranslationTextComponent {
        public TabTranslationTextComponent(String key) {
            super("tab." + key);
        }
    }
}

