/*
 * Decompiled with CFR 0.152.
 */
package com.willr27.blocklings.client.gui.controls;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.willr27.blocklings.client.gui.Control;
import com.willr27.blocklings.client.gui.GuiTexture;
import com.willr27.blocklings.client.gui.GuiTextures;
import com.willr27.blocklings.client.gui.IControl;
import com.willr27.blocklings.client.gui.Tab;
import com.willr27.blocklings.entity.blockling.BlocklingEntity;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class TabbedControl
extends Control {
    public static final int OFFSET_Y = -5;
    public static final int GUI_WIDTH = 234;
    public static final int GUI_HEIGHT = 166;
    public static final int CONTENT_WIDTH = 176;
    public static final int CONTENT_HEIGHT = 166;

    public TabbedControl(@Nonnull IControl parent, @Nonnull BlocklingEntity blockling, int x, int y) {
        super(parent, x, y, 234, 166);
        for (Tab tab : Tab.values()) {
            new TabControl(this, tab, blockling, 0, 0, this.width);
        }
    }

    @Override
    public void controlMouseReleased(@Nonnull IControl.MouseButtonEvent e) {
    }

    public static class TabControl
    extends Control {
        private static final int ICON_SIZE = 22;
        @Nonnull
        private static final GuiTexture SELECTED_BACKGROUND_TEXTURE_LEFT = new GuiTexture(GuiTextures.TABS, 52, 0, 32, 28);
        @Nonnull
        private static final GuiTexture SELECTED_BACKGROUND_TEXTURE_RIGHT = new GuiTexture(GuiTextures.TABS, 85, 0, 32, 28);
        @Nonnull
        private static final GuiTexture UNSELECTED_BACKGROUND_TEXTURE_LEFT = new GuiTexture(GuiTextures.TABS, 0, 0, 25, 28);
        @Nonnull
        private static final GuiTexture UNSELECTED_BACKGROUND_TEXTURE_RIGHT = new GuiTexture(GuiTextures.TABS, 26, 0, 25, 28);
        @Nonnull
        public final Tab tab;
        @Nonnull
        private final BlocklingEntity blockling;
        @Nonnull
        private final GuiTexture selectedBackgroundTexture;
        @Nonnull
        private final GuiTexture unselectedBackgroundTexture;
        @Nonnull
        private final GuiTexture iconTexture;

        public TabControl(@Nonnull IControl parent, @Nonnull Tab tab, @Nonnull BlocklingEntity blockling, int left, int top, int right) {
            super(parent, tab.left ? left : right - TabControl.SELECTED_BACKGROUND_TEXTURE_LEFT.width, top + tab.getIndex() * (TabControl.SELECTED_BACKGROUND_TEXTURE_LEFT.height + 4) + 5, TabControl.SELECTED_BACKGROUND_TEXTURE_LEFT.width, TabControl.SELECTED_BACKGROUND_TEXTURE_LEFT.height);
            this.tab = tab;
            this.blockling = blockling;
            this.selectedBackgroundTexture = tab.left ? SELECTED_BACKGROUND_TEXTURE_LEFT : SELECTED_BACKGROUND_TEXTURE_RIGHT;
            this.unselectedBackgroundTexture = tab.left ? UNSELECTED_BACKGROUND_TEXTURE_LEFT : UNSELECTED_BACKGROUND_TEXTURE_RIGHT;
            this.iconTexture = new GuiTexture(GuiTextures.TABS, tab.getIndex() * 22, tab.left ? 28 : 50, 22, 22);
        }

        @Override
        public void render(@Nonnull MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
            RenderSystem.enableDepthTest();
            if (this.isSelected()) {
                matrixStack.func_227861_a_(0.0, 0.0, 5.0);
                this.renderTexture(matrixStack, this.selectedBackgroundTexture);
                this.renderTexture(matrixStack, this.tab.left ? 6 : 4, 3, this.iconTexture);
            } else {
                this.renderTexture(matrixStack, this.tab.left ? 4 : 3, 0, this.unselectedBackgroundTexture);
                this.renderTexture(matrixStack, this.tab.left ? 7 : 3, 3, this.iconTexture);
            }
        }

        @Override
        public void renderTooltip(@Nonnull MatrixStack matrixStack, int mouseX, int mouseY) {
            this.screen.func_238652_a_(matrixStack, (ITextComponent)this.tab.name, mouseX, mouseY);
        }

        @Override
        public void controlMouseClicked(@Nonnull IControl.MouseButtonEvent e) {
            this.blockling.guiHandler.openGui(this.tab.guiId, (PlayerEntity)this.screen.getMinecraft().field_71439_g);
            e.setIsHandled(true);
        }

        public boolean isSelected() {
            return this.tab.guiId == this.blockling.guiHandler.getRecentGuiId();
        }
    }
}

