/*
 * Decompiled with CFR 0.152.
 */
package com.willr27.blocklings.client.gui.controls.common;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.willr27.blocklings.client.gui.Control;
import com.willr27.blocklings.client.gui.GuiTexture;
import com.willr27.blocklings.client.gui.GuiTextures;
import com.willr27.blocklings.client.gui.GuiUtil;
import com.willr27.blocklings.client.gui.IControl;
import com.willr27.blocklings.util.event.Event;
import com.willr27.blocklings.util.event.EventHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.util.IReorderingProcessor;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class DropdownControl
extends Control {
    private boolean isOpen = false;
    @Nonnull
    public final EventHandler<DropDownSelectionChangedEvent> onDropDownSelectionChanged = new EventHandler();
    @Nonnull
    private final SelectedItemControl selectedItemControl;
    @Nonnull
    private final List<ItemControl> itemControls = new ArrayList<ItemControl>();

    public DropdownControl(@Nonnull IControl parent, int x, int y, int width) {
        super(parent, x, y, width, GuiTextures.RAISED_BAR.height);
        this.selectedItemControl = new SelectedItemControl(this, width);
    }

    @Override
    public void preRender(int mouseX, int mouseY, float partialTicks) {
        this.height = this.selectedItemControl.height;
        if (this.isOpen) {
            for (ItemControl item : this.itemControls) {
                this.height += item.height;
            }
        }
        for (int i = 0; i < this.itemControls.size(); ++i) {
            ItemControl itemControl = this.itemControls.get(i);
            itemControl.setY(this.selectedItemControl.height + i * itemControl.height);
        }
    }

    @Override
    public void globalMouseClicked(@Nonnull IControl.MouseButtonEvent e) {
        if (!(this.isMouseOver(e.mouseX, e.mouseY) || this.getScrollbarY() != null && this.getScrollbarY().isMouseOver(e.mouseX, e.mouseY) || !this.isOpen)) {
            this.close();
        }
    }

    private void open() {
        this.isOpen = true;
    }

    private void close() {
        this.isOpen = false;
    }

    public void addItems(@Nonnull List<Item> items) {
        for (Item item : items) {
            this.addItem(item);
        }
    }

    public void addItem(@Nonnull Item item) {
        if (this.itemControls.stream().anyMatch(dropdownItemControl -> ((ItemControl)dropdownItemControl).item.equals(item))) {
            return;
        }
        this.itemControls.add(new ItemControl(this, this.width, item));
    }

    public void removeItem(@Nonnull Object item) {
        List<ItemControl> itemsToRemove = this.itemControls.stream().filter(dropdownItemControl -> ((ItemControl)dropdownItemControl).item.equals(item)).collect(Collectors.toList());
        if (this.selectedItemControl.item != null && this.selectedItemControl.item.equals(item)) {
            this.selectedItemControl.item = null;
            this.onDropDownSelectionChanged.handle(new DropDownSelectionChangedEvent(this.selectedItemControl.item, null));
        }
        itemsToRemove.forEach(this::removeChild);
        itemsToRemove.forEach(this.itemControls::remove);
    }

    public void setSelectedItem(@Nullable Item item) {
        if (item != null && this.itemControls.stream().noneMatch(dropdownItemControl -> ((ItemControl)dropdownItemControl).item.equals(item))) {
            this.addItem(item);
        }
        if (!Objects.equals(this.selectedItemControl.item, item)) {
            this.selectedItemControl.item = item;
            this.onDropDownSelectionChanged.handle(new DropDownSelectionChangedEvent(this.selectedItemControl.item, this.selectedItemControl.item));
        }
    }

    public static class DropDownSelectionChangedEvent
    extends Event {
        @Nullable
        public final Item previousSelection;
        @Nullable
        public final Item newSelection;

        public DropDownSelectionChangedEvent(@Nullable Item previousSelection, @Nullable Item newSelection) {
            this.previousSelection = previousSelection;
            this.newSelection = newSelection;
        }
    }

    public static class Item {
        @Nonnull
        public Object item;
        @Nullable
        public GuiTexture iconTexture;
        @Nullable
        public List<IReorderingProcessor> tooltip;

        public Item(@Nonnull Object item, @Nullable GuiTexture iconTexture, @Nullable List<IReorderingProcessor> tooltip) {
            this.item = item;
            this.iconTexture = iconTexture;
            this.tooltip = tooltip;
        }

        public boolean equals(Object obj) {
            if (obj instanceof Item) {
                return this.item.equals(((Item)obj).item);
            }
            return super.equals(obj);
        }

        public String toString() {
            return this.item.toString();
        }
    }

    public static class ItemControl
    extends Control {
        @Nonnull
        private final DropdownControl dropdownControl;
        @Nonnull
        private final GuiTexture itemStartTexture;
        @Nonnull
        private final GuiTexture itemEndTexture;
        @Nonnull
        private final Item item;

        public ItemControl(@Nonnull DropdownControl dropdownControl, int width, @Nonnull Item item) {
            super(dropdownControl, 0, 0, width, GuiTextures.FLAT_BAR.height - 1);
            this.dropdownControl = dropdownControl;
            this.itemStartTexture = GuiTextures.FLAT_BAR.width(width - GuiTextures.FLAT_BAR_END.width).shift(0, 1);
            this.itemEndTexture = GuiTextures.FLAT_BAR_END.shift(0, 1);
            this.item = item;
        }

        @Override
        public void controlHoverStart(@Nonnull IControl.MouseEvent e) {
            this.setBackgroundColour(0.85f, 0.85f, 0.85f);
            e.setIsHandled(true);
        }

        @Override
        public void controlHoverStop(@Nonnull IControl.MouseEvent e) {
            this.setBackgroundColour(1.0f, 1.0f, 1.0f);
            e.setIsHandled(true);
        }

        @Override
        public void render(@Nonnull MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
            this.getBackgroundColour().apply();
            this.renderTexture(matrixStack, this.itemStartTexture);
            this.renderTexture(matrixStack, this.itemStartTexture.width, 0, this.itemEndTexture);
            this.resetRenderColour();
            int textOffset = 0;
            if (this.item.iconTexture != null) {
                this.renderTexture(matrixStack, 0, -1, this.item.iconTexture);
                textOffset += this.item.iconTexture.width - 3;
            }
            this.renderShadowedText(matrixStack, GuiUtil.trimWithEllipses(this.font, this.item.toString(), this.width - 11 - textOffset), 5 + textOffset, 6, false, -1);
        }

        @Override
        public void renderTooltip(@Nonnull MatrixStack matrixStack, int mouseX, int mouseY) {
            if (this.item.tooltip != null) {
                this.screen.func_238654_b_(matrixStack, this.item.tooltip, mouseX, mouseY);
            } else {
                this.screen.func_238652_a_(matrixStack, (ITextComponent)new StringTextComponent(this.item.toString()), mouseX, mouseY);
            }
        }

        @Override
        public void controlMouseClicked(@Nonnull IControl.MouseButtonEvent e) {
            this.dropdownControl.setSelectedItem(this.item);
            this.dropdownControl.close();
            e.setIsHandled(true);
        }
    }

    public static class SelectedItemControl
    extends Control {
        @Nonnull
        private final DropdownControl dropdownControl;
        @Nonnull
        private final GuiTexture itemStartTexture;
        @Nonnull
        private final GuiTexture itemEndTexture;
        @Nullable
        public Item item;

        public SelectedItemControl(@Nonnull DropdownControl dropdownControl, int width) {
            super(dropdownControl, 0, 0, width, GuiTextures.RAISED_BAR.height);
            this.dropdownControl = dropdownControl;
            this.itemStartTexture = GuiTextures.RAISED_BAR.width(width - GuiTextures.RAISED_BAR_END.width);
            this.itemEndTexture = GuiTextures.RAISED_BAR_END;
        }

        @Override
        public void controlHoverStart(@Nonnull IControl.MouseEvent e) {
            this.setBackgroundColour(0.85f, 0.85f, 0.85f);
            e.setIsHandled(true);
        }

        @Override
        public void controlHoverStop(@Nonnull IControl.MouseEvent e) {
            this.setBackgroundColour(1.0f, 1.0f, 1.0f);
            e.setIsHandled(true);
        }

        @Override
        public void render(@Nonnull MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
            this.getBackgroundColour().apply();
            this.renderTexture(matrixStack, this.itemStartTexture);
            this.renderTexture(matrixStack, this.itemStartTexture.width, 0, this.itemEndTexture);
            this.resetRenderColour();
            if (this.dropdownControl.isOpen) {
                this.renderTexture(matrixStack, this.itemStartTexture.width - GuiTextures.DROPDOWN_UP_ARROW.width - this.itemEndTexture.width - 1, this.itemStartTexture.height / 2 - GuiTextures.DROPDOWN_UP_ARROW.height / 2 - 1, GuiTextures.DROPDOWN_UP_ARROW);
            } else {
                this.renderTexture(matrixStack, this.itemStartTexture.width - GuiTextures.DROPDOWN_DOWN_ARROW.width - this.itemEndTexture.width - 1, this.itemStartTexture.height / 2 - GuiTextures.DROPDOWN_DOWN_ARROW.height / 2, GuiTextures.DROPDOWN_DOWN_ARROW);
            }
            int textOffset = 0;
            if (this.item != null && this.item.iconTexture != null) {
                this.renderTexture(matrixStack, 0, 0, this.item.iconTexture);
                textOffset += this.item.iconTexture.width - 3;
            }
            if (this.item != null) {
                this.renderText(matrixStack, GuiUtil.trimWithEllipses(this.font, this.item.toString(), this.width - 23 - textOffset), 5 + textOffset, 6, false, -1);
            }
        }

        @Override
        public void renderTooltip(@Nonnull MatrixStack matrixStack, int mouseX, int mouseY) {
            if (this.item.tooltip != null) {
                this.screen.func_238654_b_(matrixStack, this.item.tooltip, mouseX, mouseY);
            } else {
                this.screen.func_238652_a_(matrixStack, (ITextComponent)new StringTextComponent(this.item.toString()), mouseX, mouseY);
            }
        }

        @Override
        public void controlMouseClicked(@Nonnull IControl.MouseButtonEvent e) {
            if (!this.dropdownControl.isOpen) {
                this.dropdownControl.open();
            } else {
                this.dropdownControl.close();
            }
            e.setIsHandled(true);
        }
    }
}

