/*
 * Decompiled with CFR 0.152.
 */
package com.willr27.blocklings.client.gui.controls.common;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.willr27.blocklings.client.gui.Control;
import com.willr27.blocklings.client.gui.GuiUtil;
import com.willr27.blocklings.client.gui.IControl;
import javax.annotation.Nonnull;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class LabelControl
extends Control {
    private static final int HEIGHT = 9;
    @Nonnull
    private String text;

    public LabelControl(@Nonnull IControl parent, int width, @Nonnull String text) {
        super(parent, 0, 0, width, 9);
        this.text = text;
    }

    @Override
    public void render(@Nonnull MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.renderText(matrixStack, this.getTrimmedText(), this.getPadding(IControl.Side.LEFT), this.getPadding(IControl.Side.TOP), false, -1);
    }

    @Override
    public void renderTooltip(@Nonnull MatrixStack matrixStack, int mouseX, int mouseY) {
        if (!this.getTrimmedText().equals(this.text)) {
            this.screen.func_238652_a_(matrixStack, (ITextComponent)new StringTextComponent(this.text), mouseX, mouseY);
        }
    }

    @Override
    public void setPadding(@Nonnull IControl.Side side, int padding) {
        super.setPadding(side, padding);
        this.recalcHeight();
    }

    @Override
    public void setPadding(int left, int top, int right, int bottom) {
        super.setPadding(left, top, right, bottom);
        this.recalcHeight();
    }

    private void recalcHeight() {
        this.height = 9 + this.getPadding(IControl.Side.TOP) + this.getPadding(IControl.Side.BOTTOM);
    }

    @Nonnull
    private String getTrimmedText() {
        return GuiUtil.trimWithEllipses(this.font, this.text, this.width - this.getPadding(IControl.Side.LEFT) - this.getPadding(IControl.Side.RIGHT));
    }

    @Nonnull
    public String getText() {
        return this.text;
    }

    public void setText(@Nonnull String text) {
        this.text = text;
    }
}

