/*
 * Decompiled with CFR 0.152.
 */
package com.willr27.blocklings.client.gui.controls.common;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.willr27.blocklings.client.gui.Control;
import com.willr27.blocklings.client.gui.GuiTextures;
import com.willr27.blocklings.client.gui.IControl;
import com.willr27.blocklings.client.gui.controls.common.TextFieldControl;
import javax.annotation.Nonnull;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class RangeControl
extends Control {
    public final int min;
    public final int max;
    private int value;
    private float percentage = 0.0f;
    private int sliderWidth = 0;
    private int textFieldWidth = 0;
    protected final GrabberControl grabberControl;
    protected final TextFieldControl valueTextFieldControl;

    public RangeControl(@Nonnull IControl parent, int min, int max, int startingValue, int textFieldWidth) {
        super(parent, 0, 0, parent.getWidth() - parent.getPadding(IControl.Side.LEFT) - parent.getPadding(IControl.Side.RIGHT), 20);
        this.min = min;
        this.max = max;
        this.textFieldWidth = textFieldWidth;
        this.sliderWidth = this.width - textFieldWidth - 4;
        this.grabberControl = new GrabberControl(this);
        IControl screen = (IControl)((Object)this.getScreen());
        float scale = screen.getScale();
        this.valueTextFieldControl = new TextFieldControl(this.font, (int)((float)this.getScreenX() / scale + (float)this.getWidth() - (float)textFieldWidth), (int)((float)this.getScreenY() / scale), textFieldWidth, 20, (ITextComponent)new StringTextComponent("")){

            @Override
            public void setFocus(boolean focus) {
                if (!focus) {
                    try {
                        RangeControl.this.setValue(Integer.parseInt(this.getValue()));
                    }
                    catch (NumberFormatException e) {
                        RangeControl.this.setValue(RangeControl.this.getValue());
                    }
                }
                super.setFocus(focus);
            }
        };
        this.valueTextFieldControl.setMaxLength(10);
        this.valueTextFieldControl.setVisible(true);
        this.valueTextFieldControl.setTextColor(0xFFFFFF);
        this.setValue(startingValue);
    }

    @Override
    public void tick() {
        this.valueTextFieldControl.tick();
    }

    @Override
    public void render(@Nonnull MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.renderTexture(matrixStack, 0, 8, GuiTextures.SLIDER_BAR.width(this.sliderWidth - GuiTextures.SLIDER_BAR_END.width));
        this.renderTexture(matrixStack, this.sliderWidth - GuiTextures.SLIDER_BAR_END.width, 8, GuiTextures.SLIDER_BAR_END);
        IControl screen = (IControl)((Object)this.getScreen());
        float scale = screen.getScale();
        this.valueTextFieldControl.field_230690_l_ = (int)((float)this.getScreenX() / scale + (float)this.getWidth() - (float)this.textFieldWidth);
        this.valueTextFieldControl.field_230691_m_ = (int)((float)this.getScreenY() / scale);
        this.valueTextFieldControl.func_230430_a_(new MatrixStack(), mouseX, mouseY, partialTicks);
    }

    @Override
    public void controlMouseClicked(@Nonnull IControl.MouseButtonEvent e) {
        this.valueTextFieldControl.func_231044_a_((float)e.mouseX / this.getEffectiveScale(), (float)e.mouseY / this.getEffectiveScale(), e.button);
        if (new Control(null, this.getScreenX(), (int)((float)this.getScreenY() + 4.0f * this.getEffectiveScale()), (int)((float)this.sliderWidth * this.getEffectiveScale()), (int)((float)GuiTextures.SLIDER_GRABBER_RAISED.height * this.getEffectiveScale())).isMouseOver(e.mouseX, e.mouseY)) {
            this.setPercentage(this.calcPercentageFromMouse(e.mouseX));
            this.grabberControl.setIsPressed(true, e.mouseX, e.mouseY);
            this.grabberControl.setIsDragging(true);
        }
        e.setIsHandled(true);
    }

    @Override
    public void controlMouseReleased(@Nonnull IControl.MouseButtonEvent e) {
        if (this.valueTextFieldControl.func_230999_j_()) {
            this.valueTextFieldControl.func_231048_c_((float)e.mouseX / this.getEffectiveScale(), (float)e.mouseY / this.getEffectiveScale(), e.button);
        }
        e.setIsHandled(true);
    }

    @Override
    public void globalMouseClicked(@Nonnull IControl.MouseButtonEvent e) {
        if (this.valueTextFieldControl.func_230999_j_() && !this.valueTextFieldControl.func_231047_b_((float)e.mouseX / this.getEffectiveScale(), (float)e.mouseY / this.getEffectiveScale())) {
            this.valueTextFieldControl.setFocus(false);
        }
    }

    @Override
    public void controlKeyPressed(@Nonnull IControl.KeyEvent e) {
        if (e.keyCode == 257 || e.keyCode == 256) {
            if (this.valueTextFieldControl.func_230999_j_()) {
                this.valueTextFieldControl.setFocus(false);
                e.setIsHandled(true);
            }
        } else {
            e.setIsHandled(this.valueTextFieldControl.func_231046_a_(e.keyCode, e.scanCode, e.modifiers));
        }
    }

    @Override
    public void controlCharTyped(@Nonnull IControl.CharEvent e) {
        e.setIsHandled(this.valueTextFieldControl.func_231042_a_(e.character, e.keyCode));
    }

    private void recalcGrabberPosition() {
        this.grabberControl.setX((int)(this.percentage * (float)(this.sliderWidth - this.grabberControl.getWidth())));
    }

    private float calcPercentageFromMouse(int mouseX) {
        int adjustedSliderWidth = this.sliderWidth - this.grabberControl.getWidth();
        int localMouseX = Math.max(this.grabberControl.getWidth() / 2, Math.min(adjustedSliderWidth + this.grabberControl.getWidth() / 2, (int)((float)this.toLocalX(mouseX) / this.getEffectiveScale())));
        return Math.max(0.0f, Math.min(1.0f, (float)(localMouseX - this.grabberControl.getWidth() / 2) / (float)adjustedSliderWidth));
    }

    private int calcValueFromPercentage(float percentage) {
        return Math.round(percentage * (float)(this.max - this.min) + (float)this.min);
    }

    public int getValue() {
        return this.value;
    }

    public void setValue(int value) {
        this.value = Math.max(this.min, Math.min(this.max, value));
        this.valueTextFieldControl.setValue(String.valueOf(this.value));
        this.percentage = (float)(this.value - this.min) / (float)(this.max - this.min);
        this.recalcGrabberPosition();
    }

    public float getPercentage() {
        return this.percentage;
    }

    public void setPercentage(float percentage) {
        this.setValue(this.calcValueFromPercentage(percentage));
    }

    protected static class GrabberControl
    extends Control {
        public final RangeControl rangeControl;

        public GrabberControl(@Nonnull RangeControl rangeControl) {
            super(rangeControl, 0, 4, GuiTextures.SLIDER_GRABBER_RAISED.width, GuiTextures.SLIDER_GRABBER_RAISED.height);
            this.rangeControl = rangeControl;
        }

        @Override
        public void preRender(int mouseX, int mouseY, float partialTicks) {
            int value;
            if (this.isDragging() && (value = this.rangeControl.calcValueFromPercentage(this.rangeControl.calcPercentageFromMouse(mouseX))) != this.rangeControl.value) {
                this.rangeControl.setValue(value);
            }
        }

        @Override
        public void render(@Nonnull MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
            if (this.isPressed()) {
                this.renderTexture(matrixStack, GuiTextures.SLIDER_GRABBER_PRESSED);
            } else {
                this.renderTexture(matrixStack, GuiTextures.SLIDER_GRABBER_RAISED);
            }
        }

        @Override
        public void renderTooltip(@Nonnull MatrixStack matrixStack, int mouseX, int mouseY) {
            this.parent.renderTooltip(matrixStack, mouseX, mouseY);
        }
    }
}

