/*
 * Decompiled with CFR 0.152.
 */
package com.willr27.blocklings.client.gui.controls.common;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.willr27.blocklings.client.gui.Control;
import com.willr27.blocklings.client.gui.GuiTexture;
import com.willr27.blocklings.client.gui.GuiTextures;
import com.willr27.blocklings.client.gui.GuiUtil;
import com.willr27.blocklings.client.gui.IControl;
import com.willr27.blocklings.util.event.Event;
import com.willr27.blocklings.util.event.EventHandler;
import javax.annotation.Nonnull;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ScrollbarControl
extends Control {
    @Nonnull
    private static final GuiTexture GRABBER_TEXTURE = new GuiTexture(GuiTextures.COMMON_WIDGETS, 0, 0, 12, 15);
    public final EventHandler<ScrollEvent> onScroll = new EventHandler();
    private boolean isDisabled = false;
    private int scrollOffset = 0;

    public boolean isDisabled() {
        return this.isDisabled;
    }

    public void setIsDisabled(boolean isDisabled) {
        this.isDisabled = isDisabled;
    }

    public ScrollbarControl(@Nonnull IControl parent, int x, int y, int width, int height) {
        super(parent, x, y, width, height);
    }

    @Override
    public void render(@Nonnull MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        RenderSystem.enableDepthTest();
        GuiUtil.bindTexture(ScrollbarControl.GRABBER_TEXTURE.texture);
        int textureOffset = 0;
        if (this.isDragging()) {
            textureOffset = ScrollbarControl.GRABBER_TEXTURE.width;
            this.setScrollOffset(this.calcOffsetFromMouseY(mouseY));
        } else if (this.isDisabled) {
            textureOffset = ScrollbarControl.GRABBER_TEXTURE.width;
            this.setScrollOffset(0);
        }
        this.func_238474_b_(matrixStack, this.screenX, this.screenY + this.scrollOffset, ScrollbarControl.GRABBER_TEXTURE.x + textureOffset, ScrollbarControl.GRABBER_TEXTURE.y, ScrollbarControl.GRABBER_TEXTURE.width, ScrollbarControl.GRABBER_TEXTURE.height);
    }

    @Override
    public void controlMouseClicked(@Nonnull IControl.MouseButtonEvent e) {
        if (!this.isDisabled) {
            this.setScrollOffset(this.calcOffsetFromMouseY(e.mouseY));
        }
        e.setIsHandled(true);
    }

    @Override
    public void controlMouseScrolled(@Nonnull IControl.MouseScrollEvent e) {
        e.setIsHandled(this.scroll(e.scroll));
    }

    @Override
    public void globalMouseReleased(@Nonnull IControl.MouseButtonEvent e) {
    }

    public boolean scroll(double scroll) {
        int newOffset = this.calcOffsetFromLocalMouseY(this.scrollOffset - (int)(scroll * 10.0));
        if (newOffset == this.scrollOffset) {
            return false;
        }
        this.setScrollOffset(newOffset);
        return true;
    }

    public void setScrollPercentage(double percentage) {
        this.scrollOffset = (int)((double)(this.height - ScrollbarControl.GRABBER_TEXTURE.height) * percentage);
    }

    public void setScrollPercentage(int scroll, int maxScroll) {
        this.setScrollPercentage((double)scroll / (double)maxScroll);
    }

    public double percentageScrolled() {
        return (double)this.scrollOffset / (double)(this.height - ScrollbarControl.GRABBER_TEXTURE.height);
    }

    private int calcOffsetFromMouseY(int mouseY) {
        return this.calcOffsetFromLocalMouseY((int)((float)this.toLocalY(mouseY) / this.getEffectiveScale() - (float)(ScrollbarControl.GRABBER_TEXTURE.height / 2)));
    }

    private int calcOffsetFromLocalMouseY(int localMouseY) {
        int offset = 0;
        offset = localMouseY < 0 ? 0 : (localMouseY > this.height - ScrollbarControl.GRABBER_TEXTURE.height ? this.height - ScrollbarControl.GRABBER_TEXTURE.height : localMouseY);
        return offset;
    }

    private void setScrollOffset(int scrollOffset) {
        this.scrollOffset = scrollOffset;
        this.onScroll.handle(new ScrollEvent(this.percentageScrolled()));
    }

    public static class ScrollEvent
    extends Event {
        public final double scrollPercentage;

        public ScrollEvent(double scrollPercentage) {
            this.scrollPercentage = scrollPercentage;
        }
    }
}

