/*
 * Decompiled with CFR 0.152.
 */
package com.willr27.blocklings.client.gui.controls.common.panel;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.willr27.blocklings.client.gui.Control;
import com.willr27.blocklings.client.gui.GuiUtil;
import com.willr27.blocklings.client.gui.IControl;
import com.willr27.blocklings.client.gui.controls.common.ScrollbarControl;
import com.willr27.blocklings.util.event.CancelableEvent;
import com.willr27.blocklings.util.event.EventHandler;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class StackPanel
extends Control {
    public final EventHandler<ReorderEvent> onReorder = new EventHandler();
    private boolean isReorderable = false;

    public StackPanel(@Nullable IControl parent, int x, int y, int width, int height) {
        super(parent, x, y, width, height);
        this.setIsScrollableY(true);
    }

    @Override
    public void preRender(int mouseX, int mouseY, float partialTicks) {
        Control draggedControl;
        int cumulativeHeight = 0;
        for (Control control : this.getChildren()) {
            control.setY(cumulativeHeight);
            cumulativeHeight += control.getEffectiveHeight();
        }
        this.setMaxScrollY(cumulativeHeight - this.getHeight() + this.getPadding(IControl.Side.TOP) + this.getPadding(IControl.Side.BOTTOM));
        if (this.isReorderable() && this.getItems().size() > 1 && this.getScreen().getDraggedControl() instanceof Control && (draggedControl = (Control)this.getScreen().getDraggedControl()) != null && this.getItems().contains(draggedControl)) {
            int minY = Math.max(this.getItems().get(0).getScreenY(), this.getScreenY());
            int maxY = (int)Math.min((float)this.getItems().get(this.getItems().size() - 1).getScreenY(), (float)this.getScreenY() + (float)this.getEffectiveHeight() * this.getEffectiveScale());
            int draggedY = Math.min(maxY, Math.max(minY, mouseY - draggedControl.getEffectiveHeight() / 2));
            Control closestControl = draggedControl;
            int closestDifY = Integer.MAX_VALUE;
            int closestAbsDifY = Integer.MAX_VALUE;
            int midY = draggedY + draggedControl.getEffectiveHeight() / 2;
            for (Control control : this.getItems()) {
                int testMidY = control.getScreenY() + control.getEffectiveHeight() / 2;
                int difY = testMidY - midY;
                int difAbsY = Math.abs(difY);
                if (difAbsY >= closestAbsDifY) continue;
                closestDifY = difY;
                closestAbsDifY = difAbsY;
                closestControl = control;
            }
            if (mouseY < minY) {
                this.setScrollY((int)((float)this.getScrollY() - 12.0f * partialTicks));
            } else if (mouseY > maxY) {
                this.setScrollY((int)((float)this.getScrollY() + 12.0f * partialTicks));
            }
            draggedControl.setY((int)((float)this.toLocalY(draggedY) / draggedControl.getEffectiveScale() + (float)this.getScrollY() - (float)draggedControl.getMargin(IControl.Side.TOP)));
            int oldIndex = this.getItems().indexOf(draggedControl);
            int newIndex = this.getItems().indexOf(closestControl);
            if (oldIndex != newIndex) {
                ReorderEvent e = new ReorderEvent(oldIndex, newIndex);
                this.onReorder.handle(e);
                if (!e.isCancelled()) {
                    if (newIndex < oldIndex) {
                        draggedControl.setZIndex(newIndex);
                    } else {
                        closestControl.setZIndex(oldIndex);
                    }
                }
            }
        }
        if (this.scrollbarControlY != null) {
            if (this.getMaxScrollY() > 0) {
                this.scrollbarControlY.setIsDisabled(false);
                this.scrollbarControlY.setScrollPercentage(this.getScrollY(), this.getMaxScrollY());
            } else {
                this.scrollbarControlY.setIsDisabled(true);
            }
        }
    }

    @Override
    public void render(@Nonnull MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
    }

    @Override
    public void controlMouseScrolled(@Nonnull IControl.MouseScrollEvent e) {
        int adjustedScroll = (int)(e.scroll * 8.0);
        if (GuiUtil.isKeyDown(341) || GuiUtil.isKeyDown(345)) {
            this.setScrollX(this.getScrollX() - adjustedScroll);
        } else {
            this.setScrollY(this.getScrollY() - adjustedScroll);
        }
        e.setIsHandled(true);
    }

    private void onScrollbarScroll(@Nonnull ScrollbarControl.ScrollEvent e) {
        this.setScrollY((int)Math.ceil(e.scrollPercentage * (double)this.getMaxScrollY()));
    }

    protected List<Control> getItems() {
        return this.getChildrenCopy();
    }

    public boolean isReorderable() {
        return this.isReorderable;
    }

    public void setIsReorderable(boolean reorderable) {
        this.isReorderable = reorderable;
    }

    @Override
    public void setScrollbarY(@Nullable ScrollbarControl scrollbarControl) {
        if (this.scrollbarControlY != null) {
            this.scrollbarControlY.onScroll.unsubscribe(this::onScrollbarScroll);
        }
        this.scrollbarControlY = scrollbarControl;
        if (this.scrollbarControlY != null) {
            this.scrollbarControlY.onScroll.subscribe(this::onScrollbarScroll);
            this.scrollbarControlY.setScrollPercentage(this.getScrollY(), this.getMaxScrollY());
        }
    }

    public static class ReorderEvent
    extends CancelableEvent {
        public final int oldIndex;
        public final int newIndex;

        public ReorderEvent(int oldIndex, int newIndex) {
            this.oldIndex = oldIndex;
            this.newIndex = newIndex;
        }
    }
}

