/*
 * Decompiled with CFR 0.152.
 */
package com.willr27.blocklings.client.gui.controls.skills;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.willr27.blocklings.client.gui.Control;
import com.willr27.blocklings.client.gui.GuiUtil;
import com.willr27.blocklings.client.gui.IControl;
import com.willr27.blocklings.client.gui.controls.skills.SkillControl;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class BuySkillConfirmationControl
extends Control {
    @Nonnull
    private final SkillControl skillControl;
    @Nonnull
    private final List<String> message;
    private final int areaWidth;
    private final int areaHeight;
    @Nonnull
    private final Button yesButton;
    @Nonnull
    private final Button noButton;

    public BuySkillConfirmationControl(@Nonnull IControl parent, @Nonnull SkillControl skillControl, @Nonnull List<String> message, int width, int height, int areaWidth, int areaHeight) {
        super(parent, 0, 0, width, height);
        this.skillControl = skillControl;
        this.message = message;
        this.areaWidth = areaWidth;
        this.areaHeight = areaHeight;
        int buttonWidth = 50;
        int buttonHeight = 20;
        int yesX = width / 2 - 30 - buttonWidth / 2;
        int noX = width / 2 + 30 - buttonWidth / 2;
        int buttonY = height / 2 + 10;
        this.yesButton = new Button(yesX + this.getX(), buttonY + this.getY(), buttonWidth, buttonHeight, (ITextComponent)new StringTextComponent("Yes"), press -> {
            this.setIsVisible(true);
            this.skillControl.skill.tryBuy();
            skillControl.isSelected = false;
        });
        this.noButton = new Button(noX + this.getY(), buttonY + this.getY(), buttonWidth, buttonHeight, (ITextComponent)new StringTextComponent("No"), press -> {
            this.setIsVisible(false);
            skillControl.isSelected = false;
        });
    }

    @Override
    public void render(@Nonnull MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        BuySkillConfirmationControl.func_238467_a_((MatrixStack)matrixStack, (int)(this.screenX + this.width / 2 - this.areaWidth / 2), (int)(this.screenY + this.height / 2 - this.areaHeight / 2), (int)(this.screenX + this.width / 2 + this.areaWidth / 2), (int)(this.screenY + this.height / 2 + this.areaHeight / 2), (int)-1157627904);
        int i = 0;
        for (String str : this.message) {
            BuySkillConfirmationControl.func_238471_a_((MatrixStack)matrixStack, (FontRenderer)this.font, (String)str, (int)(this.getScreenX() + this.width / 2), (int)(this.getScreenY() + this.height / 2 + i * 11 - this.message.size() * 11 - 5), (int)0xFFFFFF);
            ++i;
        }
        matrixStack.func_227861_a_((double)((float)this.getScreenX() - (float)this.getScreenX() / this.getEffectiveScale()), (double)((float)this.getScreenY() - (float)this.getScreenY() / this.getEffectiveScale()), 0.0);
        matrixStack.func_227861_a_((double)((float)this.parent.getScreenX() / this.parent.getEffectiveScale()), (double)((float)this.parent.getScreenY() / this.parent.getEffectiveScale()), 0.0);
        this.yesButton.func_230430_a_(matrixStack, (int)((float)this.toLocalX(mouseX) / this.getEffectiveScale()), (int)((float)this.toLocalY(mouseY) / this.getEffectiveScale()), 0.0f);
        this.noButton.func_230430_a_(matrixStack, (int)((float)this.toLocalX(mouseX) / this.getEffectiveScale()), (int)((float)this.toLocalY(mouseY) / this.getEffectiveScale()), 0.0f);
        matrixStack.func_227861_a_((double)((float)this.getScreenX() / this.getEffectiveScale() - (float)this.getScreenX()), (double)((float)this.getScreenY() / this.getEffectiveScale() - (float)this.getScreenY()), 0.0);
    }

    @Override
    public void controlKeyPressed(@Nonnull IControl.KeyEvent e) {
        if (GuiUtil.isCloseInventoryKey(e.keyCode)) {
            this.noButton.func_230930_b_();
            this.remove();
            e.setIsHandled(true);
        }
    }

    @Override
    public void controlMouseReleased(@Nonnull IControl.MouseButtonEvent e) {
        if (this.yesButton.func_231047_b_((double)((int)((float)this.toLocalX(e.mouseX) / this.getEffectiveScale())), (double)((int)((float)this.toLocalY(e.mouseY) / this.getEffectiveScale())))) {
            this.yesButton.func_231048_c_((double)((int)((float)this.toLocalX(e.mouseX) / this.getEffectiveScale())), (double)((int)((float)this.toLocalY(e.mouseY) / this.getEffectiveScale())), e.button);
            this.yesButton.func_230930_b_();
            this.setIsVisible(false);
            this.remove();
        } else if (this.noButton.func_231047_b_((double)((int)((float)this.toLocalX(e.mouseX) / this.getEffectiveScale())), (double)((int)((float)this.toLocalY(e.mouseY) / this.getEffectiveScale())))) {
            this.noButton.func_231048_c_((double)((int)((float)this.toLocalX(e.mouseX) / this.getEffectiveScale())), (double)((int)((float)this.toLocalY(e.mouseY) / this.getEffectiveScale())), e.button);
            this.noButton.func_230930_b_();
            this.skillControl.isSelected = false;
            this.setIsVisible(false);
            this.remove();
        }
        e.setIsHandled(true);
    }
}

