/*
 * Decompiled with CFR 0.152.
 */
package com.willr27.blocklings.client.gui.controls.skills;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.willr27.blocklings.client.gui.Control;
import com.willr27.blocklings.client.gui.GuiTexture;
import com.willr27.blocklings.client.gui.GuiTextures;
import com.willr27.blocklings.client.gui.GuiUtil;
import com.willr27.blocklings.client.gui.IControl;
import com.willr27.blocklings.client.gui.controls.TexturedControl;
import com.willr27.blocklings.client.gui.controls.skills.SkillsControl;
import com.willr27.blocklings.entity.blockling.attribute.Attribute;
import com.willr27.blocklings.entity.blockling.attribute.BlocklingAttributes;
import com.willr27.blocklings.entity.blockling.skill.Skill;
import com.willr27.blocklings.util.BlocklingsTranslationTextComponent;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.util.text.TextFormatting;

public class SkillControl
extends Control {
    private static final int PADDING = 5;
    private static final int DESCRIPTION_START_OFFSET_Y = 4;
    private static final int HOVER_BOX_WIDTH = 200;
    private static final int HOVER_BOX_HEIGHT = 20;
    private static final int NAME_TEXTURE_Y = 166;
    private static final int DESCRIPTION_TEXTURE_Y = 186;
    private static final int OUTER_WIDTH = 2;
    @Nonnull
    public final SkillsControl skillsControl;
    @Nonnull
    public final Skill skill;
    @Nonnull
    public List<SkillControl> parents = new ArrayList<SkillControl>();
    public boolean isSelected = false;

    public SkillControl(@Nonnull SkillsControl skillsControl, @Nonnull Skill skill) {
        super(skillsControl, skill.info.gui.x, skill.info.gui.y, skill.info.gui.iconTexture.width, skill.info.gui.iconTexture.height);
        this.skillsControl = skillsControl;
        this.skill = skill;
    }

    @Override
    public void render(@Nonnull MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        matrixStack.func_227860_a_();
        if (!this.skillsControl.skillBuyConfirmationControl.isVisible() && this.skillsControl.isMouseOver(mouseX, mouseY) && this.isMouseOver(mouseX, mouseY)) {
            GuiUtil.disableScissor();
            matrixStack.func_227861_a_((double)((float)this.getScreenX() - (float)this.getScreenX() / this.getEffectiveScale()), (double)((float)this.getScreenY() - (float)this.getScreenY() / this.getEffectiveScale()), 0.0);
            matrixStack.func_227862_a_(1.0f / this.getEffectiveScale(), 1.0f / this.getEffectiveScale(), 1.0f);
            matrixStack.func_227861_a_(0.0, 0.0, 10.0);
            this.renderHover(matrixStack);
            matrixStack.func_227862_a_(this.getEffectiveScale(), this.getEffectiveScale(), 1.0f);
            matrixStack.func_227861_a_((double)((float)this.getScreenX() / this.getEffectiveScale() - (float)this.getScreenX()), (double)((float)this.getScreenY() / this.getEffectiveScale() - (float)this.getScreenY()), 0.0);
        }
        Skill.State state = this.skill.getState();
        Color colour = state.colour;
        if (this.isSelected) {
            RenderSystem.color3f((float)0.7f, (float)1.0f, (float)0.7f);
        } else if (this.skill.hasConflict() && state != Skill.State.LOCKED) {
            RenderSystem.color3f((float)0.8f, (float)0.6f, (float)0.6f);
        } else if (state == Skill.State.UNLOCKED && !this.skill.canBuy()) {
            RenderSystem.color3f((float)0.8f, (float)0.6f, (float)0.6f);
        } else {
            RenderSystem.color3f((float)((float)colour.getRed() / 255.0f), (float)((float)colour.getGreen() / 255.0f), (float)((float)colour.getBlue() / 255.0f));
        }
        this.renderTexture(matrixStack, this.skill.info.general.type.texture);
        if (state == Skill.State.LOCKED) {
            RenderSystem.color3f((float)0.0f, (float)0.0f, (float)0.0f);
        } else if (this.skill.hasConflict()) {
            RenderSystem.color3f((float)0.8f, (float)0.6f, (float)0.6f);
        } else if (state == Skill.State.UNLOCKED && !this.skill.canBuy()) {
            RenderSystem.color3f((float)0.8f, (float)0.6f, (float)0.6f);
        } else {
            RenderSystem.color3f((float)1.0f, (float)1.0f, (float)1.0f);
        }
        this.renderTexture(matrixStack, this.skill.info.gui.iconTexture);
        RenderSystem.color3f((float)1.0f, (float)1.0f, (float)1.0f);
        if (this.isMouseOver(mouseX, mouseY)) {
            GuiUtil.enableStackedScissor();
        }
        matrixStack.func_227865_b_();
    }

    public void renderHover(@Nonnull MatrixStack matrixStack) {
        Skill.State state = this.skill.getState();
        String name = this.skill.info.general.name.getString();
        int maxWidth = this.font.func_78256_a(name) + this.skill.info.gui.iconTexture.width + 5 - 1;
        List<String> description = GuiUtil.splitText(this.font, this.skill.info.general.desc.getString(), Math.max(maxWidth, 130));
        if (state == Skill.State.LOCKED) {
            name = new BlocklingsTranslationTextComponent("skill.unknown").getString();
            description.clear();
            description.add("...");
        } else {
            List<Skill> conflicts;
            Map<BlocklingAttributes.Level, Integer> levelRequirements = this.skill.info.requirements.levels;
            if (levelRequirements.size() > 0) {
                description.add("");
                description.add(new BlocklingsTranslationTextComponent("requirements").getString());
                if (levelRequirements.size() > 0) {
                    for (Object level : levelRequirements.keySet()) {
                        int value = (Integer)levelRequirements.get(level);
                        Attribute<Integer> attribute = this.skill.blockling.getStats().getLevelAttribute((BlocklingAttributes.Level)((Object)level));
                        String colour = attribute.getValue() >= value ? "" + TextFormatting.GREEN : "" + TextFormatting.RED;
                        description.add(colour + attribute.createTranslation("required", value).getString() + " " + TextFormatting.DARK_GRAY + "(" + this.skill.blockling.getStats().getLevelAttribute((BlocklingAttributes.Level)((Object)level)).getValue() + ")");
                    }
                }
            }
            if (!(conflicts = this.skill.conflicts()).isEmpty()) {
                description.add("");
                description.add(new BlocklingsTranslationTextComponent("conflicts").getString());
                for (Skill conflict : conflicts) {
                    description.add(TextFormatting.RED + conflict.info.general.name.getString());
                }
            }
        }
        for (String str : description) {
            int width = this.font.func_78256_a(str);
            if (width <= maxWidth) continue;
            maxWidth = width;
        }
        int startX = 4;
        int endX = startX + (maxWidth += 10);
        int nameY = 2;
        int descY = nameY + 23;
        RenderSystem.enableDepthTest();
        RenderSystem.color3f((float)1.0f, (float)1.0f, (float)1.0f);
        TexturedControl texturedControl = new TexturedControl(this, startX, descY - 4, new GuiTexture(GuiTextures.SKILLS, 0, 188, maxWidth, 4));
        matrixStack.func_227862_a_(texturedControl.getEffectiveScale(), texturedControl.getEffectiveScale(), 1.0f);
        matrixStack.func_227861_a_((double)((float)texturedControl.getScreenX() / texturedControl.getEffectiveScale() - (float)texturedControl.getScreenX()), (double)((float)texturedControl.getScreenY() / texturedControl.getEffectiveScale() - (float)texturedControl.getScreenY()), 0.0);
        texturedControl.render(matrixStack, 0, 0, 0.0f);
        matrixStack.func_227861_a_((double)((float)texturedControl.getScreenX() - (float)texturedControl.getScreenX() / texturedControl.getEffectiveScale()), (double)((float)texturedControl.getScreenY() - (float)texturedControl.getScreenY() / texturedControl.getEffectiveScale()), 0.0);
        matrixStack.func_227862_a_(1.0f / texturedControl.getEffectiveScale(), 1.0f / texturedControl.getEffectiveScale(), 1.0f);
        this.removeChild(texturedControl);
        texturedControl = new TexturedControl(this, endX, descY - 4, new GuiTexture(GuiTextures.SKILLS, 198, 188, 2, 4));
        matrixStack.func_227862_a_(texturedControl.getEffectiveScale(), texturedControl.getEffectiveScale(), 1.0f);
        matrixStack.func_227861_a_((double)((float)texturedControl.getScreenX() / texturedControl.getEffectiveScale() - (float)texturedControl.getScreenX()), (double)((float)texturedControl.getScreenY() / texturedControl.getEffectiveScale() - (float)texturedControl.getScreenY()), 0.0);
        texturedControl.render(matrixStack, 0, 0, 0.0f);
        matrixStack.func_227861_a_((double)((float)texturedControl.getScreenX() - (float)texturedControl.getScreenX() / texturedControl.getEffectiveScale()), (double)((float)texturedControl.getScreenY() - (float)texturedControl.getScreenY() / texturedControl.getEffectiveScale()), 0.0);
        matrixStack.func_227862_a_(1.0f / texturedControl.getEffectiveScale(), 1.0f / texturedControl.getEffectiveScale(), 1.0f);
        this.removeChild(texturedControl);
        int gap = 10;
        int i = 0;
        for (String str : description) {
            TexturedControl lineControl = new TexturedControl(this, startX, descY + i * gap, new GuiTexture(GuiTextures.SKILLS, 0, 188, maxWidth, gap));
            matrixStack.func_227862_a_(lineControl.getEffectiveScale(), lineControl.getEffectiveScale(), 1.0f);
            matrixStack.func_227861_a_((double)((float)lineControl.getScreenX() / lineControl.getEffectiveScale() - (float)lineControl.getScreenX()), (double)((float)lineControl.getScreenY() / lineControl.getEffectiveScale() - (float)lineControl.getScreenY()), 0.0);
            lineControl.render(matrixStack, 0, 0, 0.0f);
            matrixStack.func_227861_a_((double)((float)lineControl.getScreenX() - (float)lineControl.getScreenX() / lineControl.getEffectiveScale()), (double)((float)lineControl.getScreenY() - (float)lineControl.getScreenY() / lineControl.getEffectiveScale()), 0.0);
            matrixStack.func_227862_a_(1.0f / lineControl.getEffectiveScale(), 1.0f / lineControl.getEffectiveScale(), 1.0f);
            texturedControl = new TexturedControl(this, endX, descY + i * gap, new GuiTexture(GuiTextures.SKILLS, 198, 188, 2, gap));
            matrixStack.func_227862_a_(texturedControl.getEffectiveScale(), texturedControl.getEffectiveScale(), 1.0f);
            matrixStack.func_227861_a_((double)((float)texturedControl.getScreenX() / texturedControl.getEffectiveScale() - (float)texturedControl.getScreenX()), (double)((float)texturedControl.getScreenY() / texturedControl.getEffectiveScale() - (float)texturedControl.getScreenY()), 0.0);
            texturedControl.render(matrixStack, 0, 0, 0.0f);
            matrixStack.func_227861_a_((double)((float)texturedControl.getScreenX() - (float)texturedControl.getScreenX() / texturedControl.getEffectiveScale()), (double)((float)texturedControl.getScreenY() - (float)texturedControl.getScreenY() / texturedControl.getEffectiveScale()), 0.0);
            matrixStack.func_227862_a_(1.0f / texturedControl.getEffectiveScale(), 1.0f / texturedControl.getEffectiveScale(), 1.0f);
            this.removeChild(texturedControl);
            matrixStack.func_227862_a_(lineControl.getEffectiveScale(), lineControl.getEffectiveScale(), 1.0f);
            matrixStack.func_227861_a_((double)((float)lineControl.getScreenX() / lineControl.getEffectiveScale() - (float)lineControl.getScreenX()), (double)((float)lineControl.getScreenY() / lineControl.getEffectiveScale() - (float)lineControl.getScreenY()), 0.0);
            lineControl.renderShadowedText(matrixStack, str, 5, 0, false, -1);
            matrixStack.func_227861_a_((double)((float)lineControl.getScreenX() - (float)lineControl.getScreenX() / lineControl.getEffectiveScale()), (double)((float)lineControl.getScreenY() - (float)lineControl.getScreenY() / lineControl.getEffectiveScale()), 0.0);
            matrixStack.func_227862_a_(1.0f / lineControl.getEffectiveScale(), 1.0f / lineControl.getEffectiveScale(), 1.0f);
            this.removeChild(lineControl);
            ++i;
        }
        texturedControl = new TexturedControl(this, startX, descY + i * gap - 1, new GuiTexture(GuiTextures.SKILLS, 0, 203, maxWidth, 3));
        matrixStack.func_227862_a_(texturedControl.getEffectiveScale(), texturedControl.getEffectiveScale(), 1.0f);
        matrixStack.func_227861_a_((double)((float)texturedControl.getScreenX() / texturedControl.getEffectiveScale() - (float)texturedControl.getScreenX()), (double)((float)texturedControl.getScreenY() / texturedControl.getEffectiveScale() - (float)texturedControl.getScreenY()), 0.0);
        texturedControl.render(matrixStack, 0, 0, 0.0f);
        matrixStack.func_227861_a_((double)((float)texturedControl.getScreenX() - (float)texturedControl.getScreenX() / texturedControl.getEffectiveScale()), (double)((float)texturedControl.getScreenY() - (float)texturedControl.getScreenY() / texturedControl.getEffectiveScale()), 0.0);
        matrixStack.func_227862_a_(1.0f / texturedControl.getEffectiveScale(), 1.0f / texturedControl.getEffectiveScale(), 1.0f);
        this.removeChild(texturedControl);
        texturedControl = new TexturedControl(this, endX, descY + i * gap - 1, new GuiTexture(GuiTextures.SKILLS, 198, 203, 2, 3));
        matrixStack.func_227862_a_(texturedControl.getEffectiveScale(), texturedControl.getEffectiveScale(), 1.0f);
        matrixStack.func_227861_a_((double)((float)texturedControl.getScreenX() / texturedControl.getEffectiveScale() - (float)texturedControl.getScreenX()), (double)((float)texturedControl.getScreenY() / texturedControl.getEffectiveScale() - (float)texturedControl.getScreenY()), 0.0);
        texturedControl.render(matrixStack, 0, 0, 0.0f);
        matrixStack.func_227861_a_((double)((float)texturedControl.getScreenX() - (float)texturedControl.getScreenX() / texturedControl.getEffectiveScale()), (double)((float)texturedControl.getScreenY() - (float)texturedControl.getScreenY() / texturedControl.getEffectiveScale()), 0.0);
        matrixStack.func_227862_a_(1.0f / texturedControl.getEffectiveScale(), 1.0f / texturedControl.getEffectiveScale(), 1.0f);
        this.removeChild(texturedControl);
        TexturedControl nameControl = new TexturedControl(this, startX, nameY, new GuiTexture(GuiTextures.SKILLS, 0, 166, maxWidth, 20));
        TexturedControl nameControlEnd = new TexturedControl(this, endX, nameY, new GuiTexture(GuiTextures.SKILLS, 198, 166, 2, 20));
        if (state == Skill.State.LOCKED) {
            RenderSystem.color3f((float)0.5f, (float)0.5f, (float)0.5f);
        } else {
            RenderSystem.color3f((float)((float)this.skill.info.gui.colour.getRed() / 255.0f), (float)((float)this.skill.info.gui.colour.getGreen() / 255.0f), (float)((float)this.skill.info.gui.colour.getBlue() / 255.0f));
        }
        matrixStack.func_227862_a_(nameControl.getEffectiveScale(), nameControl.getEffectiveScale(), 1.0f);
        matrixStack.func_227861_a_((double)((float)nameControl.getScreenX() / nameControl.getEffectiveScale() - (float)nameControl.getScreenX()), (double)((float)nameControl.getScreenY() / nameControl.getEffectiveScale() - (float)nameControl.getScreenY()), 0.0);
        nameControl.render(matrixStack, 0, 0, 0.0f);
        nameControl.renderShadowedText(matrixStack, name, this.skill.info.gui.iconTexture.width, 6, false, -1);
        matrixStack.func_227861_a_((double)((float)nameControl.getScreenX() - (float)nameControl.getScreenX() / nameControl.getEffectiveScale()), (double)((float)nameControl.getScreenY() - (float)nameControl.getScreenY() / nameControl.getEffectiveScale()), 0.0);
        matrixStack.func_227862_a_(1.0f / nameControl.getEffectiveScale(), 1.0f / nameControl.getEffectiveScale(), 1.0f);
        matrixStack.func_227862_a_(nameControlEnd.getEffectiveScale(), nameControlEnd.getEffectiveScale(), 1.0f);
        matrixStack.func_227861_a_((double)((float)nameControlEnd.getScreenX() / nameControlEnd.getEffectiveScale() - (float)nameControlEnd.getScreenX()), (double)((float)nameControlEnd.getScreenY() / nameControlEnd.getEffectiveScale() - (float)nameControlEnd.getScreenY()), 0.0);
        nameControlEnd.render(matrixStack, 0, 0, 0.0f);
        matrixStack.func_227861_a_((double)((float)nameControlEnd.getScreenX() - (float)nameControlEnd.getScreenX() / nameControlEnd.getEffectiveScale()), (double)((float)nameControlEnd.getScreenY() - (float)nameControlEnd.getScreenY() / nameControlEnd.getEffectiveScale()), 0.0);
        matrixStack.func_227862_a_(1.0f / nameControlEnd.getEffectiveScale(), 1.0f / nameControlEnd.getEffectiveScale(), 1.0f);
        this.removeChild(nameControl);
        this.removeChild(nameControlEnd);
    }

    public void renderParentPathBackgrounds(@Nonnull MatrixStack matrixStack) {
        this.parents.forEach(parentControl -> this.renderPath(matrixStack, (SkillControl)parentControl, 4, -16777216, this.skill.info.gui.connectionType));
    }

    public void renderParentPathForegrounds(@Nonnull MatrixStack matrixStack) {
        for (SkillControl parentControl : this.parents) {
            Skill.State state = parentControl.skill.getState();
            int colour = state.colour.darker().darker().getRGB();
            if (state == Skill.State.BOUGHT) {
                colour = 0xFFFFFF;
            }
            this.renderPath(matrixStack, parentControl, 2, -16777216 + colour, this.skill.info.gui.connectionType);
        }
    }

    public void renderPath(@Nonnull MatrixStack matrixStack, @Nonnull SkillControl skill, int width, int colour, @Nonnull ConnectionType connectionType) {
        this.renderPath(matrixStack, this.findPath(skill, connectionType), width, colour);
    }

    private void renderPath(@Nonnull MatrixStack matrixStack, @Nonnull Vec2i[] path, int width, int colour) {
        width = (int)((float)width * this.getEffectiveScale());
        for (int i = 0; i < path.length - 1; ++i) {
            int x1 = path[i].x;
            int y1 = path[i].y;
            int x2 = path[i + 1].x;
            int y2 = path[i + 1].y;
            int dx = x2 - x1;
            int dy = y2 - y1;
            Direction direction = Direction.RIGHT;
            if (dx < 0) {
                direction = Direction.LEFT;
            } else if (dy < 0) {
                direction = Direction.UP;
            } else if (dy > 0) {
                direction = Direction.DOWN;
            }
            int d = (width + 1) / 2;
            if (direction == Direction.RIGHT) {
                y1 -= d;
                x2 += d;
                y2 += d;
            } else if (direction == Direction.LEFT) {
                y1 -= d;
                x2 -= d;
                y2 += d;
            } else if (direction == Direction.UP) {
                x1 -= d;
                x2 += d;
                y2 -= d;
            } else if (direction == Direction.DOWN) {
                x1 -= d;
                x2 += d;
                y2 += d;
            }
            if (x1 == x2 || y1 == y2) continue;
            float guiScale = (float)Minecraft.func_71410_x().func_228018_at_().func_198100_s();
            MatrixStack matrixStack1 = new MatrixStack();
            matrixStack1.func_227862_a_(1.0f / guiScale, 1.0f / guiScale, 1.0f);
            SkillControl.func_238467_a_((MatrixStack)matrixStack1, (int)x1, (int)y1, (int)x2, (int)y2, (int)colour);
        }
    }

    @Nonnull
    private Vec2i[] findPath(@Nonnull SkillControl ability, @Nonnull ConnectionType connectionType) {
        Vec2i[] path = new Vec2i[3];
        int x1 = this.screenX + this.getScreenWidth() / 2;
        int y1 = this.screenY + this.getScreenHeight() / 2;
        int x2 = ability.screenX + ability.getScreenWidth() / 2;
        int y2 = ability.screenY + ability.getScreenHeight() / 2;
        if (connectionType == ConnectionType.SINGLE_LONGEST_FIRST || connectionType == ConnectionType.SINGLE_SHORTEST_FIRST) {
            int dx = x2 - x1;
            int dy = y2 - y1;
            int cx = dx;
            int cy = dy;
            if (connectionType == ConnectionType.SINGLE_LONGEST_FIRST) {
                cx = dy;
                cy = dx;
            }
            path[1] = Math.abs(cx) > Math.abs(cy) ? new Vec2i(x1 + dx, y1) : new Vec2i(x1, y1 + dy);
        } else if (connectionType == ConnectionType.DOUBLE_SHORTEST_SPLIT || connectionType == ConnectionType.DOUBLE_LONGEST_SPLIT) {
            path = new Vec2i[4];
            int dx = x2 - x1;
            int dy = y2 - y1;
            int cx = dx;
            int cy = dy;
            if (connectionType == ConnectionType.DOUBLE_SHORTEST_SPLIT) {
                cx = dy;
                cy = dx;
            }
            if (Math.abs(cx) > Math.abs(cy)) {
                path[1] = new Vec2i(x1 + dx / 2, y1);
                path[2] = new Vec2i(x1 + dx / 2, y1 + dy);
            } else {
                path[1] = new Vec2i(x1, y1 + dy / 2);
                path[2] = new Vec2i(x1 + dx, y1 + dy / 2);
            }
        }
        path[0] = new Vec2i(x1, y1);
        path[path.length - 1] = new Vec2i(x2, y2);
        return path;
    }

    @Override
    public void controlMouseReleased(@Nonnull IControl.MouseButtonEvent e) {
    }

    @Override
    public void globalMouseReleased(@Nonnull IControl.MouseButtonEvent e) {
        if (e.isHandled()) {
            return;
        }
        if (!this.isMouseOver(e.mouseX, e.mouseY)) {
            this.isSelected = false;
        } else if (!this.skill.isBought() && this.skill.getState() == Skill.State.UNLOCKED && !this.skill.hasConflict()) {
            if (this.isSelected) {
                this.skillsControl.openConfirmationDialog(this);
            } else {
                this.isSelected = true;
            }
        }
    }

    private static class Vec2i {
        public final int x;
        public final int y;

        public Vec2i(int x, int y) {
            this.x = x;
            this.y = y;
        }
    }

    public static enum ConnectionType {
        SINGLE_LONGEST_FIRST,
        SINGLE_SHORTEST_FIRST,
        DOUBLE_LONGEST_SPLIT,
        DOUBLE_SHORTEST_SPLIT;

    }

    private static enum Direction {
        LEFT,
        UP,
        RIGHT,
        DOWN;

    }
}

