/*
 * Decompiled with CFR 0.152.
 */
package com.willr27.blocklings.client.gui.controls.skills;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.willr27.blocklings.client.gui.Control;
import com.willr27.blocklings.client.gui.GuiTextures;
import com.willr27.blocklings.client.gui.GuiUtil;
import com.willr27.blocklings.client.gui.IControl;
import com.willr27.blocklings.client.gui.controls.skills.BuySkillConfirmationControl;
import com.willr27.blocklings.client.gui.controls.skills.SkillControl;
import com.willr27.blocklings.client.gui.screens.SkillsScreen;
import com.willr27.blocklings.entity.blockling.BlocklingEntity;
import com.willr27.blocklings.entity.blockling.skill.Skill;
import com.willr27.blocklings.entity.blockling.skill.SkillGroup;
import com.willr27.blocklings.util.BlocklingsTranslationTextComponent;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class SkillsControl
extends Control {
    public static final int SKILL_SIZE = 24;
    private static final int TILE_SIZE = 16;
    private final int backgroundOffsetX;
    private final int backgroundOffsetY;
    @Nonnull
    private final SkillsScreen skillsScreen;
    @Nonnull
    private final SkillGroup group;
    private final int minimisedX;
    private final int minimisedY;
    private final int minimisedWidth;
    private final int minimisedHeight;
    private int tilesX;
    private int tilesY;
    private int dragStartX;
    private int dragStartY;
    private int moveOffsetX;
    private int moveOffsetY;
    private int prevMouseX;
    private int prevMouseY;
    private float totalDragX;
    private float totalDragY;
    private boolean mouseDown;
    private boolean dragging;
    @Nonnull
    private final List<SkillControl> skillControls = new ArrayList<SkillControl>();
    @Nonnull
    public BuySkillConfirmationControl skillBuyConfirmationControl;

    public SkillsControl(@Nonnull IControl parent, @Nonnull BlocklingEntity blockling, @Nonnull SkillGroup group, int minimisedX, int minimisedY, int minimisedWidth, int minimisedHeight) {
        super(parent, minimisedX, minimisedY, minimisedWidth, minimisedHeight);
        this.skillsScreen = (SkillsScreen)this.getScreen();
        this.group = group;
        this.minimisedX = minimisedX;
        this.minimisedY = minimisedY;
        this.minimisedWidth = minimisedWidth;
        this.minimisedHeight = minimisedHeight;
        this.minimise();
        this.backgroundOffsetX = blockling.func_70681_au().nextInt(1000);
        this.backgroundOffsetY = blockling.func_70681_au().nextInt(1000);
        for (Skill skill : group.getSkills()) {
            this.skillControls.add(new SkillControl(this, skill));
        }
        this.skillsScreen.skillsContainer.removeChild(this.skillsScreen.skillBuyConfirmationControl);
        this.skillBuyConfirmationControl = this.skillsScreen.skillBuyConfirmationControl = new BuySkillConfirmationControl(this.skillsScreen.skillsContainer, this.skillControls.get(0), GuiUtil.splitText(this.font, new BlocklingsTranslationTextComponent("skill.buy_confirmation", "").getString(), this.width < 200 ? this.width - 10 : this.width - 50), this.width, this.height, this.width, this.height);
        this.skillBuyConfirmationControl.setIsVisible(false);
        for (SkillControl skillControl : this.skillControls) {
            for (SkillControl skillControl2 : this.skillControls) {
                if (!skillControl.skill.parents().contains(skillControl2.skill)) continue;
                skillControl.parents.add(skillControl2);
            }
        }
    }

    public void maximise() {
        SkillsScreen skillsScreen = (SkillsScreen)this.getScreen();
        skillsScreen.tabbedControl.setIsVisible(false);
        skillsScreen.skillsContainer.setX(-10);
        skillsScreen.skillsContainer.setY(-10);
        this.setX(0);
        this.setY(0);
        skillsScreen.skillsContainer.setWidth(this.screen.field_230708_k_ + 20);
        skillsScreen.skillsContainer.setHeight(this.screen.field_230709_l_ + 20);
        this.resize((int)((float)(this.screen.field_230708_k_ + 20) / this.getScale()), (int)((float)(this.screen.field_230709_l_ + 20) / this.getScale()));
        this.moveOffsetX = (this.width - 24) / 2;
        this.moveOffsetY = (this.height - 24) / 2;
        if (skillsScreen.borderControl != null) {
            skillsScreen.borderControl.setIsVisible(false);
        }
        if (skillsScreen.tabbedControl != null) {
            skillsScreen.tabbedControl.setIsVisible(false);
        }
    }

    public void minimise() {
        SkillsScreen skillsScreen = (SkillsScreen)this.getScreen();
        skillsScreen.tabbedControl.setIsVisible(true);
        skillsScreen.skillsContainer.setX(skillsScreen.contentLeft + 9);
        skillsScreen.skillsContainer.setY(skillsScreen.contentTop + 9);
        this.setX(this.minimisedX);
        this.setY(this.minimisedY);
        skillsScreen.skillsContainer.setWidth(this.minimisedWidth);
        skillsScreen.skillsContainer.setHeight(this.minimisedHeight);
        this.resize((int)((float)this.minimisedWidth / this.getScale()), (int)((float)this.minimisedHeight / this.getScale()));
        this.moveOffsetX = (this.width - 24) / 2;
        this.moveOffsetY = (this.height - 24) / 2;
        if (skillsScreen.borderControl != null) {
            skillsScreen.borderControl.setIsVisible(true);
        }
        if (skillsScreen.tabbedControl != null) {
            skillsScreen.tabbedControl.setIsVisible(true);
        }
    }

    private void resize(int width, int height) {
        this.setWidth(width);
        this.setHeight(height);
        int tileSize = 16;
        this.tilesX = width / tileSize;
        this.tilesY = height / tileSize;
    }

    @Override
    public void render(@Nonnull MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        matrixStack.func_227860_a_();
        this.updatePan((int)((float)mouseX / this.getEffectiveScale()), (int)((float)mouseY / this.getEffectiveScale()));
        this.renderBackground(matrixStack);
        this.renderSkills(matrixStack, mouseX, mouseY);
        matrixStack.func_227865_b_();
        this.prevMouseX = (int)((float)mouseX / this.getEffectiveScale());
        this.prevMouseY = (int)((float)mouseY / this.getEffectiveScale());
    }

    private void updatePan(int mouseX, int mouseY) {
        if (this.mouseDown) {
            boolean drag;
            int difX = Math.abs(mouseX - this.dragStartX);
            int difY = Math.abs(mouseY - this.dragStartY);
            boolean bl = drag = difX > 4 || difY > 4;
            if (drag || this.dragging) {
                this.dragging = true;
                this.totalDragX += (float)(mouseX - this.prevMouseX);
                this.totalDragY += (float)(mouseY - this.prevMouseY);
                if (Math.abs(this.totalDragX) >= 1.0f) {
                    this.moveOffsetX += (int)this.totalDragX;
                    this.totalDragX -= (float)((int)this.totalDragX);
                }
                if (Math.abs(this.totalDragY) >= 1.0f) {
                    this.moveOffsetY += (int)this.totalDragY;
                    this.totalDragY -= (float)((int)this.totalDragY);
                }
            }
        }
    }

    private void renderBackground(@Nonnull MatrixStack matrixStack) {
        GuiUtil.bindTexture(this.group.info.backgroundTexture);
        for (int i = -1; i < this.tilesX + 1; ++i) {
            for (int j = -1; j < this.tilesY + 1; ++j) {
                int x = this.getScreenX() + (16 + this.moveOffsetX % 16) % 16 + i * 16;
                int y = this.getScreenY() + (16 + this.moveOffsetY % 16) % 16 + j * 16;
                int i1 = i - (int)Math.floor((double)this.moveOffsetX / 16.0) + this.backgroundOffsetX;
                int j1 = j - (int)Math.floor((double)this.moveOffsetY / 16.0) + this.backgroundOffsetY;
                int rand = new Random(new Random(i1).nextInt() * new Random(j1).nextInt()).nextInt(256);
                int tileTextureX = rand % 16 * 16;
                int tileTextureY = rand / 16 * 16;
                GuiUtil.addScissorBounds(this.getScreenX(), this.getScreenY(), this.getScreenWidth(), this.getScreenHeight());
                GuiUtil.enableStackedScissor();
                this.func_238474_b_(matrixStack, x, y, tileTextureX, tileTextureY, 16, 16);
                GuiUtil.removeScissorBounds(this.getScreenX(), this.getScreenY(), this.getScreenWidth(), this.getScreenHeight());
            }
        }
    }

    private void renderSkills(@Nonnull MatrixStack matrixStack, int mouseX, int mouseY) {
        GuiUtil.bindTexture(GuiTextures.SKILLS_WIDGETS);
        int x = this.getScreenX() + this.moveOffsetX;
        int y = this.getScreenY() + this.moveOffsetY;
        for (SkillControl skillControl : this.skillControls) {
            skillControl.setX(skillControl.skill.info.gui.x + this.moveOffsetX);
            skillControl.setY(skillControl.skill.info.gui.y + this.moveOffsetY);
        }
        for (SkillControl skillControl : this.skillControls) {
            skillControl.renderParentPathBackgrounds(matrixStack);
        }
        for (SkillControl skillControl : this.skillControls) {
            skillControl.renderParentPathForegrounds(matrixStack);
        }
        RenderSystem.color3f((float)1.0f, (float)1.0f, (float)1.0f);
    }

    @Override
    public void controlMouseClicked(@Nonnull IControl.MouseButtonEvent e) {
        this.dragStartX = (int)((float)e.mouseX / this.getEffectiveScale());
        this.dragStartY = (int)((float)e.mouseY / this.getEffectiveScale());
        this.mouseDown = true;
    }

    @Override
    public void globalMouseReleased(@Nonnull IControl.MouseButtonEvent e) {
        this.mouseDown = false;
        this.dragging = false;
    }

    public void openConfirmationDialog(@Nonnull SkillControl skillControl) {
        this.removeChild(this.skillBuyConfirmationControl);
        String name = TextFormatting.LIGHT_PURPLE + skillControl.skill.info.general.name.getString() + TextFormatting.WHITE;
        this.skillsScreen.skillsContainer.removeChild(this.skillsScreen.skillBuyConfirmationControl);
        this.skillBuyConfirmationControl = this.skillsScreen.skillBuyConfirmationControl = new BuySkillConfirmationControl(this.skillsScreen.skillsContainer, skillControl, GuiUtil.splitText(this.font, new BlocklingsTranslationTextComponent("skill.buy_confirmation", name).getString(), this.skillsScreen.skillsContainer.width < 200 ? this.skillsScreen.skillsContainer.width - 10 : this.skillsScreen.skillsContainer.width - 50), this.skillsScreen.skillsContainer.width, this.skillsScreen.skillsContainer.height, this.skillsScreen.skillsContainer.width, this.skillsScreen.skillsContainer.height);
        this.skillBuyConfirmationControl.setIsFocused(true);
    }

    @Override
    public void controlMouseScrolled(@Nonnull IControl.MouseScrollEvent e) {
        if (this.dragging) {
            e.setIsHandled(true);
            return;
        }
        int localMouseX = (int)((float)this.toLocalX(e.mouseX) / this.getEffectiveScale());
        int localMouseY = (int)((float)this.toLocalY(e.mouseY) / this.getEffectiveScale());
        if (e.scroll > 0.0) {
            float newScale = this.getScale() * 2.0f;
            if ((newScale = Math.min(newScale, 2.0f)) != this.getScale()) {
                this.moveOffsetX = (int)((float)this.moveOffsetX - (float)localMouseX / 2.0f);
                this.moveOffsetY = (int)((float)this.moveOffsetY - (float)localMouseY / 2.0f);
                this.setScale(newScale);
                this.width = (int)((float)this.width / 2.0f);
                this.height = (int)((float)this.height / 2.0f);
            }
        } else {
            float newScale = this.getScale() * 0.5f;
            if ((newScale = Math.max(newScale, 0.25f)) != this.getScale()) {
                this.moveOffsetX += localMouseX;
                this.moveOffsetY += localMouseY;
                this.setScale(newScale);
                this.width = (int)((float)this.width * 2.0f);
                this.height = (int)((float)this.height * 2.0f);
            }
        }
        this.resize(this.width, this.height);
        e.setIsHandled(true);
    }
}

