/*
 * Decompiled with CFR 0.152.
 */
package com.willr27.blocklings.client.gui.controls.stats;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.willr27.blocklings.client.gui.Control;
import com.willr27.blocklings.client.gui.GuiTexture;
import com.willr27.blocklings.client.gui.GuiTextures;
import com.willr27.blocklings.client.gui.GuiUtil;
import com.willr27.blocklings.client.gui.IControl;
import com.willr27.blocklings.entity.blockling.BlocklingEntity;
import com.willr27.blocklings.util.BlocklingsTranslationTextComponent;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class EnumeratingStatControl
extends Control {
    public static final int ICON_SIZE = 11;
    private static final int STAT_ICON_TEXTURE_Y = 166;
    private static final int TEXT_OFFSET_X = 4;
    private static final int TEXT_OFFSET_Y = 1;
    @Nonnull
    protected final List<Supplier<Boolean>> conditionSuppliers = new ArrayList<Supplier<Boolean>>();
    @Nonnull
    protected final List<Supplier<String>> valueSuppliers = new ArrayList<Supplier<String>>();
    @Nonnull
    protected final List<Supplier<List<ITextComponent>>> tooltipSuppliers = new ArrayList<Supplier<List<ITextComponent>>>();
    @Nonnull
    protected final List<GuiTexture> iconTextures = new ArrayList<GuiTexture>();
    @Nonnull
    protected final List<Color> colours = new ArrayList<Color>();
    @Nonnull
    protected final ITextComponent name;
    protected final boolean shouldRightAlignText;
    protected final int enumerationInterval;
    protected final boolean shouldCombineTooltips;
    @Nonnull
    protected final BlocklingEntity blockling;
    protected int tickCount = 0;
    protected int currentEnumeration = 0;

    public EnumeratingStatControl(@Nonnull IControl parent, @Nonnull ITextComponent name, int x, int y, boolean shouldRightAlignText, int enumerationInterval, boolean shouldCombineTooltips, @Nonnull BlocklingEntity blockling) {
        super(parent, x, y, 11, 11);
        this.name = name;
        this.shouldRightAlignText = shouldRightAlignText;
        this.enumerationInterval = enumerationInterval;
        this.shouldCombineTooltips = shouldCombineTooltips;
        this.blockling = blockling;
    }

    public void addStat(@Nonnull Supplier<Boolean> conditionSupplier, @Nonnull Supplier<String> valueSupplier, @Nonnull Supplier<List<ITextComponent>> tooltipSupplier, int iconIndex) {
        this.addStat(conditionSupplier, valueSupplier, tooltipSupplier, iconIndex, Color.WHITE);
    }

    public void addStat(@Nonnull Supplier<Boolean> conditionSupplier, @Nonnull Supplier<String> valueSupplier, @Nonnull Supplier<List<ITextComponent>> tooltipSupplier, int iconIndex, @Nonnull Color colour) {
        this.conditionSuppliers.add(conditionSupplier);
        this.valueSuppliers.add(valueSupplier);
        this.tooltipSuppliers.add(tooltipSupplier);
        this.iconTextures.add(new GuiTexture(GuiTextures.STATS, 11 * iconIndex, 166, 11, 11));
        this.colours.add(colour);
        this.currentEnumeration = this.iconTextures.size() - 1;
    }

    @Override
    public void render(@Nonnull MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        if (this.blockling.field_70173_aa - this.tickCount > this.enumerationInterval) {
            this.tickCount = this.blockling.field_70173_aa;
            this.currentEnumeration = (this.currentEnumeration + 1) % this.iconTextures.size();
        }
        while (!this.conditionSuppliers.get(this.currentEnumeration).get().booleanValue()) {
            this.currentEnumeration = (this.currentEnumeration + 1) % this.iconTextures.size();
        }
        RenderSystem.color3f((float)((float)this.colours.get(this.currentEnumeration).getRed() / 255.0f), (float)((float)this.colours.get(this.currentEnumeration).getGreen() / 255.0f), (float)((float)this.colours.get(this.currentEnumeration).getBlue() / 255.0f));
        this.renderTexture(matrixStack, this.iconTextures.get(this.currentEnumeration));
        this.renderShadowedText(matrixStack, this.valueSuppliers.get(this.currentEnumeration).get(), this.width + 4, 1, this.shouldRightAlignText, 16769280);
    }

    @Override
    public void renderTooltip(@Nonnull MatrixStack matrixStack, int mouseX, int mouseY) {
        if (this.shouldCombineTooltips) {
            this.screen.func_238654_b_(matrixStack, this.prependNameToTooltip(this.combineTooltips()).stream().map(t -> t.func_241878_f()).collect(Collectors.toList()), mouseX, mouseY);
        } else {
            this.screen.func_238654_b_(matrixStack, this.prependNameToTooltip(this.tooltipSuppliers.get(this.currentEnumeration).get()).stream().map(t -> t.func_241878_f()).collect(Collectors.toList()), mouseX, mouseY);
        }
    }

    private List<ITextComponent> prependNameToTooltip(@Nonnull List<ITextComponent> tooltip) {
        tooltip.add(0, this.name);
        return tooltip;
    }

    @Nonnull
    private List<ITextComponent> combineTooltips() {
        ArrayList<ITextComponent> tooltip = new ArrayList<ITextComponent>();
        for (int i = 0; i < this.conditionSuppliers.size(); ++i) {
            if (!this.conditionSuppliers.get(i).get().booleanValue()) continue;
            List<ITextComponent> subTooltip = this.tooltipSuppliers.get(i).get();
            if (i == this.currentEnumeration) {
                subTooltip.set(0, (ITextComponent)new StringTextComponent(subTooltip.get(0).getString().substring(0, 2) + TextFormatting.ITALIC + subTooltip.get(0).getString().substring(2)));
            }
            if (GuiUtil.isKeyDown(Minecraft.func_71410_x().field_71474_y.field_228046_af_.getKey().func_197937_c())) {
                tooltip.addAll(subTooltip);
                continue;
            }
            tooltip.add(subTooltip.get(0));
        }
        if (!GuiUtil.isKeyDown(Minecraft.func_71410_x().field_71474_y.field_228046_af_.getKey().func_197937_c())) {
            tooltip.add((ITextComponent)new StringTextComponent(TextFormatting.DARK_GRAY + "" + TextFormatting.ITALIC + new BlocklingsTranslationTextComponent("gui.more_info", Minecraft.func_71410_x().field_71474_y.field_228046_af_.func_238171_j_().getString()).getString()));
        }
        return tooltip;
    }

    @Override
    public boolean isMouseOver(int mouseX, int mouseY) {
        if (this.shouldRightAlignText) {
            return GuiUtil.isMouseOver(mouseX, mouseY, this.screenX - (this.font.func_78256_a(this.valueSuppliers.get(this.currentEnumeration).get()) + 4 + 3), this.screenY, this.getScreenWidth() + this.font.func_78256_a(this.valueSuppliers.get(this.currentEnumeration).get()) + 4 + 3, this.getScreenHeight());
        }
        return GuiUtil.isMouseOver(mouseX, mouseY, this.screenX, this.screenY, this.getScreenWidth() + this.font.func_78256_a(this.valueSuppliers.get(this.currentEnumeration).get()) + 4 + 3, this.getScreenHeight());
    }

    @Override
    public void controlMouseClicked(@Nonnull IControl.MouseButtonEvent e) {
        this.tickCount = this.blockling.field_70173_aa;
        this.currentEnumeration = (this.currentEnumeration + 1) % this.iconTextures.size();
        while (!this.conditionSuppliers.get(this.currentEnumeration).get().booleanValue()) {
            this.currentEnumeration = (this.currentEnumeration + 1) % this.iconTextures.size();
        }
        e.setIsHandled(true);
    }
}

