/*
 * Decompiled with CFR 0.152.
 */
package com.willr27.blocklings.client.gui.controls.stats;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.willr27.blocklings.client.gui.Control;
import com.willr27.blocklings.client.gui.GuiTexture;
import com.willr27.blocklings.client.gui.GuiTextures;
import com.willr27.blocklings.client.gui.IControl;
import com.willr27.blocklings.client.gui.screens.StatsScreen;
import com.willr27.blocklings.entity.blockling.BlocklingEntity;
import com.willr27.blocklings.entity.blockling.attribute.Attribute;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class HealthBarControl
extends Control {
    @Nonnull
    private static final GuiTexture BACKGROUND_TEXTURE = new GuiTexture(GuiTextures.STATS, 0, 228, 134, 5);
    @Nonnull
    private final BlocklingEntity blockling;

    public HealthBarControl(@Nonnull IControl parent, @Nonnull BlocklingEntity blockling, int x, int y) {
        super(parent, x, y - 2, HealthBarControl.BACKGROUND_TEXTURE.width, HealthBarControl.BACKGROUND_TEXTURE.height + 4);
        this.blockling = blockling;
    }

    @Override
    public void render(@Nonnull MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        RenderSystem.color3f((float)0.5f, (float)0.5f, (float)0.5f);
        this.renderTexture(matrixStack, 0, 2, BACKGROUND_TEXTURE);
        RenderSystem.color3f((float)((float)((double)1.3f - Math.ceil(this.blockling.func_110143_aJ()) / (double)this.blockling.func_110138_aP())), (float)(0.3f + (float)(Math.ceil(this.blockling.func_110143_aJ()) / (double)this.blockling.func_110138_aP())), (float)0.1f);
        this.renderTexture(matrixStack, 0, 2, new GuiTexture(GuiTextures.STATS, 0, 228, (int)(134.0 * (Math.ceil(this.blockling.func_110143_aJ()) / (double)this.blockling.func_110138_aP())), 5));
        int r = (int)(215.0f - this.blockling.getStats().getHealthPercentage() * 150.0f);
        int g = (int)(50.0f + this.blockling.getStats().getHealthPercentage() * 180.0f);
        int b = 50;
        String healthText = this.blockling.getStats().getHealth() + "/" + this.blockling.getStats().getMaxHealth();
        this.renderCenteredText(matrixStack, healthText, -this.width / 2, 1, false, (r << 16) + (g << 8) + b);
    }

    @Override
    public void renderTooltip(@Nonnull MatrixStack matrixStack, int mouseX, int mouseY) {
        List<ITextComponent> tooltip = StatsScreen.createModifiableFloatAttributeTooltip(this.blockling.getStats().maxHealth, TextFormatting.DARK_GREEN);
        tooltip.add(0, (ITextComponent)new StringTextComponent(TextFormatting.GOLD + new Attribute.AttributeTranslationTextComponent("health.name", new Object[0]).getString()));
        this.screen.func_238654_b_(matrixStack, tooltip.stream().map(ITextComponent::func_241878_f).collect(Collectors.toList()), mouseX, mouseY);
    }
}

