/*
 * Decompiled with CFR 0.152.
 */
package com.willr27.blocklings.client.gui.controls.stats;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.willr27.blocklings.client.gui.Control;
import com.willr27.blocklings.client.gui.GuiTexture;
import com.willr27.blocklings.client.gui.GuiTextures;
import com.willr27.blocklings.client.gui.IControl;
import com.willr27.blocklings.client.gui.controls.stats.XpBarControl;
import com.willr27.blocklings.entity.blockling.BlocklingEntity;
import com.willr27.blocklings.entity.blockling.attribute.Attribute;
import com.willr27.blocklings.entity.blockling.attribute.BlocklingAttributes;
import com.willr27.blocklings.util.BlocklingsTranslationTextComponent;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import net.minecraft.util.IReorderingProcessor;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class LevelControl
extends Control {
    public static final int ICON_SIZE = 11;
    @Nonnull
    private final BlocklingAttributes.Level level;
    @Nonnull
    private final BlocklingEntity blockling;
    @Nonnull
    private final XpBarControl xpBar;

    public LevelControl(@Nonnull IControl parent, @Nonnull BlocklingAttributes.Level level, @Nonnull BlocklingEntity blockling, int x, int y) {
        super(parent, x, y, 144, 11);
        this.level = level;
        this.blockling = blockling;
        this.xpBar = new XpBarControl((IControl)this, level, blockling, 16, 3);
    }

    @Override
    public void render(@Nonnull MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        int level = this.blockling.getStats().getLevelAttribute(this.level).getValue();
        this.renderTexture(matrixStack, this.getTexture(level));
        this.renderTexture(matrixStack, this.width - this.getTexture((int)(level + 1)).width, 0, this.getTexture(level + 1));
    }

    @Override
    public void renderTooltip(@Nonnull MatrixStack matrixStack, int mouseX, int mouseY) {
        Attribute<Integer> level = this.blockling.getStats().getLevelAttribute(this.level);
        ArrayList<IReorderingProcessor> tooltip = new ArrayList<IReorderingProcessor>();
        tooltip.add(new StringTextComponent(TextFormatting.GOLD + this.blockling.getStats().getLevelAttribute((BlocklingAttributes.Level)this.level).displayStringNameSupplier.get()).func_241878_f());
        tooltip.add(new StringTextComponent(TextFormatting.GRAY + new BlocklingsTranslationTextComponent("gui.current_level", TextFormatting.WHITE, level.getValue()).getString()).func_241878_f());
        tooltip.add(new StringTextComponent(TextFormatting.GRAY + new BlocklingsTranslationTextComponent("gui.xp_required", TextFormatting.WHITE, this.blockling.getStats().getLevelXpAttribute(this.level).getValue(), BlocklingAttributes.getXpForLevel(level.getValue())).getString()).func_241878_f());
        this.screen.func_238654_b_(matrixStack, tooltip, mouseX, mouseY);
    }

    @Nonnull
    private GuiTexture getTexture(int level) {
        if (level >= 100) {
            return new GuiTexture(GuiTextures.STATS, 11 * this.level.ordinal(), 166, 11, 11);
        }
        return new GuiTexture(GuiTextures.STATS, level / 20 * 44 + this.level.ordinal() * 11, 177, 11, 11);
    }
}

