/*
 * Decompiled with CFR 0.152.
 */
package com.willr27.blocklings.client.gui.controls.stats;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.willr27.blocklings.client.gui.Control;
import com.willr27.blocklings.client.gui.GuiTexture;
import com.willr27.blocklings.client.gui.GuiTextures;
import com.willr27.blocklings.client.gui.IControl;
import com.willr27.blocklings.entity.blockling.BlocklingEntity;
import com.willr27.blocklings.entity.blockling.attribute.BlocklingAttributes;
import javax.annotation.Nonnull;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class XpBarControl
extends Control {
    public static final int WIDTH = 111;
    public static final int HEIGHT = 5;
    @Nonnull
    private final BlocklingAttributes.Level level;
    @Nonnull
    private final BlocklingEntity blockling;
    @Nonnull
    private final GuiTexture backgroundTexture;

    public XpBarControl(@Nonnull IControl parent, @Nonnull BlocklingAttributes.Level level, @Nonnull BlocklingEntity blockling, int x, int y) {
        super(parent, x, y, 111, 5);
        this.level = level;
        this.blockling = blockling;
        this.backgroundTexture = new GuiTexture(GuiTextures.STATS, 0, 193 + level.ordinal() * this.height * 2, this.width, this.height);
    }

    @Override
    public void render(@Nonnull MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        float percentage = Math.min(1.0f, (float)this.blockling.getStats().getLevelXpAttribute(this.level).getValue().intValue() / (float)BlocklingAttributes.getXpForLevel(this.blockling.getStats().getLevelAttribute(this.level).getValue()));
        int middle = (int)((float)this.width * percentage);
        this.renderTexture(matrixStack, this.backgroundTexture);
        this.renderTexture(matrixStack, 0, 0, new GuiTexture(GuiTextures.STATS, 0, 188 + this.level.ordinal() * this.height * 2, middle, this.height));
        this.renderCenteredText(matrixStack, "" + this.blockling.getStats().getLevelAttribute(this.level).getValue(), -this.width / 2 + 1, -1, false, this.getTextColour());
    }

    @Override
    public void renderTooltip(@Nonnull MatrixStack matrixStack, int mouseX, int mouseY) {
        this.parent.renderTooltip(matrixStack, mouseX, mouseY);
    }

    private int getTextColour() {
        switch (this.level) {
            case COMBAT: {
                return 14693428;
            }
            case MINING: {
                return 4747476;
            }
            case WOODCUTTING: {
                return 5093437;
            }
            case FARMING: {
                return 15585060;
            }
        }
        return 0xFFFFFF;
    }
}

