/*
 * Decompiled with CFR 0.152.
 */
package com.willr27.blocklings.client.gui.controls.tasks;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.willr27.blocklings.client.gui.Control;
import com.willr27.blocklings.client.gui.GuiTexture;
import com.willr27.blocklings.client.gui.GuiTextures;
import com.willr27.blocklings.client.gui.IControl;
import com.willr27.blocklings.client.gui.controls.tasks.TaskControl;
import com.willr27.blocklings.entity.blockling.task.BlocklingTasks;
import com.willr27.blocklings.util.BlocklingsTranslationTextComponent;
import javax.annotation.Nonnull;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class TaskAddRemoveControl
extends Control {
    public static final int TASK_ADD_REMOVE_WIDTH = 20;
    public static final int TASK_ADD_REMOVE_HEIGHT = 20;
    @Nonnull
    private static final GuiTexture ADD_TEXTURE = new GuiTexture(GuiTextures.TASKS, 136, 166, 20, 20);
    @Nonnull
    private static final GuiTexture REMOVE_TEXTURE = new GuiTexture(GuiTextures.TASKS, 156, 166, 20, 20);
    @Nonnull
    public final TaskControl taskControl;
    public final boolean isAddControl;

    public TaskAddRemoveControl(@Nonnull TaskControl parentTaskControl, boolean isAddControl) {
        super(parentTaskControl, parentTaskControl.width - 20, 0, 20, 20);
        this.taskControl = parentTaskControl;
        this.isAddControl = isAddControl;
    }

    @Override
    public void render(@Nonnull MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        if (this.isAddControl) {
            this.renderTexture(matrixStack, ADD_TEXTURE);
        } else {
            this.renderTexture(matrixStack, REMOVE_TEXTURE);
        }
    }

    @Override
    public void renderTooltip(@Nonnull MatrixStack matrixStack, int mouseX, int mouseY) {
        if (this.isAddControl) {
            this.screen.func_238652_a_(matrixStack, (ITextComponent)new BlocklingsTranslationTextComponent("task.ui.add"), mouseX, mouseY);
        } else {
            this.screen.func_238652_a_(matrixStack, (ITextComponent)new BlocklingsTranslationTextComponent("task.ui.remove"), mouseX, mouseY);
        }
    }

    @Override
    public void controlMouseReleased(@Nonnull IControl.MouseButtonEvent e) {
        if (this.isPressed()) {
            if (this.isAddControl) {
                this.taskControl.task.blockling.getTasks().createTask(BlocklingTasks.NULL);
            } else {
                this.taskControl.remove();
                this.taskControl.task.blockling.getTasks().removeTask(this.taskControl.task);
            }
        }
        e.setIsHandled(true);
    }
}

