/*
 * Decompiled with CFR 0.152.
 */
package com.willr27.blocklings.client.gui.controls.tasks;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.willr27.blocklings.client.gui.Control;
import com.willr27.blocklings.client.gui.GuiTexture;
import com.willr27.blocklings.client.gui.GuiTextures;
import com.willr27.blocklings.client.gui.GuiUtil;
import com.willr27.blocklings.client.gui.IControl;
import com.willr27.blocklings.client.gui.controls.TexturedControl;
import com.willr27.blocklings.client.gui.controls.tasks.TaskAddRemoveControl;
import com.willr27.blocklings.client.gui.controls.tasks.TaskIconControl;
import com.willr27.blocklings.client.gui.controls.tasks.TaskStateControl;
import com.willr27.blocklings.entity.blockling.task.Task;
import java.util.ArrayList;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.util.IReorderingProcessor;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class TaskControl
extends Control {
    public static final int WIDTH = 136;
    public static final int HEIGHT = 20;
    @Nonnull
    public final Task task;
    public final boolean isAddControl;
    @Nonnull
    private final TexturedControl nameControl;
    @Nonnull
    private final TaskIconControl iconControl;
    @Nonnull
    private final TaskStateControl stateControl;
    @Nonnull
    private final TaskAddRemoveControl addRemoveControl;

    public TaskControl(@Nonnull IControl parent, final @Nonnull Task task, boolean isAddControl, @Nonnull Consumer<Task> onConfigure) {
        super(parent, 0, 0, 136, 20);
        this.task = task;
        this.isAddControl = isAddControl;
        this.setMargins(4, 4, 4, isAddControl ? 4 : 0);
        this.nameControl = new TexturedControl(this, this.getX() + 20, this.getY(), new GuiTexture(GuiTextures.TASKS, 40, 166, 96, 20)){

            @Override
            public void render(@Nonnull MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
                super.render(matrixStack, mouseX, mouseY, partialTicks);
                this.renderShadowedText(matrixStack, GuiUtil.trimWithEllipses(this.font, task.getCustomName(), this.width - 24), 4, 6, false, 0xFFFFFF);
            }

            @Override
            public void renderTooltip(@Nonnull MatrixStack matrixStack, int mouseX, int mouseY) {
                this.parent.renderTooltip(matrixStack, mouseX, mouseY);
            }

            @Override
            public void controlMouseClicked(@Nonnull IControl.MouseButtonEvent e) {
                e.setIsHandled(false);
            }
        };
        this.iconControl = new TaskIconControl(this, isAddControl, onConfigure);
        this.stateControl = new TaskStateControl(this);
        this.addRemoveControl = new TaskAddRemoveControl(this, isAddControl);
    }

    @Override
    public void render(@Nonnull MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        if (this.isDragging()) {
            matrixStack.func_227861_a_(0.0, 0.0, 10.0);
        }
    }

    @Override
    public void renderTooltip(@Nonnull MatrixStack matrixStack, int mouseX, int mouseY) {
        if (!this.isAddControl) {
            ArrayList<IReorderingProcessor> text = new ArrayList<IReorderingProcessor>();
            text.add(new StringTextComponent(TextFormatting.GOLD + this.task.getCustomName()).func_241878_f());
            text.add(new StringTextComponent("").func_241878_f());
            text.addAll(GuiUtil.splitText(this.font, this.task.getType().desc.getString(), 150).stream().map(s -> new StringTextComponent(s).func_241878_f()).collect(Collectors.toList()));
            this.screen.func_238654_b_(matrixStack, text, mouseX, mouseY);
        }
    }
}

