/*
 * Decompiled with CFR 0.152.
 */
package com.willr27.blocklings.client.gui.controls.tasks;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.willr27.blocklings.client.gui.Control;
import com.willr27.blocklings.client.gui.GuiTexture;
import com.willr27.blocklings.client.gui.GuiTextures;
import com.willr27.blocklings.client.gui.IControl;
import com.willr27.blocklings.client.gui.controls.tasks.TaskControl;
import com.willr27.blocklings.entity.blockling.task.BlocklingTasks;
import com.willr27.blocklings.entity.blockling.task.Task;
import com.willr27.blocklings.util.BlocklingsTranslationTextComponent;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class TaskIconControl
extends Control {
    public static final int TASK_ICON_WIDTH = BlocklingTasks.NULL.texture.width;
    public static final int TASK_ICON_HEIGHT = BlocklingTasks.NULL.texture.height;
    @Nonnull
    public static final GuiTexture BACKGROUND_TEXTURE = new GuiTexture(GuiTextures.TASKS, 0, 166, TASK_ICON_WIDTH, TASK_ICON_HEIGHT);
    @Nonnull
    public static final GuiTexture BACKGROUND_PRESSED_TEXTURE = new GuiTexture(GuiTextures.TASKS, 20, 166, TASK_ICON_WIDTH, TASK_ICON_HEIGHT);
    @Nonnull
    public static final GuiTexture CONFIGURE_TEXTURE = BlocklingTasks.NULL.texture;
    @Nonnull
    public final TaskControl taskControl;
    public final boolean isCreateControl;
    @Nonnull
    public final Consumer<Task> onConfigure;

    public TaskIconControl(@Nonnull TaskControl parentTaskControl, boolean isAddControl, @Nonnull Consumer<Task> onConfigure) {
        super(parentTaskControl, 0, 0, TASK_ICON_WIDTH, TASK_ICON_HEIGHT);
        this.taskControl = parentTaskControl;
        this.isCreateControl = isAddControl;
        this.onConfigure = onConfigure;
    }

    @Override
    public void render(@Nonnull MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        if (this.isPressed() || this.isCreateControl) {
            RenderSystem.color3f((float)0.8f, (float)0.8f, (float)0.8f);
            this.renderTexture(matrixStack, BACKGROUND_PRESSED_TEXTURE);
        } else {
            this.renderTexture(matrixStack, BACKGROUND_TEXTURE);
        }
        if (this.isPressed() || this.isMouseOver(mouseX, mouseY)) {
            this.renderTexture(matrixStack, CONFIGURE_TEXTURE);
        } else {
            this.renderTexture(matrixStack, this.taskControl.task.getType().texture);
        }
        RenderSystem.color3f((float)1.0f, (float)1.0f, (float)1.0f);
    }

    @Override
    public void renderTooltip(@Nonnull MatrixStack matrixStack, int mouseX, int mouseY) {
        if (!this.taskControl.isAddControl) {
            this.screen.func_238652_a_(matrixStack, (ITextComponent)new BlocklingsTranslationTextComponent("task.ui.configure"), mouseX, mouseY);
        }
    }

    @Override
    public void controlMouseReleased(@Nonnull IControl.MouseButtonEvent e) {
        if (!this.taskControl.isAddControl) {
            this.onConfigure.accept(this.taskControl.task);
            e.setIsHandled(true);
        }
    }
}

