/*
 * Decompiled with CFR 0.152.
 */
package com.willr27.blocklings.client.gui.controls.tasks;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.willr27.blocklings.client.gui.Control;
import com.willr27.blocklings.client.gui.GuiTexture;
import com.willr27.blocklings.client.gui.GuiTextures;
import com.willr27.blocklings.client.gui.IControl;
import com.willr27.blocklings.client.gui.controls.tasks.TaskControl;
import com.willr27.blocklings.entity.blockling.goal.BlocklingGoal;
import com.willr27.blocklings.util.BlocklingsTranslationTextComponent;
import javax.annotation.Nonnull;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class TaskStateControl
extends Control {
    public static final int TASK_STATE_WIDTH = 20;
    public static final int TASK_STATE_HEIGHT = 20;
    @Nonnull
    private static final GuiTexture STATE_TEXTURE = new GuiTexture(GuiTextures.TASKS, 196, 166, 20, 20);
    @Nonnull
    private static final GuiTexture STATE_PRESSED_TEXTURE = new GuiTexture(GuiTextures.TASKS, 216, 166, 20, 20);
    @Nonnull
    public final TaskControl taskControl;

    public TaskStateControl(@Nonnull TaskControl parentTaskControl) {
        super(parentTaskControl, parentTaskControl.width - 42, 0, 20, 20);
        this.taskControl = parentTaskControl;
    }

    @Override
    public void render(@Nonnull MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        if (this.taskControl.task.isConfigured()) {
            if (this.taskControl.task.getGoal().getState() == BlocklingGoal.State.DISABLED) {
                RenderSystem.color3f((float)1.0f, (float)0.0f, (float)0.0f);
            } else if (this.taskControl.task.getGoal().getState() == BlocklingGoal.State.IDLE) {
                RenderSystem.color3f((float)1.0f, (float)0.8f, (float)0.0f);
            }
            if (this.taskControl.task.getGoal().getState() == BlocklingGoal.State.ACTIVE) {
                RenderSystem.color3f((float)0.0f, (float)0.7f, (float)0.0f);
            }
        } else {
            RenderSystem.color3f((float)0.6f, (float)0.6f, (float)0.6f);
        }
        if (this.taskControl.task.isConfigured() && this.taskControl.task.getGoal().getState() == BlocklingGoal.State.DISABLED) {
            this.renderTexture(matrixStack, STATE_PRESSED_TEXTURE);
        } else {
            this.renderTexture(matrixStack, STATE_TEXTURE);
        }
        RenderSystem.color3f((float)1.0f, (float)1.0f, (float)1.0f);
    }

    @Override
    public void renderTooltip(@Nonnull MatrixStack matrixStack, int mouseX, int mouseY) {
        if (this.taskControl.task.isConfigured()) {
            if (this.taskControl.task.getGoal().getState() == BlocklingGoal.State.DISABLED) {
                this.screen.func_238652_a_(matrixStack, (ITextComponent)new BlocklingsTranslationTextComponent("task.ui.enable"), mouseX, mouseY);
            } else {
                this.screen.func_238652_a_(matrixStack, (ITextComponent)new BlocklingsTranslationTextComponent("task.ui.disable"), mouseX, mouseY);
            }
        }
    }

    @Override
    public void controlMouseReleased(@Nonnull IControl.MouseButtonEvent e) {
        if (this.isPressed() && this.taskControl.task.isConfigured()) {
            if (this.taskControl.task.getGoal().getState() == BlocklingGoal.State.DISABLED) {
                this.taskControl.task.getGoal().setState(BlocklingGoal.State.IDLE);
            } else {
                this.taskControl.task.getGoal().setState(BlocklingGoal.State.DISABLED);
            }
        }
        e.setIsHandled(true);
    }
}

