/*
 * Decompiled with CFR 0.152.
 */
package com.willr27.blocklings.client.gui.controls.tasks.config;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.willr27.blocklings.Blocklings;
import com.willr27.blocklings.client.gui.Control;
import com.willr27.blocklings.client.gui.GuiTexture;
import com.willr27.blocklings.client.gui.GuiTextures;
import com.willr27.blocklings.client.gui.GuiUtil;
import com.willr27.blocklings.client.gui.IControl;
import com.willr27.blocklings.entity.blockling.whitelist.GoalWhitelist;
import com.willr27.blocklings.entity.blockling.whitelist.Whitelist;
import com.willr27.blocklings.util.EntityUtil;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class EntryControl
extends Control {
    @Nonnull
    public static final GuiTexture ENTRY_UNSELECTED = new GuiTexture(GuiTextures.WHITELIST, 0, 166, 30, 30);
    @Nonnull
    public static final GuiTexture ENTRY_SELECTED = ENTRY_UNSELECTED.shift(30, 0);
    @Nonnull
    private final GoalWhitelist whitelist;
    @Nonnull
    private final Map.Entry<ResourceLocation, Boolean> entry;

    public EntryControl(@Nonnull IControl parent, @Nonnull GoalWhitelist whitelist, @Nonnull Map.Entry<ResourceLocation, Boolean> entry, int x, int y) {
        super(parent, x, y, EntryControl.ENTRY_UNSELECTED.width, EntryControl.ENTRY_UNSELECTED.height);
        this.whitelist = whitelist;
        this.entry = entry;
    }

    @Override
    public void render(@Nonnull MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        RenderSystem.enableDepthTest();
        GuiUtil.addScissorBounds(this.screenX, this.screenY, this.getScreenWidth(), this.getScreenHeight());
        GuiUtil.enableStackedScissor();
        if (this.entry.getValue().booleanValue()) {
            RenderSystem.color3f((float)0.4f, (float)0.8f, (float)0.4f);
            this.renderTexture(matrixStack, ENTRY_SELECTED);
        } else {
            RenderSystem.color3f((float)0.8f, (float)0.3f, (float)0.3f);
            this.renderTexture(matrixStack, ENTRY_UNSELECTED);
        }
        if (this.entry.getValue().booleanValue()) {
            RenderSystem.color3f((float)1.0f, (float)1.0f, (float)1.0f);
        } else {
            RenderSystem.color3f((float)0.5f, (float)0.5f, (float)0.5f);
        }
        GuiUtil.addScissorBounds((int)((float)this.screenX + 2.0f * this.getEffectiveScale()), (int)((float)this.screenY + 2.0f * this.getEffectiveScale()), (int)((float)this.getScreenWidth() - 4.0f * this.getEffectiveScale()), (int)((float)this.getScreenHeight() - 4.0f * this.getEffectiveScale()));
        GuiUtil.enableStackedScissor();
        if (this.whitelist.type == Whitelist.Type.BLOCK) {
            Block block = (Block)Registry.field_212618_g.func_82594_a(this.entry.getKey());
            ItemStack stack = new ItemStack((IItemProvider)block);
            GuiUtil.renderItemStack(matrixStack, stack, (int)((float)this.screenX / this.getEffectiveScale()), (int)((float)this.screenY / this.getEffectiveScale()), 10);
        } else if (this.whitelist.type == Whitelist.Type.ITEM) {
            Item item = (Item)Registry.field_212630_s.func_82594_a(this.entry.getKey());
            ItemStack stack = new ItemStack((IItemProvider)item);
            GuiUtil.renderItemStack(matrixStack, stack, (int)((float)this.screenX / this.getEffectiveScale()), (int)((float)this.screenY / this.getEffectiveScale()), 10);
        } else if (this.whitelist.type == Whitelist.Type.ENTITY) {
            LivingEntity entity = (LivingEntity)((Map)EntityUtil.VALID_ATTACK_TARGETS.get()).get(this.entry.getKey());
            try {
                GuiUtil.renderEntityOnScreen(matrixStack, this.screenX + this.width / 2, this.screenY + this.width / 2 + 11, 20, 25.0f, -10.0f, entity);
            }
            catch (Exception ex) {
                Blocklings.LOGGER.warn("Failed to render entity on screen: " + entity.func_200600_R().getRegistryName());
            }
        }
        GuiUtil.removeScissorBounds((int)((float)this.screenX + 2.0f * this.getEffectiveScale()), (int)((float)this.screenY + 2.0f * this.getEffectiveScale()), (int)((float)this.getScreenWidth() - 4.0f * this.getEffectiveScale()), (int)((float)this.getScreenHeight() - 4.0f * this.getEffectiveScale()));
        GuiUtil.removeScissorBounds(this.screenX, this.screenY, this.getScreenWidth(), this.getScreenHeight());
    }

    @Override
    public void renderTooltip(@Nonnull MatrixStack matrixStack, int mouseX, int mouseY) {
        if (this.whitelist.type == Whitelist.Type.BLOCK) {
            Block block = (Block)Registry.field_212618_g.func_82594_a(this.entry.getKey());
            this.screen.func_238652_a_(matrixStack, (ITextComponent)block.func_235333_g_(), mouseX, mouseY);
        } else if (this.whitelist.type == Whitelist.Type.ITEM) {
            Item item = (Item)Registry.field_212630_s.func_82594_a(this.entry.getKey());
            this.screen.func_238652_a_(matrixStack, item.func_200295_i(item.func_190903_i()), mouseX, mouseY);
        } else if (this.whitelist.type == Whitelist.Type.ENTITY) {
            Entity ent = EntityUtil.create(this.entry.getKey(), this.whitelist.blockling.field_70170_p);
            this.screen.func_238652_a_(matrixStack, ent.func_200200_C_(), mouseX, mouseY);
        }
    }

    @Override
    public void controlMouseReleased(@Nonnull IControl.MouseButtonEvent e) {
        if (this.isPressed()) {
            this.whitelist.toggleEntry(this.entry.getKey());
        }
        e.setIsHandled(true);
    }
}

