/*
 * Decompiled with CFR 0.152.
 */
package com.willr27.blocklings.client.gui.controls.tasks.config;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.willr27.blocklings.client.gui.Control;
import com.willr27.blocklings.client.gui.GuiTexture;
import com.willr27.blocklings.client.gui.GuiTextures;
import com.willr27.blocklings.client.gui.GuiUtil;
import com.willr27.blocklings.client.gui.IControl;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class TabControl
extends Control {
    public static final int SELECTED_HEIGHT = 18;
    public static final int UNSELECTED_HEIGHT = 15;
    public static final int OVERLAP = 1;
    @Nonnull
    public static final GuiTexture SELECTED_LEFT = new GuiTexture(GuiTextures.COMMON_WIDGETS, 0, 15, 4, 18);
    @Nonnull
    public static final GuiTexture SELECTED_RIGHT = new GuiTexture(GuiTextures.COMMON_WIDGETS, 252, 15, 4, 18);
    @Nonnull
    public static final GuiTexture UNSELECTED_LEFT = new GuiTexture(GuiTextures.COMMON_WIDGETS, 0, 33, 4, 15);
    @Nonnull
    public static final GuiTexture UNSELECTED_RIGHT = new GuiTexture(GuiTextures.COMMON_WIDGETS, 252, 33, 4, 15);
    private int selectedTabIndex = 0;
    @Nonnull
    private final List<Tab> tabs = new ArrayList<Tab>();

    public TabControl(@Nonnull IControl parent, int x, int y, int width) {
        super(parent, x, y, width, 15);
    }

    public void add(@Nonnull String name, @Nonnull Runnable onSelect) {
        this.tabs.add(new Tab(name, onSelect));
    }

    @Override
    public void render(@Nonnull MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        RenderSystem.disableDepthTest();
        RenderSystem.color3f((float)1.0f, (float)1.0f, (float)1.0f);
        if (this.tabs.isEmpty()) {
            return;
        }
        int edgePadding = 2;
        int baseTabWidth = (this.width + edgePadding * 2) / this.tabs.size() + 1;
        int numberOfTabsWithExtraWidth = (this.width + edgePadding * 2) % this.tabs.size();
        for (int i = 0; i < this.tabs.size(); ++i) {
            Tab tab = this.tabs.get(i);
            tab.x = i != 0 ? this.tabs.get((int)(i - 1)).x + this.tabs.get((int)(i - 1)).width - 1 : this.screenX - edgePadding;
            int n = tab.width = i < numberOfTabsWithExtraWidth ? baseTabWidth + 1 : baseTabWidth;
            if (i == this.selectedTabIndex) continue;
            GuiTexture unselectedLeft = new GuiTexture(GuiTextures.COMMON_WIDGETS, TabControl.UNSELECTED_LEFT.x, TabControl.UNSELECTED_LEFT.y, tab.width - TabControl.UNSELECTED_RIGHT.width, 15);
            unselectedLeft = i == 0 ? unselectedLeft.shift(4, 0).resize(-edgePadding, 0) : unselectedLeft;
            this.renderTexture(matrixStack, unselectedLeft, tab.x + (i == 0 ? edgePadding : 0), this.screenY);
            GuiTexture unselectedRight = i == this.tabs.size() - 1 ? UNSELECTED_RIGHT.shift(-4, 0).resize(-edgePadding - 1, 0) : UNSELECTED_RIGHT;
            this.renderTexture(matrixStack, unselectedRight, tab.x + tab.width - unselectedRight.width - (i == this.tabs.size() - 1 ? edgePadding + 1 : 0), this.screenY);
            String name = GuiUtil.trimWithEllipses(this.font, tab.name, tab.width - 10);
            this.font.func_238421_b_(matrixStack, name, (float)(tab.x + tab.width / 2 - this.font.func_78256_a(name) / 2 + 1), (float)(this.screenY + 2), 0x666666);
        }
        Tab tab = this.tabs.get(this.selectedTabIndex);
        GuiTexture selectedLeft = new GuiTexture(GuiTextures.COMMON_WIDGETS, TabControl.SELECTED_LEFT.x, TabControl.SELECTED_LEFT.y, tab.width - TabControl.SELECTED_RIGHT.width, 18);
        selectedLeft = this.selectedTabIndex == 0 ? selectedLeft.shift(4, 0).resize(-edgePadding + 1, 0) : selectedLeft;
        this.renderTexture(matrixStack, selectedLeft, this.selectedTabIndex == 0 ? tab.x + edgePadding - 1 : tab.x, this.screenY - 1);
        GuiTexture selectedRight = this.selectedTabIndex == this.tabs.size() - 1 ? SELECTED_RIGHT.shift(-5, 0).resize(-edgePadding, 0) : SELECTED_RIGHT;
        this.renderTexture(matrixStack, selectedRight, tab.x + tab.width - selectedRight.width - (this.selectedTabIndex == this.tabs.size() - 1 ? edgePadding : 0), this.screenY - 1);
        String name = GuiUtil.trimWithEllipses(this.font, tab.name, tab.width - 10);
        this.renderCenteredText(matrixStack, name, tab.x - this.screenX - this.width + tab.width / 2 + 1, 2, false, 0xFFFFFF);
    }

    @Override
    public void renderTooltip(@Nonnull MatrixStack matrixStack, int mouseX, int mouseY) {
        Tab hoveredTab = this.getHoveredTab((int)((float)mouseX * this.getEffectiveScale()), (int)((float)mouseY * this.getEffectiveScale()));
        if (hoveredTab != null) {
            this.screen.func_238652_a_(matrixStack, (ITextComponent)new StringTextComponent(hoveredTab.name), mouseX, mouseY);
        }
    }

    @Override
    public void controlMouseReleased(@Nonnull IControl.MouseButtonEvent e) {
        Tab clickedTab;
        if (this.isPressed() && (clickedTab = this.getHoveredTab(e.mouseX, e.mouseY)) != null) {
            this.selectedTabIndex = this.tabs.indexOf(clickedTab);
            clickedTab.onSelect.run();
        }
        e.setIsHandled(true);
    }

    @Nullable
    private Tab getHoveredTab(int mouseX, int mouseY) {
        return this.tabs.stream().filter(tab -> GuiUtil.isMouseOver(mouseX, mouseY, (int)((float)(tab.x - this.screenX + 2) * this.getEffectiveScale()) + this.screenX - 2, this.screenY, (int)((float)tab.width * this.getEffectiveScale()), (int)(15.0f * this.getEffectiveScale()))).findFirst().orElse(null);
    }

    private static class Tab {
        @Nonnull
        public final String name;
        @Nonnull
        public final Runnable onSelect;
        public int x = 0;
        public int width = 30;

        public Tab(@Nonnull String name, @Nonnull Runnable onSelect) {
            this.name = name;
            this.onSelect = onSelect;
        }
    }
}

