/*
 * Decompiled with CFR 0.152.
 */
package com.willr27.blocklings.client.gui.controls.tasks.config;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.willr27.blocklings.client.gui.Control;
import com.willr27.blocklings.client.gui.GuiTextures;
import com.willr27.blocklings.client.gui.GuiUtil;
import com.willr27.blocklings.client.gui.IControl;
import com.willr27.blocklings.client.gui.controls.common.ScrollbarControl;
import com.willr27.blocklings.client.gui.controls.common.TextFieldControl;
import com.willr27.blocklings.client.gui.controls.tasks.config.ConfigControl;
import com.willr27.blocklings.client.gui.controls.tasks.config.TabControl;
import com.willr27.blocklings.client.gui.controls.tasks.config.configs.TaskMiscConfigControl;
import com.willr27.blocklings.client.gui.controls.tasks.config.configs.WhitelistConfigControl;
import com.willr27.blocklings.client.gui.screens.TasksScreen;
import com.willr27.blocklings.entity.blockling.task.Task;
import com.willr27.blocklings.entity.blockling.whitelist.GoalWhitelist;
import com.willr27.blocklings.util.BlocklingsTranslationTextComponent;
import javax.annotation.Nonnull;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class TaskConfigContainerControl
extends Control {
    @Nonnull
    public final Task task;
    @Nonnull
    private final Control contentControl;
    @Nonnull
    private final ScrollbarControl contentScrollbarControl;
    private TabControl tabControl;
    private ConfigControl currentConfigGui;
    @Nonnull
    public TextFieldControl nameTextFieldControl;

    public TaskConfigContainerControl(@Nonnull IControl parent, final @Nonnull Task task, int x, int y) {
        super(parent, x, y, 176, 166);
        this.task = task;
        this.contentControl = new Control(this, 9, 43, 140, 115);
        this.contentScrollbarControl = new ScrollbarControl(this, 155, 33, 12, 125);
        IControl screen = (IControl)((Object)this.getScreen());
        float scale = screen.getScale();
        this.nameTextFieldControl = new TextFieldControl(this.font, (int)((float)this.screenX / scale + 15.0f), (int)((float)this.screenY / scale + 14.0f), 158, 13, (ITextComponent)new StringTextComponent("")){
            private String startingString;
            {
                super(p_i232260_1_, p_i232260_2_, p_i232260_3_, p_i232260_4_, p_i232260_5_, p_i232260_6_);
                this.startingString = "";
            }

            @Override
            public void setFocus(boolean focus) {
                if (!focus && !this.startingString.equals(this.getValue())) {
                    task.setCustomName(this.getValue());
                } else {
                    this.startingString = this.getValue();
                }
                super.setFocus(focus);
            }
        };
        this.nameTextFieldControl.setBordered(false);
        this.nameTextFieldControl.setMaxLength(25);
        this.nameTextFieldControl.setVisible(true);
        this.nameTextFieldControl.setTextColor(0xFFFFFF);
        this.nameTextFieldControl.setValue(task.getCustomName());
        this.recreateTabs();
    }

    public void recreateTabs() {
        this.removeChild(this.currentConfigGui);
        this.currentConfigGui = new TaskMiscConfigControl(this, this.task, 9, 46, 140, 112, this.contentScrollbarControl);
        this.currentConfigGui.setIsFocused(true);
        this.removeChild(this.tabControl);
        this.tabControl = new TabControl(this, 9, 33, 140);
        this.tabControl.add(new BlocklingsTranslationTextComponent("task.ui.tab.misc").getString(), () -> {
            this.removeChild(this.currentConfigGui);
            this.currentConfigGui = new TaskMiscConfigControl(this, this.task, 9, 46, 140, 112, this.contentScrollbarControl);
            this.currentConfigGui.setZIndex(2);
            this.currentConfigGui.setIsFocused(true);
        });
        if (this.task.isConfigured() && !this.task.getGoal().whitelists.isEmpty()) {
            for (GoalWhitelist whitelist : this.task.getGoal().whitelists) {
                if (!whitelist.isUnlocked()) continue;
                this.tabControl.add(whitelist.name.getString(), () -> {
                    this.removeChild(this.currentConfigGui);
                    this.currentConfigGui = new WhitelistConfigControl(this, whitelist, 9, 46, 140, 112, this.contentScrollbarControl);
                    this.currentConfigGui.setZIndex(2);
                    this.currentConfigGui.setIsFocused(true);
                });
            }
        }
    }

    @Override
    public void tick() {
        this.nameTextFieldControl.tick();
    }

    @Override
    public void render(@Nonnull MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        GuiUtil.bindTexture(GuiTextures.TASK_CONFIGURE);
        this.func_238474_b_(matrixStack, this.screenX, this.screenY, 0, 0, 176, 166);
        if (!this.nameTextFieldControl.func_230999_j_()) {
            this.nameTextFieldControl.setValue(this.task.getCustomName());
        }
        this.nameTextFieldControl.func_230430_a_(new MatrixStack(), mouseX, mouseY, partialTicks);
        RenderSystem.color3f((float)1.0f, (float)1.0f, (float)1.0f);
    }

    @Override
    public void globalMouseClicked(@Nonnull IControl.MouseButtonEvent e) {
        this.nameTextFieldControl.func_231044_a_((float)e.mouseX / this.getEffectiveScale(), (float)e.mouseY / this.getEffectiveScale(), e.button);
    }

    @Override
    public void globalMouseReleased(@Nonnull IControl.MouseButtonEvent e) {
        this.nameTextFieldControl.func_231048_c_((float)e.mouseX / this.getEffectiveScale(), (float)e.mouseY / this.getEffectiveScale(), e.button);
    }

    @Override
    public void controlMouseScrolled(@Nonnull IControl.MouseScrollEvent e) {
        e.setIsHandled(this.contentScrollbarControl.scroll(e.scroll));
    }

    @Override
    public void controlKeyPressed(@Nonnull IControl.KeyEvent e) {
        if (e.isHandled()) {
            return;
        }
        if (!this.nameTextFieldControl.func_230999_j_() && GuiUtil.isCloseInventoryKey(e.keyCode)) {
            this.setIsVisible(false);
            TasksScreen tasksScreen = (TasksScreen)this.screen;
            tasksScreen.setIsVisible(true);
            e.setIsHandled(true);
        } else if (e.keyCode == 257 || e.keyCode == 256) {
            if (this.nameTextFieldControl.func_230999_j_()) {
                this.nameTextFieldControl.setFocus(false);
                e.setIsHandled(true);
            }
        } else {
            e.setIsHandled(this.nameTextFieldControl.func_231046_a_(e.keyCode, e.scanCode, e.modifiers));
        }
    }

    @Override
    public void controlCharTyped(@Nonnull IControl.CharEvent e) {
        e.setIsHandled(this.nameTextFieldControl.func_231042_a_(e.character, e.keyCode));
        if (!e.isHandled() && GuiUtil.isCloseInventoryKey(e.keyCode)) {
            this.setIsVisible(false);
            e.setIsHandled(true);
        }
    }
}

