/*
 * Decompiled with CFR 0.152.
 */
package com.willr27.blocklings.client.gui.controls.tasks.config.configs;

import com.willr27.blocklings.client.gui.GuiUtil;
import com.willr27.blocklings.client.gui.IControl;
import com.willr27.blocklings.client.gui.controls.common.DropdownControl;
import com.willr27.blocklings.client.gui.controls.common.LabelControl;
import com.willr27.blocklings.client.gui.controls.common.ScrollbarControl;
import com.willr27.blocklings.client.gui.controls.common.panel.StackPanel;
import com.willr27.blocklings.client.gui.controls.tasks.config.ConfigControl;
import com.willr27.blocklings.client.gui.controls.tasks.config.TaskConfigContainerControl;
import com.willr27.blocklings.entity.blockling.goal.BlocklingGoal;
import com.willr27.blocklings.entity.blockling.task.BlocklingTasks;
import com.willr27.blocklings.entity.blockling.task.Task;
import com.willr27.blocklings.entity.blockling.task.TaskType;
import com.willr27.blocklings.entity.blockling.task.config.Property;
import com.willr27.blocklings.util.BlocklingsTranslationTextComponent;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.util.IReorderingProcessor;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class TaskMiscConfigControl
extends ConfigControl {
    @Nonnull
    private final ScrollbarControl contentScrollbarControl;
    @Nonnull
    private final TaskConfigContainerControl taskConfigControl;
    @Nonnull
    private final DropdownControl taskTypeDropdownControl;

    public TaskMiscConfigControl(@Nonnull TaskConfigContainerControl parentTaskConfigContainerControl, @Nonnull Task task, int x, int y, int width, int height, @Nonnull ScrollbarControl contentScrollbarControl) {
        super(parentTaskConfigContainerControl, x, y, width, height);
        this.contentScrollbarControl = contentScrollbarControl;
        this.taskConfigControl = parentTaskConfigContainerControl;
        List unlockedTaskTypes = BlocklingTasks.TASK_TYPES.stream().filter(taskType -> task.blockling.getTasks().isUnlocked((TaskType)taskType)).collect(Collectors.toList());
        StackPanel stackPanel = new StackPanel(this, 0, 0, width, height);
        stackPanel.setPadding(4, 9, 4, 4);
        stackPanel.setScrollbarY(contentScrollbarControl);
        LabelControl taskTypeLabelControl = new LabelControl(stackPanel, width - stackPanel.getPadding(IControl.Side.LEFT) - stackPanel.getPadding(IControl.Side.RIGHT), new BlocklingsTranslationTextComponent("task.ui.task_type").getString());
        taskTypeLabelControl.setMargins(0, 0, 0, 3);
        this.taskTypeDropdownControl = new DropdownControl(stackPanel, 0, 0, width - 8);
        this.taskTypeDropdownControl.setMargins(0, 0, 0, 0);
        this.taskTypeDropdownControl.addItems(unlockedTaskTypes.stream().map(taskType -> new DropdownControl.Item(taskType, taskType.texture, this.createTooltip((TaskType)taskType))).collect(Collectors.toList()));
        this.taskTypeDropdownControl.setSelectedItem(new DropdownControl.Item(task.getType(), task.getType().texture, this.createTooltip(task.getType())));
        this.taskTypeDropdownControl.onDropDownSelectionChanged.subscribe(e -> {
            TaskType newTaskType;
            if (e.newSelection != null && (newTaskType = (TaskType)e.newSelection.item) != task.getType()) {
                task.setType(newTaskType);
                this.taskConfigControl.recreateTabs();
            }
        });
        if (task.isConfigured()) {
            BlocklingGoal goal = task.getGoal();
            for (Property property : goal.properties) {
                new LabelControl(stackPanel, width - stackPanel.getPadding(IControl.Side.LEFT) - stackPanel.getPadding(IControl.Side.RIGHT), property.name.getString()).setMargins(0, 11, 0, 3);
                property.createControl(stackPanel).setMargins(0, 0, 0, 0);
            }
        }
    }

    @Nonnull
    public List<IReorderingProcessor> createTooltip(@Nonnull TaskType taskType) {
        ArrayList<IReorderingProcessor> tooltip = new ArrayList<IReorderingProcessor>();
        tooltip.add(new StringTextComponent(TextFormatting.GOLD + taskType.name.getString()).func_241878_f());
        tooltip.add(new StringTextComponent("").func_241878_f());
        tooltip.addAll(GuiUtil.splitText(this.font, taskType.desc.getString(), 150).stream().map(s -> new StringTextComponent(s).func_241878_f()).collect(Collectors.toList()));
        return tooltip;
    }
}

