/*
 * Decompiled with CFR 0.152.
 */
package com.willr27.blocklings.client.gui.controls.tasks.config.configs;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.willr27.blocklings.client.gui.GuiTexture;
import com.willr27.blocklings.client.gui.GuiTextures;
import com.willr27.blocklings.client.gui.GuiUtil;
import com.willr27.blocklings.client.gui.IControl;
import com.willr27.blocklings.client.gui.controls.TexturedControl;
import com.willr27.blocklings.client.gui.controls.common.ScrollbarControl;
import com.willr27.blocklings.client.gui.controls.tasks.config.ConfigControl;
import com.willr27.blocklings.client.gui.controls.tasks.config.TaskConfigContainerControl;
import com.willr27.blocklings.entity.blockling.task.BlocklingTasks;
import com.willr27.blocklings.entity.blockling.task.Task;
import com.willr27.blocklings.entity.blockling.task.TaskType;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.util.IReorderingProcessor;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class TaskTypeConfigControl
extends ConfigControl {
    public static final int TASK_TYPE_GAP = 5;
    @Nonnull
    private final ScrollbarControl contentScrollbarControl;
    @Nonnull
    private final TaskConfigContainerControl taskConfigGui;
    @Nonnull
    private final List<TaskTypeControl> taskTypeControls = new ArrayList<TaskTypeControl>();

    public TaskTypeConfigControl(@Nonnull TaskConfigContainerControl parentTaskConfigControl, @Nonnull Task task, int x, int y, int width, int height, @Nonnull ScrollbarControl contentScrollbarControl) {
        super(parentTaskConfigControl, x, y, width, height);
        this.contentScrollbarControl = contentScrollbarControl;
        this.taskConfigGui = parentTaskConfigControl;
        List unlockedTaskTypes = BlocklingTasks.TASK_TYPES.stream().filter(taskType -> task.blockling.getTasks().isUnlocked((TaskType)taskType)).collect(Collectors.toList());
        for (int i = 0; i < unlockedTaskTypes.size(); ++i) {
            this.taskTypeControls.add(new TaskTypeControl(this, task, (TaskType)unlockedTaskTypes.get(i), 5 + i % 3 * 45, 5 + i / 3 * 25));
        }
    }

    @Override
    public void preRender(int mouseX, int mouseY, float partialTicks) {
        this.updateTaskTypePositions();
    }

    private void updateTaskTypePositions() {
        int taskControlsHeight;
        int taskControlsHeightDif;
        this.contentScrollbarControl.setIsDisabled(true);
        for (int i = 0; i < this.taskTypeControls.size(); ++i) {
            TaskTypeControl taskTypeControl = this.taskTypeControls.get(i);
            taskTypeControl.setX(5 + i % 3 * 45);
            taskTypeControl.setY(5 + i / 3 * 25);
        }
        if (this.taskTypeControls.size() >= 2 && (taskControlsHeightDif = (taskControlsHeight = this.taskTypeControls.get((int)(this.taskTypeControls.size() - 1)).screenY + this.taskTypeControls.get((int)(this.taskTypeControls.size() - 1)).height - this.taskTypeControls.get((int)0).screenY + 10) - this.height) > 0) {
            this.contentScrollbarControl.setIsDisabled(false);
            for (int i = 0; i < this.taskTypeControls.size(); ++i) {
                TaskTypeControl taskTypeControl = this.taskTypeControls.get(i);
                taskTypeControl.setY(5 + i / 3 * 25 - (int)((double)taskControlsHeightDif * this.contentScrollbarControl.percentageScrolled()));
            }
        }
    }

    public void onTaskTypeChanged() {
        this.taskConfigGui.recreateTabs();
    }

    private static class TaskTypeControl
    extends TexturedControl {
        public static final int WIDTH = 40;
        public static final int HEIGHT = 20;
        @Nonnull
        private static final GuiTexture RADIO_TEXTURE = new GuiTexture(GuiTextures.TASKS, 196, 166, 20, 20);
        @Nonnull
        private static final GuiTexture RADIO_SELECTED_TEXTURE = new GuiTexture(GuiTextures.TASKS, 196, 166, 20, 20);
        @Nonnull
        private final TaskTypeConfigControl taskTypeConfigControl;
        @Nonnull
        public final Task task;
        @Nonnull
        public final TaskType taskType;

        public TaskTypeControl(@Nonnull TaskTypeConfigControl taskTypeConfigControl, @Nonnull Task task, @Nonnull TaskType taskType, int x, int y) {
            super(taskTypeConfigControl, x, y, new GuiTexture(GuiTextures.TASK_CONFIGURE, 0, 166, 40, 20));
            this.taskTypeConfigControl = taskTypeConfigControl;
            this.task = task;
            this.taskType = taskType;
        }

        @Override
        public void render(@Nonnull MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
            super.render(matrixStack, mouseX, mouseY, partialTicks);
            this.renderTexture(matrixStack, this.taskType.texture);
            if (this.task.getType() == this.taskType) {
                RenderSystem.color3f((float)0.7f, (float)0.3f, (float)0.7f);
                this.renderTexture(matrixStack, this.width - 20, 0, RADIO_SELECTED_TEXTURE);
            } else {
                RenderSystem.color3f((float)0.6f, (float)0.6f, (float)0.6f);
                this.renderTexture(matrixStack, this.width - 20, 0, RADIO_TEXTURE);
            }
            RenderSystem.color3f((float)1.0f, (float)1.0f, (float)1.0f);
        }

        @Override
        public void renderTooltip(@Nonnull MatrixStack matrixStack, int mouseX, int mouseY) {
            ArrayList<IReorderingProcessor> text = new ArrayList<IReorderingProcessor>();
            text.add(new StringTextComponent(TextFormatting.GOLD + this.taskType.name.getString()).func_241878_f());
            text.add(new StringTextComponent("").func_241878_f());
            text.addAll(GuiUtil.splitText(this.font, this.taskType.desc.getString(), 150).stream().map(s -> new StringTextComponent(s).func_241878_f()).collect(Collectors.toList()));
            this.screen.func_238654_b_(matrixStack, text, mouseX, mouseY);
        }

        @Override
        public void controlMouseReleased(@Nonnull IControl.MouseButtonEvent e) {
            if (this.isPressed()) {
                this.task.setType(this.taskType);
                this.taskTypeConfigControl.onTaskTypeChanged();
            }
            e.setIsHandled(true);
        }
    }
}

