/*
 * Decompiled with CFR 0.152.
 */
package com.willr27.blocklings.client.gui.controls.tasks.config.configs;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.willr27.blocklings.client.gui.IControl;
import com.willr27.blocklings.client.gui.controls.common.ScrollbarControl;
import com.willr27.blocklings.client.gui.controls.tasks.config.ConfigControl;
import com.willr27.blocklings.client.gui.controls.tasks.config.EntryControl;
import com.willr27.blocklings.entity.blockling.whitelist.GoalWhitelist;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class WhitelistConfigControl
extends ConfigControl {
    public static final int ENTRY_GAP = 4;
    @Nonnull
    private final ScrollbarControl contentScrollbarControl;
    @Nonnull
    private final List<EntryControl> entryControls = new ArrayList<EntryControl>();

    public WhitelistConfigControl(@Nonnull IControl parent, @Nonnull GoalWhitelist whitelist, int x, int y, int width, int height, @Nonnull ScrollbarControl contentScrollbarControl) {
        super(parent, x, y, width, height);
        this.contentScrollbarControl = contentScrollbarControl;
        contentScrollbarControl.setScrollY(0);
        int i = 0;
        for (Map.Entry<ResourceLocation, Boolean> entry : whitelist.entrySet()) {
            this.entryControls.add(new EntryControl((IControl)this, whitelist, entry, 4 + i % 4 * (EntryControl.ENTRY_SELECTED.width + 4), 7 + i / 4 * (EntryControl.ENTRY_SELECTED.height + 4)));
            contentScrollbarControl.setMaxScrollY(7 + i / 4 * (EntryControl.ENTRY_SELECTED.height + 4) + EntryControl.ENTRY_UNSELECTED.height + 4 - height);
            ++i;
        }
    }

    @Override
    public void render(@Nonnull MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.updateEntryPositions();
    }

    private void updateEntryPositions() {
        int taskControlsHeight;
        int taskControlsHeightDif;
        this.contentScrollbarControl.setIsDisabled(true);
        for (int i = 0; i < this.entryControls.size(); ++i) {
            EntryControl entryControl = this.entryControls.get(i);
            entryControl.setX(4 + i % 4 * (EntryControl.ENTRY_UNSELECTED.width + 4));
            entryControl.setY(7 + i / 4 * (EntryControl.ENTRY_UNSELECTED.height + 4));
        }
        if (this.entryControls.size() >= 2 && (taskControlsHeightDif = (taskControlsHeight = this.entryControls.get(this.entryControls.size() - 1).getY() + this.entryControls.get(this.entryControls.size() - 1).getHeight() - this.entryControls.get(0).getY() + 8 + 3) - this.getHeight()) > 0) {
            this.contentScrollbarControl.setIsDisabled(false);
            for (int i = 0; i < this.entryControls.size(); ++i) {
                EntryControl entryControl = this.entryControls.get(i);
                entryControl.setY(7 + i / 4 * (EntryControl.ENTRY_UNSELECTED.height + 4) - (int)((double)taskControlsHeightDif * this.contentScrollbarControl.percentageScrolled()));
            }
        }
    }
}

