/*
 * Decompiled with CFR 0.152.
 */
package com.willr27.blocklings.client.gui.screens;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.willr27.blocklings.client.gui.Control;
import com.willr27.blocklings.client.gui.GuiTexture;
import com.willr27.blocklings.client.gui.GuiTextures;
import com.willr27.blocklings.client.gui.GuiUtil;
import com.willr27.blocklings.client.gui.IControl;
import com.willr27.blocklings.client.gui.controls.TexturedControl;
import com.willr27.blocklings.client.gui.controls.skills.BuySkillConfirmationControl;
import com.willr27.blocklings.client.gui.controls.skills.SkillsControl;
import com.willr27.blocklings.client.gui.screens.TabbedScreen;
import com.willr27.blocklings.entity.blockling.BlocklingEntity;
import com.willr27.blocklings.entity.blockling.skill.SkillGroup;
import com.willr27.blocklings.entity.blockling.skill.info.SkillGroupInfo;
import javax.annotation.Nonnull;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class SkillsScreen
extends TabbedScreen {
    public Control skillsContainer;
    public SkillsControl skillsControl;
    public MaximiseControl maximiseControl;
    public TexturedControl borderControl;
    @Nonnull
    private final SkillGroup group;
    @Nonnull
    public BuySkillConfirmationControl skillBuyConfirmationControl;

    public SkillsScreen(@Nonnull BlocklingEntity blockling, @Nonnull SkillGroupInfo group) {
        super(blockling);
        this.group = blockling.getSkills().getGroup(group);
    }

    @Override
    protected void func_231160_c_() {
        boolean isVisible = true;
        if (this.tabbedControl != null) {
            isVisible = this.tabbedControl.isVisible();
        }
        super.func_231160_c_();
        this.tabbedControl.setIsVisible(isVisible);
        this.skillsContainer = new Control(this, this.contentLeft + 9, this.contentTop + 9, 158, 148);
        this.skillsContainer.setIsInteractive(false);
        this.skillsControl = new SkillsControl(this.skillsContainer, this.blockling, this.group, 0, 0, 158, 148);
        this.skillsControl.setIsFocused(true);
        boolean isMaximised = false;
        if (this.maximiseControl != null && this.maximiseControl.isMaximised) {
            isMaximised = true;
            this.skillsControl.maximise();
        }
        this.maximiseControl = new MaximiseControl(this.skillsContainer, 142, 132){

            @Override
            public void controlMouseReleased(@Nonnull IControl.MouseButtonEvent e) {
                if (!this.isMaximised && this.isPressed()) {
                    this.isMaximised = true;
                    SkillsScreen.this.skillsControl.maximise();
                }
                e.setIsHandled(true);
            }
        };
        this.maximiseControl.isMaximised = isMaximised;
        if (this.borderControl != null) {
            isVisible = this.borderControl.isVisible();
        }
        this.borderControl = new TexturedControl(this, this.contentLeft, this.contentTop, new GuiTexture(GuiTextures.SKILLS, 0, 0, 176, 166)){

            @Override
            public void render(@Nonnull MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
                RenderSystem.enableDepthTest();
                RenderSystem.enableBlend();
                RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
                super.render(matrixStack, mouseX, mouseY, partialTicks);
            }
        };
        this.borderControl.setIsInteractive(false);
        this.borderControl.setIsVisible(isVisible);
    }

    @Override
    protected void renderTitle(@Nonnull MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        if (!this.maximiseControl.isMaximised) {
            super.renderTitle(matrixStack, mouseX, mouseY, partialTicks);
        }
    }

    @Override
    public void globalKeyPressed(@Nonnull IControl.KeyEvent e) {
        if (!e.isHandled() && !this.skillBuyConfirmationControl.isVisible() && GuiUtil.isCloseInventoryKey(e.keyCode)) {
            if (this.maximiseControl.isMaximised) {
                this.maximiseControl.isMaximised = false;
                this.skillsControl.minimise();
            } else {
                this.func_231175_as__();
            }
            e.setIsHandled(true);
        }
    }

    @Override
    public ITextComponent func_231171_q_() {
        return this.group.info.guiTitle;
    }

    @Override
    public boolean func_231177_au__() {
        return false;
    }

    public static class MaximiseControl
    extends Control {
        private static final GuiTexture DEFAULT_TEXTURE = new GuiTexture(GuiTextures.SKILLS, 0, 206, 11, 11);
        private static final GuiTexture HOVERED_TEXTURE = new GuiTexture(GuiTextures.SKILLS, MaximiseControl.DEFAULT_TEXTURE.width, 206, MaximiseControl.DEFAULT_TEXTURE.width, MaximiseControl.DEFAULT_TEXTURE.height);
        public boolean isMaximised = false;

        public MaximiseControl(@Nonnull IControl parent, int x, int y) {
            super(parent, x, y, MaximiseControl.DEFAULT_TEXTURE.width, MaximiseControl.DEFAULT_TEXTURE.height);
        }

        @Override
        public void render(@Nonnull MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
            if (this.isMaximised) {
                return;
            }
            if (this.isMouseOver(mouseX, mouseY)) {
                this.renderTexture(matrixStack, HOVERED_TEXTURE);
            } else {
                this.renderTexture(matrixStack, DEFAULT_TEXTURE);
            }
        }
    }
}

