/*
 * Decompiled with CFR 0.152.
 */
package com.willr27.blocklings.client.gui.screens;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.willr27.blocklings.client.gui.Control;
import com.willr27.blocklings.client.gui.GuiTextures;
import com.willr27.blocklings.client.gui.GuiUtil;
import com.willr27.blocklings.client.gui.IControl;
import com.willr27.blocklings.client.gui.controls.common.TextFieldControl;
import com.willr27.blocklings.client.gui.controls.stats.EnumeratingStatControl;
import com.willr27.blocklings.client.gui.controls.stats.HealthBarControl;
import com.willr27.blocklings.client.gui.controls.stats.LevelControl;
import com.willr27.blocklings.client.gui.screens.TabbedScreen;
import com.willr27.blocklings.entity.blockling.BlocklingEntity;
import com.willr27.blocklings.entity.blockling.BlocklingHand;
import com.willr27.blocklings.entity.blockling.attribute.BlocklingAttributes;
import com.willr27.blocklings.entity.blockling.attribute.IModifiable;
import com.willr27.blocklings.entity.blockling.attribute.IModifier;
import com.willr27.blocklings.entity.blockling.attribute.Operation;
import com.willr27.blocklings.item.BlocklingsItems;
import com.willr27.blocklings.util.BlocklingsTranslationTextComponent;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.Item;
import net.minecraft.util.IReorderingProcessor;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class StatsScreen
extends TabbedScreen {
    private static final int ICON_X_OFFSET = 20;
    private static final int TOP_ICON_Y = 51;
    private static final int BOTTOM_ICON_Y = 79;
    private static final int LEVEL_XP_GAP = 13;
    @Nonnull
    private final BlocklingAttributes stats;
    private TextFieldControl nameField;

    public StatsScreen(@Nonnull BlocklingEntity blockling) {
        super(blockling);
        this.stats = blockling.getStats();
    }

    @Override
    protected void func_231160_c_() {
        super.func_231160_c_();
        new HealthBarControl(this, this.blockling, this.contentLeft + 20, this.contentTop + 36);
        EnumeratingStatControl attackControl = new EnumeratingStatControl(this, (ITextComponent)new BlocklingsTranslationTextComponent("stats.attack.name"), this.contentLeft + 20, this.contentTop + 51, false, 60, true, this.blockling);
        attackControl.addStat(() -> this.blockling.getEquipment().isAttackingWith(BlocklingHand.MAIN), () -> (String)this.stats.mainHandAttackDamage.displayStringValueFunction.apply(this.stats.mainHandAttackDamage.getValue()), () -> StatsScreen.createModifiableFloatAttributeTooltip(this.stats.mainHandAttackDamage, TextFormatting.DARK_RED), 12);
        attackControl.addStat(() -> this.blockling.getEquipment().isAttackingWith(BlocklingHand.OFF), () -> (String)this.stats.offHandAttackDamage.displayStringValueFunction.apply(this.stats.offHandAttackDamage.getValue()), () -> StatsScreen.createModifiableFloatAttributeTooltip(this.stats.offHandAttackDamage, TextFormatting.DARK_RED), 10);
        attackControl.addStat(() -> true, () -> (String)this.stats.attackSpeed.displayStringValueFunction.apply(this.stats.attackSpeed.getValue()), () -> StatsScreen.createModifiableFloatAttributeTooltip(this.stats.attackSpeed, TextFormatting.DARK_PURPLE), 11);
        EnumeratingStatControl defenceControl = new EnumeratingStatControl(this, (ITextComponent)new BlocklingsTranslationTextComponent("stats.defence.name"), this.contentLeft + 20, this.contentTop + 79, false, 60, true, this.blockling);
        defenceControl.addStat(() -> true, () -> (String)this.stats.armour.displayStringValueFunction.apply(this.stats.armour.getValue()), () -> StatsScreen.createModifiableFloatAttributeTooltip(this.stats.armour, TextFormatting.DARK_AQUA), 5);
        defenceControl.addStat(() -> true, () -> (String)this.stats.armourToughness.displayStringValueFunction.apply(this.stats.armourToughness.getValue()), () -> StatsScreen.createModifiableFloatAttributeTooltip(this.stats.armourToughness, TextFormatting.AQUA), 6);
        defenceControl.addStat(() -> true, () -> (String)this.stats.knockbackResistance.displayStringValueFunction.apply(this.stats.knockbackResistance.getValue()), () -> StatsScreen.createModifiableFloatAttributeTooltip(this.stats.knockbackResistance, TextFormatting.YELLOW), 7);
        EnumeratingStatControl gatheringControl = new EnumeratingStatControl(this, (ITextComponent)new BlocklingsTranslationTextComponent("stats.gathering.name"), this.contentLeft + 176 - 20 - 11, this.contentTop + 51, true, 60, true, this.blockling);
        gatheringControl.addStat(() -> true, () -> (String)this.stats.miningSpeed.displayStringValueFunction.apply(this.stats.miningSpeed.getValue()), () -> StatsScreen.createModifiableFloatAttributeTooltip(this.stats.miningSpeed, TextFormatting.BLUE), 1);
        gatheringControl.addStat(() -> true, () -> (String)this.stats.woodcuttingSpeed.displayStringValueFunction.apply(this.stats.woodcuttingSpeed.getValue()), () -> StatsScreen.createModifiableFloatAttributeTooltip(this.stats.woodcuttingSpeed, TextFormatting.DARK_GREEN), 2);
        gatheringControl.addStat(() -> true, () -> (String)this.stats.farmingSpeed.displayStringValueFunction.apply(this.stats.farmingSpeed.getValue()), () -> StatsScreen.createModifiableFloatAttributeTooltip(this.stats.farmingSpeed, TextFormatting.YELLOW), 3);
        EnumeratingStatControl movementControl = new EnumeratingStatControl(this, (ITextComponent)new BlocklingsTranslationTextComponent("stats.movement.name"), this.contentLeft + 176 - 20 - 11, this.contentTop + 79, true, 60, true, this.blockling);
        movementControl.addStat(() -> true, () -> (String)this.stats.moveSpeed.displayStringValueFunction.apply(this.stats.moveSpeed.getValue()), () -> StatsScreen.createModifiableFloatAttributeTooltip(this.stats.moveSpeed, TextFormatting.BLUE), 8);
        LevelControl combatLevelControl = new LevelControl((IControl)this, BlocklingAttributes.Level.COMBAT, this.blockling, this.contentLeft + 15, this.contentTop + 102);
        LevelControl miningLevelControl = new LevelControl((IControl)this, BlocklingAttributes.Level.MINING, this.blockling, combatLevelControl.getX(), combatLevelControl.getY() + 13);
        LevelControl woodcuttingLevelControl = new LevelControl((IControl)this, BlocklingAttributes.Level.WOODCUTTING, this.blockling, combatLevelControl.getX(), miningLevelControl.getY() + 13);
        new LevelControl((IControl)this, BlocklingAttributes.Level.FARMING, this.blockling, combatLevelControl.getX(), woodcuttingLevelControl.getY() + 13);
        new Control(this, this.contentLeft + 88 - 25, this.contentTop + 83 - 25 - 10, 50, 50){

            @Override
            public void renderTooltip(@Nonnull MatrixStack matrixStack, int mouseX, int mouseY) {
                List<String> splitText;
                ArrayList<IReorderingProcessor> tooltip = new ArrayList<IReorderingProcessor>();
                tooltip.add(new StringTextComponent(TextFormatting.GOLD + StatsScreen.this.blockling.func_200201_e().getString()).func_241878_f());
                tooltip.add(new StringTextComponent(TextFormatting.GRAY + new BlocklingsTranslationTextComponent("type.natural.name").getString() + TextFormatting.WHITE + StatsScreen.this.blockling.getNaturalBlocklingType().name.getString()).func_241878_f());
                if (GuiUtil.isKeyDown(Minecraft.func_71410_x().field_71474_y.field_228046_af_.getKey().func_197937_c())) {
                    splitText = GuiUtil.splitText(this.font, new BlocklingsTranslationTextComponent("type.natural.desc").getString(), 200);
                    splitText.stream().map(s -> new StringTextComponent(TextFormatting.DARK_GRAY + s).func_241878_f()).forEach(tooltip::add);
                }
                splitText = GuiUtil.splitText(this.font, new BlocklingsTranslationTextComponent("type." + StatsScreen.this.blockling.getNaturalBlocklingType().key + ".passive").getString(), 200);
                splitText.stream().map(s -> new StringTextComponent(TextFormatting.AQUA + s).func_241878_f()).forEach(tooltip::add);
                tooltip.add(new StringTextComponent(TextFormatting.GRAY + new BlocklingsTranslationTextComponent("type.name").getString() + TextFormatting.WHITE + StatsScreen.this.blockling.getBlocklingType().name.getString()).func_241878_f());
                if (GuiUtil.isKeyDown(Minecraft.func_71410_x().field_71474_y.field_228046_af_.getKey().func_197937_c())) {
                    splitText = GuiUtil.splitText(this.font, new BlocklingsTranslationTextComponent("type.desc").getString(), 200);
                    splitText.stream().map(s -> new StringTextComponent(TextFormatting.DARK_GRAY + s).func_241878_f()).forEach(tooltip::add);
                }
                splitText = GuiUtil.splitText(this.font, new BlocklingsTranslationTextComponent("type." + StatsScreen.this.blockling.getBlocklingType().key + ".passive").getString(), 200);
                splitText.stream().map(s -> new StringTextComponent(TextFormatting.AQUA + s).func_241878_f()).forEach(tooltip::add);
                String foodsString = TextFormatting.GRAY + new BlocklingsTranslationTextComponent("type.foods").getString() + TextFormatting.WHITE + new BlocklingsTranslationTextComponent("type.foods.flowers").getString() + ", ";
                foodsString = foodsString + StatsScreen.this.blockling.getBlocklingType().foods.stream().map(food -> food.func_200296_o().getString()).collect(Collectors.joining(", "));
                splitText = GuiUtil.splitText(this.font, foodsString, 200);
                splitText.stream().map(s -> new StringTextComponent(s).func_241878_f()).forEach(tooltip::add);
                if (!GuiUtil.isKeyDown(Minecraft.func_71410_x().field_71474_y.field_228046_af_.getKey().func_197937_c())) {
                    tooltip.add(new StringTextComponent(TextFormatting.DARK_GRAY + "" + TextFormatting.ITALIC + new BlocklingsTranslationTextComponent("gui.more_info", Minecraft.func_71410_x().field_71474_y.field_228046_af_.func_238171_j_().getString()).getString()).func_241878_f());
                }
                this.screen.func_238654_b_(matrixStack, tooltip, mouseX, mouseY);
            }
        };
        this.nameField = new TextFieldControl(this.field_230712_o_, this.contentLeft + 15, this.contentTop + 15, 158, 13, (ITextComponent)new StringTextComponent("")){

            @Override
            public void setFocus(boolean focus) {
                if (!focus) {
                    if (!this.getValue().equals("")) {
                        StatsScreen.this.blockling.setCustomName(new StringTextComponent(this.getValue()), true);
                    } else {
                        ITextComponent name = ((Item)BlocklingsItems.BLOCKLING.get()).func_200295_i(((Item)BlocklingsItems.BLOCKLING.get()).func_190903_i());
                        StatsScreen.this.blockling.setCustomName(new StringTextComponent(name.getString()), true);
                        this.setValue(name.getString());
                    }
                }
                super.setFocus(focus);
            }
        };
        this.nameField.setBordered(false);
        this.nameField.setMaxLength(25);
        this.nameField.setVisible(true);
        this.nameField.setTextColor(0xFFFFFF);
        this.nameField.setValue(this.blockling.func_200201_e().getString());
    }

    @Nonnull
    public static List<ITextComponent> createModifiableFloatAttributeTooltip(@Nonnull IModifiable<Float> attribute, @Nonnull TextFormatting colour) {
        ArrayList<ITextComponent> tooltip = new ArrayList<ITextComponent>();
        tooltip.add((ITextComponent)new StringTextComponent(colour + attribute.getDisplayStringValueFunction().apply(attribute.getValue()) + " " + TextFormatting.GRAY + attribute.createTranslation("name", new Object[0]).getString()));
        StatsScreen.appendModifiableFloatAttributeToTooltip(tooltip, attribute, 1);
        return tooltip;
    }

    public static void appendModifiableFloatAttributeToTooltip(@Nonnull List<ITextComponent> tooltip, @Nonnull IModifiable<Float> attribute, int depth) {
        for (IModifier<Float> modifier : attribute.getModifiers()) {
            if (!modifier.isEnabled() || !modifier.isEffective()) continue;
            String sign = modifier.getValue().floatValue() < 0.0f && modifier.getOperation() == Operation.ADD ? "" : (modifier.getValue().floatValue() < 1.0f && modifier.getOperation() != Operation.ADD ? "" : "+");
            tooltip.add((ITextComponent)new StringTextComponent(TextFormatting.GRAY + Stream.generate(() -> " ").limit(depth).collect(Collectors.joining()) + sign + modifier.getDisplayStringValueFunction().apply(modifier.getValue()) + " " + TextFormatting.DARK_GRAY + modifier.getDisplayStringNameSupplier().get()));
            if (!(modifier instanceof IModifiable)) continue;
            StatsScreen.appendModifiableFloatAttributeToTooltip(tooltip, (IModifiable)((Object)modifier), depth + 1);
        }
    }

    @Override
    public void func_231023_e_() {
        this.nameField.tick();
        super.func_231023_e_();
    }

    @Override
    public void renderScreen(@Nonnull MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        mouseX = (int)((float)mouseX / this.getEffectiveScale());
        mouseY = (int)((float)mouseY / this.getEffectiveScale());
        super.renderScreen(matrixStack, mouseX, mouseY, partialTicks);
        GuiUtil.bindTexture(GuiTextures.STATS);
        this.func_238474_b_(matrixStack, this.contentLeft, this.contentTop, 0, 0, 176, 166);
        RenderSystem.enableDepthTest();
        this.nameField.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        RenderSystem.enableDepthTest();
        GuiUtil.renderEntityOnScreen(matrixStack, this.centerX, this.centerY + 10, 35, this.centerX - mouseX, this.centerY - mouseY, (LivingEntity)this.blockling);
    }

    @Override
    public void globalMouseClicked(@Nonnull IControl.MouseButtonEvent e) {
        this.nameField.func_231044_a_((float)e.mouseX / this.getEffectiveScale(), (float)e.mouseY / this.getEffectiveScale(), e.button);
    }

    @Override
    public void globalMouseReleased(@Nonnull IControl.MouseButtonEvent e) {
        this.nameField.func_231048_c_((float)e.mouseX / this.getEffectiveScale(), (float)e.mouseY / this.getEffectiveScale(), e.button);
    }

    @Override
    public void globalKeyPressed(@Nonnull IControl.KeyEvent e) {
        if (e.keyCode == 257 || e.keyCode == 256) {
            if (this.nameField.func_230999_j_()) {
                this.nameField.setFocus(false);
                return;
            }
        } else {
            this.nameField.func_231046_a_(e.keyCode, e.scanCode, e.modifiers);
        }
        if (!this.nameField.func_230999_j_() && GuiUtil.isCloseInventoryKey(e.keyCode)) {
            this.func_231175_as__();
            e.setIsHandled(true);
        }
    }

    @Override
    public void globalCharTyped(@Nonnull IControl.CharEvent e) {
        this.nameField.func_231042_a_(e.character, e.keyCode);
    }
}

