/*
 * Decompiled with CFR 0.152.
 */
package com.willr27.blocklings.client.gui.screens;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.willr27.blocklings.client.gui.Control;
import com.willr27.blocklings.client.gui.IControl;
import com.willr27.blocklings.client.gui.IScreen;
import com.willr27.blocklings.client.gui.controls.TabbedControl;
import com.willr27.blocklings.entity.blockling.BlocklingEntity;
import com.willr27.blocklings.util.event.EventHandler;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public abstract class TabbedContainerScreen<T extends Container>
extends ContainerScreen<T>
implements IControl,
IScreen {
    @Nonnull
    protected final BlocklingEntity blockling;
    @Nonnull
    protected final PlayerEntity player;
    protected int centerX;
    protected int centerY;
    protected int left;
    protected int top;
    protected int contentLeft;
    protected int contentTop;
    protected int contentRight;
    protected int contentBottom;
    private TabbedControl tabbedControl;
    @Nonnull
    private final ArrayList<Control> children = new ArrayList();
    @Nonnull
    private final Map<Integer, Integer> heldKeys = new HashMap<Integer, Integer>();
    @Nullable
    private IControl recentlyPressedControl = null;
    @Nonnull
    private IControl focusedControl = this;
    @Nonnull
    private IControl hoveredControl = this;
    @Nullable
    private IControl pressedControl = this;
    private int pressedMouseX = 0;
    private int pressedMouseY = 0;
    @Nullable
    private IControl draggedControl = null;
    private final EventHandler<IControl.MouseEvent> onControlHover = new EventHandler();
    private final EventHandler<IControl.MouseEvent> onControlHoverStart = new EventHandler();
    private final EventHandler<IControl.MouseEvent> onControlHoverStop = new EventHandler();
    private final EventHandler<IControl.MouseButtonEvent> onControlMouseClicked = new EventHandler();
    private final EventHandler<IControl.MouseButtonEvent> onControlMouseReleased = new EventHandler();
    private final EventHandler<IControl.MouseScrollEvent> onControlMouseScrolled = new EventHandler();
    private final EventHandler<IControl.KeyEvent> onControlKeyPressed = new EventHandler();
    private final EventHandler<IControl.KeyEvent> onControlKeyReleased = new EventHandler();
    private final EventHandler<IControl.KeyEvent> onControlKeyHeld = new EventHandler();
    private final EventHandler<IControl.CharEvent> onControlCharTyped = new EventHandler();

    public TabbedContainerScreen(@Nonnull T screenContainer, @Nonnull BlocklingEntity blockling) {
        super(screenContainer, Minecraft.func_71410_x().field_71439_g.field_71071_by, (ITextComponent)new StringTextComponent(""));
        this.blockling = blockling;
        this.player = Minecraft.func_71410_x().field_71439_g;
        this.setupEventHandlers();
    }

    protected void func_231160_c_() {
        this.removeChildren();
        this.centerX = this.field_230708_k_ / 2;
        this.centerY = this.field_230709_l_ / 2 + -5;
        this.left = this.centerX - 117;
        this.top = this.centerY - 83;
        this.contentLeft = this.centerX - 88;
        this.contentTop = this.top;
        this.contentRight = this.contentLeft + 176;
        this.contentBottom = this.contentTop + 166;
        this.removeChild(this.tabbedControl);
        this.tabbedControl = new TabbedControl(this, this.blockling, this.left, this.top);
        Minecraft.func_71410_x().field_195559_v.func_197967_a(true);
        super.func_231160_c_();
    }

    public void func_230430_a_(@Nonnull MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_(0.0, 0.0, -100.0);
        this.renderScreen(matrixStack, mouseX, mouseY, partialTicks);
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        matrixStack.func_227865_b_();
        if (this.getPressedControl() != null) {
            int difX = Math.abs(mouseX - this.getPressedMouseX());
            int difY = Math.abs(mouseY - this.getPressedMouseY());
            if (difX >= 4 || difY >= 4) {
                this.setDraggedControl(this.getPressedControl());
            }
        }
        this.forwardControlHover(new IControl.MouseEvent(mouseX, mouseY));
        this.preRenderAll(mouseX, mouseY, partialTicks);
        this.renderAll(matrixStack, mouseX, mouseY, partialTicks);
        RenderSystem.enableDepthTest();
        this.getHoveredControl().renderTooltip(matrixStack, mouseX, mouseY);
        RenderSystem.enableDepthTest();
        this.func_230459_a_(matrixStack, mouseX, mouseY);
    }

    protected void func_230451_b_(@Nonnull MatrixStack matrixStack, int mouseX, int mouseY) {
    }

    protected void func_230450_a_(@Nonnull MatrixStack matrixStack, float partialTicks, int mouseX, int mouseY) {
    }

    public void func_230459_a_(@Nonnull MatrixStack matrixStack, int mouseX, int mouseY) {
        super.func_230459_a_(matrixStack, mouseX, mouseY);
    }

    @Override
    public void renderScreen(@Nonnull MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.func_238468_a_(matrixStack, 0, 0, this.field_230708_k_, this.field_230709_l_, -1072689136, -804253680);
        this.renderTitle(matrixStack, mouseX, mouseY, partialTicks);
    }

    protected void renderTitle(@Nonnull MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        TabbedContainerScreen.func_238472_a_((MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (ITextComponent)this.func_231171_q_(), (int)(this.contentLeft + 88), (int)(this.contentTop - 15), (int)0xFFFFFF);
    }

    public ITextComponent func_231171_q_() {
        return this.tabbedControl.getChildren().stream().map((Function<Control, TabbedControl.TabControl>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$getTitle$0(com.willr27.blocklings.client.gui.Control ), (Lcom/willr27/blocklings/client/gui/Control;)Lcom/willr27/blocklings/client/gui/controls/TabbedControl$TabControl;)()).filter((Predicate<TabbedControl.TabControl>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$getTitle$1(com.willr27.blocklings.client.gui.controls.TabbedControl$TabControl ), (Lcom/willr27/blocklings/client/gui/controls/TabbedControl$TabControl;)Z)()).findFirst().get().tab.name;
    }

    @Override
    @Nonnull
    public IScreen getScreen() {
        return this;
    }

    @Override
    @Nullable
    public IControl getParent() {
        return null;
    }

    @Override
    @Nonnull
    public ArrayList<Control> getChildren() {
        return this.children;
    }

    @Override
    public void addChild(@Nonnull Control control) {
        if (!this.children.contains(control)) {
            this.children.add(control);
            control.parent = this;
        }
    }

    @Override
    public void removeChild(@Nullable Control control) {
        if (control != null) {
            control.parent = null;
            this.children.remove(control);
        }
    }

    public void func_231023_e_() {
        this.tickAll();
    }

    public final boolean func_231044_a_(double mouseX, double mouseY, int button) {
        IControl.MouseButtonEvent e = new IControl.MouseButtonEvent((int)mouseX, (int)mouseY, button);
        this.forwardControlMouseClicked(e);
        this.forwardGlobalMouseClicked(e);
        return super.func_231044_a_(mouseX, mouseY, button);
    }

    public final boolean func_231048_c_(double mouseX, double mouseY, int button) {
        IControl.MouseButtonEvent e = new IControl.MouseButtonEvent((int)mouseX, (int)mouseY, button);
        this.forwardControlMouseReleased(e);
        this.forwardGlobalMouseReleased(e);
        this.setRecentlyClickedControl(null);
        this.setPressedControl(null, (int)mouseX, (int)mouseY);
        this.setDraggedControl(null);
        return super.func_231048_c_(mouseX, mouseY, button);
    }

    public final boolean func_231043_a_(double mouseX, double mouseY, double scroll) {
        IControl.MouseScrollEvent e = new IControl.MouseScrollEvent((int)mouseX, (int)mouseY, scroll);
        this.forwardControlMouseScrolled(e);
        this.forwardGlobalMouseScrolled(e);
        return super.func_231043_a_(mouseX, mouseY, scroll);
    }

    public final boolean func_231046_a_(int keyCode, int scanCode, int mods) {
        IControl.KeyEvent e;
        if (this.isKeyHeld(keyCode) && this.heldKeys.get(keyCode) > 10) {
            e = new IControl.KeyEvent(keyCode, scanCode, mods);
            this.getFocusedControl().controlKeyHeld(e);
            this.forwardGlobalKeyHeld(e);
        } else {
            e = new IControl.KeyEvent(keyCode, scanCode, mods);
            this.getFocusedControl().controlKeyPressed(e);
            this.forwardGlobalKeyPressed(e);
        }
        Integer oldCount = this.heldKeys.put(keyCode, 0);
        if (oldCount != null) {
            this.heldKeys.put(keyCode, oldCount + 1);
        }
        return super.func_231046_a_(keyCode, scanCode, mods);
    }

    public final boolean func_223281_a_(int keyCode, int scanCode, int mods) {
        IControl.KeyEvent e = new IControl.KeyEvent(keyCode, scanCode, mods);
        this.getFocusedControl().controlKeyReleased(e);
        this.forwardGlobalKeyReleased(e);
        this.heldKeys.remove(keyCode);
        return super.func_223281_a_(keyCode, scanCode, mods);
    }

    public final boolean func_231042_a_(char character, int keyCode) {
        IControl.CharEvent e = new IControl.CharEvent(character, keyCode);
        this.getFocusedControl().controlCharTyped(e);
        this.forwardGlobalCharTyped(e);
        return super.func_231042_a_(character, keyCode);
    }

    @Override
    public int getScreenX() {
        return 0;
    }

    @Override
    public int getScreenY() {
        return 0;
    }

    @Override
    public int getWidth() {
        return this.field_230708_k_;
    }

    @Override
    public int getHeight() {
        return this.field_230709_l_;
    }

    @Override
    public float getScale() {
        return 1.0f;
    }

    public boolean func_231177_au__() {
        return false;
    }

    @Override
    public boolean isKeyHeld(int keyCode) {
        Integer count = this.heldKeys.get(keyCode);
        return count != null && count > 0;
    }

    @Override
    @Nonnull
    public IControl getFocusedControl() {
        return this.focusedControl;
    }

    @Override
    public void setFocusedControl(@Nullable IControl control) {
        this.focusedControl = control == null ? this : control;
    }

    @Override
    @Nonnull
    public IControl getHoveredControl() {
        return this.hoveredControl;
    }

    @Override
    public void setHoveredControl(@Nullable IControl control, int mouseX, int mouseY) {
        IControl iControl = control = control == null ? this : control;
        if (control != this.hoveredControl) {
            this.hoveredControl.controlHoverStop(new IControl.MouseEvent(mouseX, mouseY));
            control.controlHoverStart(new IControl.MouseEvent(mouseX, mouseY));
        }
        this.hoveredControl = control;
    }

    @Override
    @Nullable
    public IControl getPressedControl() {
        return this.pressedControl;
    }

    @Override
    public int getPressedMouseX() {
        return this.pressedMouseX;
    }

    @Override
    public int getPressedMouseY() {
        return this.pressedMouseY;
    }

    @Override
    public void setPressedControl(@Nullable IControl control, int mouseX, int mouseY) {
        this.pressedControl = control;
        this.pressedMouseX = mouseX;
        this.pressedMouseY = mouseY;
    }

    @Override
    @Nullable
    public IControl getDraggedControl() {
        return this.draggedControl;
    }

    @Override
    public void setDraggedControl(@Nullable IControl control) {
        this.draggedControl = control;
    }

    @Override
    @Nonnull
    public EventHandler<IControl.MouseEvent> getOnControlHover() {
        return this.onControlHover;
    }

    @Override
    @Nonnull
    public EventHandler<IControl.MouseEvent> getOnControlHoverStart() {
        return this.onControlHoverStart;
    }

    @Override
    @Nonnull
    public EventHandler<IControl.MouseEvent> getOnControlHoverStop() {
        return this.onControlHoverStop;
    }

    @Override
    @Nonnull
    public EventHandler<IControl.MouseButtonEvent> getOnControlMouseClicked() {
        return this.onControlMouseClicked;
    }

    @Override
    @Nonnull
    public EventHandler<IControl.MouseButtonEvent> getOnControlMouseReleased() {
        return this.onControlMouseReleased;
    }

    @Override
    @Nonnull
    public EventHandler<IControl.MouseScrollEvent> getOnControlMouseScrolled() {
        return this.onControlMouseScrolled;
    }

    @Override
    @Nonnull
    public EventHandler<IControl.KeyEvent> getOnControlKeyPressed() {
        return this.onControlKeyPressed;
    }

    @Override
    @Nonnull
    public EventHandler<IControl.KeyEvent> getOnControlKeyReleased() {
        return this.onControlKeyReleased;
    }

    @Override
    @Nonnull
    public EventHandler<IControl.KeyEvent> getOnControlKeyHeld() {
        return this.onControlKeyHeld;
    }

    @Override
    @Nonnull
    public EventHandler<IControl.CharEvent> getOnControlCharTyped() {
        return this.onControlCharTyped;
    }

    @Override
    @Nullable
    public IControl getRecentlyPressedControl() {
        return this.recentlyPressedControl;
    }

    @Override
    public void setRecentlyClickedControl(@Nullable IControl control) {
        this.recentlyPressedControl = control;
    }

    private static /* synthetic */ boolean lambda$getTitle$1(TabbedControl.TabControl tabControl) {
        return tabControl.isSelected();
    }

    private static /* synthetic */ TabbedControl.TabControl lambda$getTitle$0(Control control) {
        return (TabbedControl.TabControl)control;
    }
}

