/*
 * Decompiled with CFR 0.152.
 */
package com.willr27.blocklings.client.gui.screens;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.willr27.blocklings.client.gui.Control;
import com.willr27.blocklings.client.gui.GuiTextures;
import com.willr27.blocklings.client.gui.GuiUtil;
import com.willr27.blocklings.client.gui.IControl;
import com.willr27.blocklings.client.gui.controls.common.ScrollbarControl;
import com.willr27.blocklings.client.gui.controls.common.panel.StackPanel;
import com.willr27.blocklings.client.gui.controls.tasks.TaskControl;
import com.willr27.blocklings.client.gui.controls.tasks.config.TaskConfigContainerControl;
import com.willr27.blocklings.client.gui.screens.TabbedScreen;
import com.willr27.blocklings.entity.blockling.BlocklingEntity;
import com.willr27.blocklings.entity.blockling.task.BlocklingTasks;
import com.willr27.blocklings.entity.blockling.task.Task;
import com.willr27.blocklings.util.BlocklingsTranslationTextComponent;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class TasksScreen
extends TabbedScreen {
    @Nullable
    private TaskConfigContainerControl taskConfigControl;
    public StackPanel tasksPanel;

    public TasksScreen(BlocklingEntity blockling) {
        super(blockling);
    }

    @Override
    protected void func_231160_c_() {
        super.func_231160_c_();
        boolean isVisible = true;
        if (this.tasksPanel != null) {
            isVisible = this.tasksPanel.isVisible();
        }
        this.tasksPanel = new StackPanel(this, this.contentLeft + 9, this.contentTop + 9, 140, 148){

            @Override
            public void setupEventHandlers() {
                super.setupEventHandlers();
                TasksScreen.this.blockling.getTasks().onCreateTask.subscribe(e -> new TaskControl(this, e.task, false, task -> ((TasksScreen)this.getScreen()).onConfigure(task)));
                TasksScreen.this.blockling.getTasks().onRemoveTask.subscribe(e -> {
                    for (Control control : this.getChildrenCopy()) {
                        TaskControl taskControl = (TaskControl)control;
                        if (!taskControl.task.equals(e.task)) continue;
                        taskControl.remove();
                    }
                });
            }

            @Override
            public void addChild(@Nonnull Control control) {
                this.children.add(control);
                this.children.sort((c1, c2) -> {
                    TaskControl taskControl1 = (TaskControl)c1;
                    TaskControl taskControl2 = (TaskControl)c2;
                    return taskControl1.isAddControl ? 1 : (taskControl2.isAddControl ? -1 : 0);
                });
            }

            @Override
            protected List<Control> getItems() {
                return this.getChildrenCopy().subList(0, this.getChildren().size() - 1);
            }
        };
        this.tasksPanel.setIsReorderable(true);
        this.tasksPanel.onReorder.subscribe(e -> {
            int numberOfTasks = this.blockling.getTasks().getPrioritisedTasks().size();
            if (e.newIndex >= numberOfTasks || e.oldIndex >= numberOfTasks) {
                e.setCancelled(true);
                return;
            }
            TaskControl taskControl = (TaskControl)this.tasksPanel.getChildren().get(e.oldIndex);
            TaskControl closestTaskControl = (TaskControl)this.tasksPanel.getChildren().get(e.newIndex);
            if (e.newIndex > e.oldIndex) {
                taskControl.task.setPriority(closestTaskControl.task.getPriority());
            } else {
                closestTaskControl.task.setPriority(taskControl.task.getPriority());
            }
        });
        this.tasksPanel.setIsVisible(isVisible);
        for (int i = 0; i < this.blockling.getTasks().getPrioritisedTasks().size(); ++i) {
            new TaskControl(this.tasksPanel, (Task)this.blockling.getTasks().getPrioritisedTasks().get(i), false, this::onConfigure);
        }
        new TaskControl(this.tasksPanel, new Task(UUID.randomUUID(), BlocklingTasks.NULL, this.blockling, this.blockling.getTasks()), true, this::onConfigure);
        ScrollbarControl tasksScrollbarControl = new ScrollbarControl(this, this.contentLeft + 155, this.contentTop + 9, 12, 148);
        this.tasksPanel.setScrollbarY(tasksScrollbarControl);
        if (this.taskConfigControl != null) {
            this.taskConfigControl = new TaskConfigContainerControl(this, this.taskConfigControl.task, this.contentLeft, this.contentTop);
        }
    }

    @Override
    public void func_231023_e_() {
        super.func_231023_e_();
    }

    @Override
    public void renderScreen(@Nonnull MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        super.renderScreen(matrixStack, mouseX, mouseY, partialTicks);
        GuiUtil.bindTexture(GuiTextures.TASKS);
        this.func_238474_b_(matrixStack, this.contentLeft, this.contentTop, 0, 0, 176, 166);
    }

    private void onConfigure(@Nonnull Task task) {
        if (this.taskConfigControl != null) {
            this.removeChild(this.taskConfigControl);
        }
        this.taskConfigControl = new TaskConfigContainerControl(this, task, this.contentLeft, this.contentTop);
        this.tasksPanel.setIsVisible(false);
    }

    @Override
    public void controlKeyPressed(@Nonnull IControl.KeyEvent e) {
        if (GuiUtil.isCloseInventoryKey(e.keyCode)) {
            this.func_231175_as__();
            e.setIsHandled(true);
        }
    }

    @Override
    public void setIsVisible(boolean isVisible) {
        super.setIsVisible(isVisible);
        if (isVisible) {
            this.tasksPanel.setIsVisible(true);
        }
    }

    @Override
    public ITextComponent func_231171_q_() {
        if (this.taskConfigControl != null && this.taskConfigControl.isVisible()) {
            return new BlocklingsTranslationTextComponent("gui.configure_task");
        }
        return super.func_231171_q_();
    }

    @Override
    public boolean func_231177_au__() {
        return false;
    }
}

