/*
 * Decompiled with CFR 0.152.
 */
package com.willr27.blocklings.client.gui.screens;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.willr27.blocklings.client.gui.Control;
import com.willr27.blocklings.client.gui.GuiTextures;
import com.willr27.blocklings.client.gui.GuiUtil;
import com.willr27.blocklings.client.gui.IControl;
import com.willr27.blocklings.client.gui.IScreen;
import com.willr27.blocklings.client.gui.controls.TexturedControl;
import com.willr27.blocklings.entity.blockling.BlocklingEntity;
import com.willr27.blocklings.util.event.EventHandler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class TestScreen
extends Screen
implements IControl,
IScreen {
    @Nonnull
    protected final BlocklingEntity blockling;
    @Nonnull
    protected final PlayerEntity player;
    protected float scale;
    protected int centerX;
    protected int centerY;
    @Nonnull
    private final ArrayList<Control> children = new ArrayList();
    @Nonnull
    private final Map<Integer, Integer> heldKeys = new HashMap<Integer, Integer>();
    @Nullable
    private IControl recentlyPressedControl = null;
    @Nonnull
    private IControl focusedControl = this;
    @Nonnull
    private IControl hoveredControl = this;
    @Nullable
    private IControl pressedControl = null;
    private int pressedMouseX = 0;
    private int pressedMouseY = 0;
    @Nullable
    private IControl draggedControl = null;
    private final EventHandler<IControl.MouseEvent> onControlHover = new EventHandler();
    private final EventHandler<IControl.MouseEvent> onControlHoverStart = new EventHandler();
    private final EventHandler<IControl.MouseEvent> onControlHoverStop = new EventHandler();
    private final EventHandler<IControl.MouseButtonEvent> onControlMouseClicked = new EventHandler();
    private final EventHandler<IControl.MouseButtonEvent> onControlMouseReleased = new EventHandler();
    private final EventHandler<IControl.MouseScrollEvent> onControlMouseScrolled = new EventHandler();
    private final EventHandler<IControl.KeyEvent> onControlKeyPressed = new EventHandler();
    private final EventHandler<IControl.KeyEvent> onControlKeyReleased = new EventHandler();
    private final EventHandler<IControl.KeyEvent> onControlKeyHeld = new EventHandler();
    private final EventHandler<IControl.CharEvent> onControlCharTyped = new EventHandler();

    public TestScreen(@Nonnull BlocklingEntity blockling) {
        super((ITextComponent)new StringTextComponent(""));
        this.blockling = blockling;
        this.player = Minecraft.func_71410_x().field_71439_g;
        this.scale = (float)Minecraft.func_71410_x().func_228018_at_().func_198100_s();
        this.setupEventHandlers();
    }

    protected void func_231160_c_() {
        super.func_231160_c_();
        this.scale = (float)Minecraft.func_71410_x().func_228018_at_().func_198100_s();
        this.children.clear();
        this.field_230708_k_ = (int)((float)this.field_230706_i_.func_228018_at_().func_198109_k() / this.scale);
        this.field_230709_l_ = (int)((float)this.field_230706_i_.func_228018_at_().func_198091_l() / this.scale);
        this.centerX = this.field_230708_k_ / 2;
        this.centerY = this.field_230709_l_ / 2 + -5;
        TexturedControl texturedControl = new TexturedControl(this, 0, 0, GuiTextures.FLAT_BAR){

            @Override
            public void render(@Nonnull MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
                super.render(matrixStack, mouseX, mouseY, partialTicks);
            }

            @Override
            public void renderTooltip(@Nonnull MatrixStack matrixStack, int mouseX, int mouseY) {
                this.setX(2);
                this.setY(2);
                this.setScale(2.0f);
                this.screen.func_238652_a_(matrixStack, (ITextComponent)new StringTextComponent("FLAT"), mouseX, mouseY);
            }
        };
        TexturedControl texturedControl2 = new TexturedControl(texturedControl, 0, 0, GuiTextures.DROPDOWN_UP_ARROW){

            @Override
            public void renderTooltip(@Nonnull MatrixStack matrixStack, int mouseX, int mouseY) {
                this.setX(3);
                this.setY(-1);
                this.setScale(2.0f);
                this.screen.func_238652_a_(matrixStack, (ITextComponent)new StringTextComponent("ARROW"), mouseX, mouseY);
            }
        };
        TexturedControl texturedControl3 = new TexturedControl(texturedControl, 0, 0, GuiTextures.DROPDOWN_DOWN_ARROW){

            @Override
            public void renderTooltip(@Nonnull MatrixStack matrixStack, int mouseX, int mouseY) {
                this.setX(20);
                this.setY(-1);
                this.setScale(2.0f);
                this.screen.func_238652_a_(matrixStack, (ITextComponent)new StringTextComponent("ARROW"), mouseX, mouseY);
            }
        };
        Minecraft.func_71410_x().field_195559_v.func_197967_a(true);
    }

    public void func_231175_as__() {
        super.func_231175_as__();
    }

    public void func_230430_a_(@Nonnull MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        mouseX = GuiUtil.getMouseX();
        mouseY = GuiUtil.getMouseY();
        GuiUtil.useGuiScaleForScissor = false;
        float guiScale = (float)Minecraft.func_71410_x().func_228018_at_().func_198100_s();
        matrixStack.func_227860_a_();
        matrixStack.func_227862_a_(1.0f / guiScale, 1.0f / guiScale, 1.0f);
        matrixStack.func_227860_a_();
        matrixStack.func_227862_a_(this.scale, this.scale, 1.0f);
        RenderSystem.enableDepthTest();
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        RenderSystem.enableDepthTest();
        this.renderScreen(matrixStack, mouseX, mouseY, partialTicks);
        if (this.getPressedControl() != null) {
            int difX = Math.abs(mouseX - this.getPressedMouseX());
            int difY = Math.abs(mouseY - this.getPressedMouseY());
            if (difX >= 4 || difY >= 4) {
                this.setDraggedControl(this.getPressedControl());
            }
        }
        matrixStack.func_227865_b_();
        this.forwardControlHover(new IControl.MouseEvent(mouseX, mouseY));
        this.preRenderAll(mouseX, mouseY, partialTicks);
        this.renderAll(matrixStack, mouseX, mouseY, partialTicks);
        matrixStack.func_227860_a_();
        matrixStack.func_227862_a_(this.getHoveredControl().getEffectiveScale(), this.getHoveredControl().getEffectiveScale(), 1.0f);
        Minecraft.func_71410_x().func_228018_at_().func_216525_a((double)this.getHoveredControl().getEffectiveScale());
        RenderSystem.enableDepthTest();
        this.getHoveredControl().renderTooltip(matrixStack, (int)((float)mouseX / this.getHoveredControl().getEffectiveScale()), (int)((float)mouseY / this.getHoveredControl().getEffectiveScale()));
        Minecraft.func_71410_x().func_228018_at_().func_216525_a((double)guiScale);
        matrixStack.func_227865_b_();
        matrixStack.func_227865_b_();
        GuiUtil.useGuiScaleForScissor = true;
    }

    @Override
    public void renderScreen(@Nonnull MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        GuiUtil.bindTexture(GuiTextures.STATS);
        this.func_238474_b_(matrixStack, 0, 0, 0, 0, 176, 166);
    }

    public final boolean func_231044_a_(double mouseX, double mouseY, int button) {
        mouseX = GuiUtil.getMouseX();
        mouseY = GuiUtil.getMouseY();
        IControl.MouseButtonEvent e = new IControl.MouseButtonEvent((int)mouseX, (int)mouseY, button);
        this.forwardControlMouseClicked(e);
        this.forwardGlobalMouseClicked(e);
        return e.isHandled() || super.func_231044_a_(mouseX, mouseY, button);
    }

    public final boolean func_231048_c_(double mouseX, double mouseY, int button) {
        mouseX = GuiUtil.getMouseX();
        mouseY = GuiUtil.getMouseY();
        IControl.MouseButtonEvent e = new IControl.MouseButtonEvent((int)mouseX, (int)mouseY, button);
        this.forwardControlMouseReleased(e);
        this.forwardGlobalMouseReleased(e);
        this.setRecentlyClickedControl(null);
        this.setPressedControl(null, (int)mouseX, (int)mouseY);
        this.setDraggedControl(null);
        return e.isHandled() || super.func_231048_c_(mouseX, mouseY, button);
    }

    public final boolean func_231043_a_(double mouseX, double mouseY, double scroll) {
        mouseX = GuiUtil.getMouseX();
        mouseY = GuiUtil.getMouseY();
        IControl.MouseScrollEvent e = new IControl.MouseScrollEvent((int)mouseX, (int)mouseY, scroll);
        this.forwardControlMouseScrolled(e);
        this.forwardGlobalMouseScrolled(e);
        return e.isHandled() || super.func_231043_a_(mouseX, mouseY, scroll);
    }

    public final boolean func_231046_a_(int keyCode, int scanCode, int mods) {
        IControl.KeyEvent e = new IControl.KeyEvent(keyCode, scanCode, mods);
        if (this.isKeyHeld(keyCode) && this.heldKeys.get(keyCode) > 10) {
            this.getFocusedControl().controlKeyHeld(e);
            this.forwardGlobalKeyHeld(e);
        } else {
            this.getFocusedControl().controlKeyPressed(e);
            this.forwardGlobalKeyPressed(e);
        }
        Integer oldCount = this.heldKeys.put(keyCode, 0);
        if (oldCount != null) {
            this.heldKeys.put(keyCode, oldCount + 1);
        }
        return e.isHandled() || super.func_231046_a_(keyCode, scanCode, mods);
    }

    public final boolean func_223281_a_(int keyCode, int scanCode, int mods) {
        IControl.KeyEvent e = new IControl.KeyEvent(keyCode, scanCode, mods);
        this.getFocusedControl().controlKeyReleased(e);
        this.forwardGlobalKeyReleased(e);
        this.heldKeys.remove(keyCode);
        return e.isHandled() || super.func_223281_a_(keyCode, scanCode, mods);
    }

    public final boolean func_231042_a_(char character, int keyCode) {
        IControl.CharEvent e = new IControl.CharEvent(character, keyCode);
        this.getFocusedControl().controlCharTyped(e);
        this.forwardGlobalCharTyped(e);
        return super.func_231042_a_(character, keyCode);
    }

    @Override
    public void globalKeyPressed(@Nonnull IControl.KeyEvent e) {
        if (GuiUtil.isCloseInventoryKey(e.keyCode)) {
            this.func_231175_as__();
        }
    }

    public boolean func_231177_au__() {
        return false;
    }

    @Override
    @Nonnull
    public IScreen getScreen() {
        return this;
    }

    @Override
    @Nullable
    public IControl getParent() {
        return null;
    }

    @Override
    @Nonnull
    public ArrayList<Control> getChildren() {
        return this.children;
    }

    @Override
    public void addChild(@Nonnull Control control) {
        if (!this.children.contains(control)) {
            this.children.add(control);
            control.parent = this;
        }
    }

    @Override
    public void removeChild(@Nullable Control control) {
        if (control != null) {
            control.parent = null;
            this.children.remove(control);
        }
    }

    @Override
    public int getScreenX() {
        return 0;
    }

    @Override
    public int getScreenY() {
        return 0;
    }

    @Override
    public int getWidth() {
        return this.field_230708_k_;
    }

    @Override
    public int getHeight() {
        return this.field_230709_l_;
    }

    @Override
    public float getScale() {
        return this.scale;
    }

    @Override
    public void setScale(float scale) {
        this.scale = scale;
        this.func_231160_c_();
    }

    @Override
    public boolean isKeyHeld(int keyCode) {
        Integer count = this.heldKeys.get(keyCode);
        return count != null && count > 0;
    }

    @Override
    @Nonnull
    public IControl getFocusedControl() {
        return this.focusedControl;
    }

    @Override
    public void setFocusedControl(@Nullable IControl control) {
        this.focusedControl = control == null ? this : control;
    }

    @Override
    @Nonnull
    public IControl getHoveredControl() {
        return this.hoveredControl;
    }

    @Override
    public void setHoveredControl(@Nullable IControl control, int mouseX, int mouseY) {
        IControl iControl = control = control == null ? this : control;
        if (control != this.hoveredControl) {
            this.hoveredControl.controlHoverStop(new IControl.MouseEvent(mouseX, mouseY));
            control.controlHoverStart(new IControl.MouseEvent(mouseX, mouseY));
        }
        this.hoveredControl = control;
    }

    @Override
    @Nullable
    public IControl getPressedControl() {
        return this.pressedControl;
    }

    @Override
    public int getPressedMouseX() {
        return this.pressedMouseX;
    }

    @Override
    public int getPressedMouseY() {
        return this.pressedMouseY;
    }

    @Override
    public void setPressedControl(@Nullable IControl control, int mouseX, int mouseY) {
        this.pressedControl = control;
        this.pressedMouseX = mouseX;
        this.pressedMouseY = mouseY;
    }

    @Override
    @Nullable
    public IControl getDraggedControl() {
        return this.draggedControl;
    }

    @Override
    public void setDraggedControl(@Nullable IControl control) {
        this.draggedControl = control;
    }

    @Override
    @Nonnull
    public EventHandler<IControl.MouseEvent> getOnControlHover() {
        return this.onControlHover;
    }

    @Override
    @Nonnull
    public EventHandler<IControl.MouseEvent> getOnControlHoverStart() {
        return this.onControlHoverStart;
    }

    @Override
    @Nonnull
    public EventHandler<IControl.MouseEvent> getOnControlHoverStop() {
        return this.onControlHoverStop;
    }

    @Override
    @Nonnull
    public EventHandler<IControl.MouseButtonEvent> getOnControlMouseClicked() {
        return this.onControlMouseClicked;
    }

    @Override
    @Nonnull
    public EventHandler<IControl.MouseButtonEvent> getOnControlMouseReleased() {
        return this.onControlMouseReleased;
    }

    @Override
    @Nonnull
    public EventHandler<IControl.MouseScrollEvent> getOnControlMouseScrolled() {
        return this.onControlMouseScrolled;
    }

    @Override
    @Nonnull
    public EventHandler<IControl.KeyEvent> getOnControlKeyPressed() {
        return this.onControlKeyPressed;
    }

    @Override
    @Nonnull
    public EventHandler<IControl.KeyEvent> getOnControlKeyReleased() {
        return this.onControlKeyReleased;
    }

    @Override
    @Nonnull
    public EventHandler<IControl.KeyEvent> getOnControlKeyHeld() {
        return this.onControlKeyHeld;
    }

    @Override
    @Nonnull
    public EventHandler<IControl.CharEvent> getOnControlCharTyped() {
        return this.onControlCharTyped;
    }

    @Override
    @Nullable
    public IControl getRecentlyPressedControl() {
        return this.recentlyPressedControl;
    }

    @Override
    public void setRecentlyClickedControl(@Nullable IControl control) {
        this.recentlyPressedControl = control;
    }
}

