/*
 * Decompiled with CFR 0.152.
 */
package com.willr27.blocklings.client.renderer.entity.layer;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.willr27.blocklings.client.renderer.entity.BlocklingRenderer;
import com.willr27.blocklings.client.renderer.entity.model.BlocklingModel;
import com.willr27.blocklings.entity.blockling.BlocklingEntity;
import com.willr27.blocklings.util.ToolUtil;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.HandSide;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class BlocklingHeldItemLayer
extends LayerRenderer<BlocklingEntity, BlocklingModel> {
    public BlocklingHeldItemLayer(@Nonnull BlocklingRenderer blocklingRenderer) {
        super((IEntityRenderer)blocklingRenderer);
    }

    public void render(@Nonnull MatrixStack matrixStack, @Nonnull IRenderTypeBuffer renderTypeBuffer, int p_225628_3_, @Nonnull BlocklingEntity blockling, float goesUpWhenMovesCouldBeSpeed, float changesWhenMovesCouldBeSwing, float p_225628_7_, float consistentCouldBePartialTicks, float p_225628_9_, float p_225628_10_) {
        ItemStack mainStack = blockling.func_184614_ca();
        ItemStack offStack = blockling.func_184592_cb();
        if (!mainStack.func_190926_b()) {
            this.renderItem(matrixStack, mainStack, false, blockling, renderTypeBuffer, p_225628_3_);
        }
        if (!offStack.func_190926_b()) {
            this.renderItem(matrixStack, offStack, true, blockling, renderTypeBuffer, p_225628_3_);
        }
    }

    private void renderItem(@Nonnull MatrixStack matrixStack, @Nonnull ItemStack stack, boolean isLeftHand, @Nonnull BlocklingEntity blockling, @Nonnull IRenderTypeBuffer renderTypeBuffer, int p_225628_3_) {
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_(0.0, 1.501, 0.0);
        matrixStack.func_227862_a_(blockling.func_213355_cm(), blockling.func_213355_cm(), blockling.func_213355_cm());
        matrixStack.func_227861_a_(0.0, -1.501, 0.0);
        ((BlocklingModel)this.func_215332_c()).func_225599_a_(isLeftHand ? HandSide.LEFT : HandSide.RIGHT, matrixStack);
        matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f));
        matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(190.0f));
        matrixStack.func_227861_a_((double)((isLeftHand ? 1.0f : -1.0f) / 16.0f), (double)-0.1f, (double)this.getItemHandDisplacement(stack));
        Minecraft.func_71410_x().func_175597_ag().func_228397_a_((LivingEntity)blockling, stack, isLeftHand ? ItemCameraTransforms.TransformType.THIRD_PERSON_LEFT_HAND : ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND, isLeftHand, matrixStack, renderTypeBuffer, p_225628_3_);
        matrixStack.func_227865_b_();
    }

    private float getItemHandDisplacement(@Nonnull ItemStack stack) {
        if (ToolUtil.isWeapon(stack)) {
            return -0.3044f;
        }
        return -0.3552f;
    }
}

