/*
 * Decompiled with CFR 0.152.
 */
package com.willr27.blocklings.client.renderer.entity.model;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import com.willr27.blocklings.entity.blockling.BlocklingEntity;
import com.willr27.blocklings.entity.blockling.BlocklingHand;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.renderer.entity.model.IHasArm;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.Pose;
import net.minecraft.util.Hand;
import net.minecraft.util.HandSide;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class BlocklingModel
extends EntityModel<BlocklingEntity>
implements IHasArm {
    public static final float BODY_BASE_ROT_X = 0.0872665f;
    public static final float RIGHT_LEG_BASE_ROT_X = -0.0872665f;
    public static final float LEFT_LEG_BASE_ROT_X = -0.0872665f;
    public static final float RIGHT_ARM_BASE_ROT_X = 0.6981315f;
    public static final float LEFT_ARM_BASE_ROT_X = 0.6981315f;
    private final ModelRenderer body;
    private final ModelRenderer rightLeg;
    private final ModelRenderer leftLeg;
    private final ModelRenderer rightArm;
    private final ModelRenderer leftArm;
    private final ModelRenderer rightEye;
    private final ModelRenderer leftEye;
    private float scaleX = 1.0f;
    private float scaleY = 1.0f;

    public BlocklingModel() {
        this.field_78090_t = 128;
        this.field_78089_u = 64;
        this.body = new ModelRenderer((Model)this, 16, 0);
        this.body.func_228300_a_(-6.0f, -3.0f, -6.0f, 12.0f, 12.0f, 12.0f);
        this.body.func_78793_a(0.0f, 13.0f, 0.0f);
        this.body.func_78787_b(128, 64);
        this.body.field_78806_j = true;
        BlocklingModel.setRotation(this.body, 0.0872665f, 0.0f, 0.0f);
        this.rightLeg = new ModelRenderer((Model)this, 16, 24);
        this.rightLeg.func_228300_a_(-1.5f, 1.0f, -3.5f, 5.0f, 6.0f, 6.0f);
        this.rightLeg.func_78793_a(-4.0f, 4.0f, 0.5f);
        this.rightLeg.func_78787_b(128, 64);
        this.rightLeg.field_78806_j = true;
        BlocklingModel.setRotation(this.rightLeg, 0.0872665f, 0.0f, 0.0f);
        this.leftLeg = new ModelRenderer((Model)this, 42, 24);
        this.leftLeg.func_228300_a_(-3.5f, 1.0f, -3.5f, 5.0f, 6.0f, 6.0f);
        this.leftLeg.func_78793_a(4.0f, 4.0f, 0.5f);
        this.leftLeg.func_78787_b(128, 64);
        this.leftLeg.field_78806_j = true;
        BlocklingModel.setRotation(this.leftLeg, 0.0872665f, 0.0f, 0.0f);
        this.rightArm = new ModelRenderer((Model)this, 0, 12);
        this.rightArm.func_228300_a_(0.0f, 0.0f, -7.0f, 2.0f, 6.0f, 6.0f);
        this.rightArm.func_78793_a(-8.0f, 0.0f, 0.0f);
        this.rightArm.func_78787_b(128, 64);
        this.rightArm.field_78806_j = true;
        BlocklingModel.setRotation(this.rightArm, 0.6981315f, 0.0f, 0.0f);
        this.leftArm = new ModelRenderer((Model)this, 64, 12);
        this.leftArm.func_228300_a_(-2.0f, 0.0f, -7.0f, 2.0f, 6.0f, 6.0f);
        this.leftArm.func_78793_a(8.0f, 0.0f, 0.0f);
        this.leftArm.func_78787_b(128, 64);
        this.leftArm.field_78806_j = true;
        BlocklingModel.setRotation(this.leftArm, 0.6981315f, 0.0f, 0.0f);
        this.rightEye = new ModelRenderer((Model)this, 22, 8);
        this.rightEye.func_228300_a_(-1.0f, -0.2f, 1.5f, 2.0f, 3.0f, 1.0f);
        this.rightEye.func_78793_a(-2.0f, 3.0f, -8.0f);
        this.rightEye.func_78787_b(128, 64);
        this.rightEye.field_78806_j = true;
        BlocklingModel.setRotation(this.rightEye, 0.0f, 0.0f, 0.0f);
        this.leftEye = new ModelRenderer((Model)this, 52, 8);
        this.leftEye.func_228300_a_(-1.0f, -0.2f, 1.5f, 2.0f, 3.0f, 1.0f);
        this.leftEye.func_78793_a(2.0f, 3.0f, -8.0f);
        this.leftEye.func_78787_b(128, 64);
        this.leftEye.field_78806_j = true;
        BlocklingModel.setRotation(this.leftEye, 0.0f, 0.0f, 0.0f);
        this.body.func_78792_a(this.rightLeg);
        this.body.func_78792_a(this.leftLeg);
        this.body.func_78792_a(this.rightArm);
        this.body.func_78792_a(this.leftArm);
        this.body.func_78792_a(this.rightEye);
        this.body.func_78792_a(this.leftEye);
    }

    public void setupAnim(@Nonnull BlocklingEntity blockling, float limbSwing, float limbSwingAmount, float ageInTicks, float headYaw, float headPitch) {
        float attackSwing;
        float percent;
        EntitySize size = blockling.func_213305_a(Pose.STANDING);
        this.scaleX = size.field_220315_a;
        this.scaleY = size.field_220316_b;
        float partialTicks = ageInTicks % 1.0f;
        limbSwing *= 0.5f;
        limbSwing += ageInTicks / 20.0f;
        float rightLegSwingAmount = limbSwingAmount;
        float leftLegSwingAmount = limbSwingAmount;
        if (limbSwingAmount > 1.0f) {
            limbSwingAmount = 1.0f;
        }
        float rightArmSwingAmount = limbSwingAmount += 0.1f;
        float leftArmSwingAmount = limbSwingAmount;
        float bodySwing = 0.0f;
        float rightArmSwing = 0.0f;
        float leftArmSwing = 0.0f;
        float rightLegSwing = 0.0f;
        float leftLegSwing = 0.0f;
        float weaponBonusRotX = 0.7f;
        BlocklingHand hand = (BlocklingHand)((Object)blockling.getStats().hand.getValue());
        BlocklingHand attackingHand = blockling.getEquipment().findAttackingHand();
        if (blockling.func_70638_az() != null) {
            if (attackingHand == BlocklingHand.MAIN || attackingHand == BlocklingHand.BOTH) {
                rightArmSwing -= blockling.getEquipment().getHandStack(Hand.MAIN_HAND).func_190926_b() ? 0.0f : weaponBonusRotX;
                rightArmSwingAmount /= 2.0f;
            }
            if (attackingHand == BlocklingHand.OFF || attackingHand == BlocklingHand.BOTH) {
                leftArmSwing += blockling.getEquipment().getHandStack(Hand.OFF_HAND).func_190926_b() ? 0.0f : weaponBonusRotX;
                leftArmSwingAmount /= 2.0f;
            }
        }
        if (blockling.getActions().attack.isRunning(BlocklingHand.MAIN)) {
            percent = blockling.getActions().attack.percentThroughHandAction(-1.0f) + (blockling.getActions().attack.percentThroughHandAction() - blockling.getActions().attack.percentThroughHandAction(-1.0f)) * partialTicks;
            attackSwing = MathHelper.func_76134_b((float)(percent * (float)Math.PI / 2.0f)) * 2.0f;
            rightArmSwing += blockling.getEquipment().getHandStack(Hand.MAIN_HAND).func_190926_b() ? -attackSwing : attackSwing;
        }
        if (blockling.getActions().attack.isRunning(BlocklingHand.OFF)) {
            percent = blockling.getActions().attack.percentThroughHandAction(-1.0f) + (blockling.getActions().attack.percentThroughHandAction() - blockling.getActions().attack.percentThroughHandAction(-1.0f)) * partialTicks;
            attackSwing = MathHelper.func_76134_b((float)(percent * (float)Math.PI / 2.0f)) * 2.0f;
            leftArmSwing -= blockling.getEquipment().getHandStack(Hand.OFF_HAND).func_190926_b() ? -attackSwing : attackSwing;
        }
        if (blockling.getActions().gather.isRunning()) {
            if (hand == BlocklingHand.MAIN || hand == BlocklingHand.BOTH) {
                rightArmSwing = MathHelper.func_76134_b((float)(ageInTicks + (float)Math.PI)) * 1.0f;
            }
            if (hand == BlocklingHand.OFF || hand == BlocklingHand.BOTH) {
                leftArmSwing = MathHelper.func_76134_b((float)(ageInTicks + (float)Math.PI)) * 1.0f;
            }
        }
        this.rightArm.field_78795_f = (rightArmSwing += MathHelper.func_76134_b((float)(limbSwing + (float)Math.PI)) * rightArmSwingAmount * 0.8f) + 0.6981315f;
        this.leftArm.field_78795_f = 0.6981315f - (leftArmSwing += MathHelper.func_76134_b((float)(limbSwing + (float)Math.PI)) * leftArmSwingAmount * 0.8f);
        this.rightLeg.field_78795_f = -0.0872665f - (rightLegSwing += MathHelper.func_76134_b((float)(limbSwing + (float)Math.PI)) * rightLegSwingAmount * 0.5f);
        this.leftLeg.field_78795_f = (leftLegSwing += MathHelper.func_76134_b((float)(limbSwing + (float)Math.PI)) * leftLegSwingAmount * 0.5f) + -0.0872665f;
        this.body.field_78808_h = bodySwing += MathHelper.func_76134_b((float)(limbSwing + (float)Math.PI)) * limbSwingAmount * 0.1f;
        this.rightLeg.field_78808_h = -this.body.field_78808_h;
        this.leftLeg.field_78808_h = -this.body.field_78808_h;
    }

    public void func_225598_a_(@Nonnull MatrixStack matrixStack, @Nonnull IVertexBuilder buffer, int packedLight, int packedOverlay, float r, float g, float b, float a) {
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_(0.0, 1.501, 0.0);
        matrixStack.func_227862_a_(this.scaleX, this.scaleY, this.scaleX);
        matrixStack.func_227861_a_(0.0, -1.501, 0.0);
        this.body.func_228309_a_(matrixStack, buffer, packedLight, packedOverlay, r, g, b, a);
        matrixStack.func_227865_b_();
    }

    public void func_225599_a_(@Nonnull HandSide hand, @Nonnull MatrixStack matrixStack) {
        this.body.func_228307_a_(matrixStack);
        if (hand == HandSide.LEFT) {
            this.leftArm.func_228307_a_(matrixStack);
        } else {
            this.rightArm.func_228307_a_(matrixStack);
        }
    }

    private static void setRotation(@Nonnull ModelRenderer model, float x, float y, float z) {
        model.field_78795_f = x;
        model.field_78796_g = y;
        model.field_78808_h = z;
    }
}

