/*
 * Decompiled with CFR 0.152.
 */
package com.willr27.blocklings.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.willr27.blocklings.entity.blockling.BlocklingType;
import com.willr27.blocklings.entity.blockling.attribute.BlocklingAttributes;
import com.willr27.blocklings.network.NetworkHandler;
import com.willr27.blocklings.network.messages.SetLevelCommandMessage;
import com.willr27.blocklings.network.messages.SetTypeCommandMessage;
import com.willr27.blocklings.network.messages.SetXpCommandMessage;
import com.willr27.blocklings.util.BlocklingsTranslationTextComponent;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.ISuggestionProvider;
import net.minecraft.command.arguments.ArgumentSerializer;
import net.minecraft.command.arguments.ArgumentTypes;
import net.minecraft.command.arguments.IArgumentSerializer;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="blocklings", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class BlocklingsCommands {
    public static void init() {
        ArgumentTypes.func_218136_a((String)"blocklings:blockling_type", BlocklingTypeArgument.class, (IArgumentSerializer)new ArgumentSerializer(BlocklingTypeArgument::new));
        ArgumentTypes.func_218136_a((String)"blocklings:level", BlocklingLevelArgument.class, (IArgumentSerializer)new ArgumentSerializer(BlocklingLevelArgument::new));
    }

    @SubscribeEvent
    public static void onRegisterCommands(@Nonnull RegisterCommandsEvent event) {
        CommandDispatcher dispatcher = event.getDispatcher();
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"blockling").requires(source -> source.func_197034_c(2))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"set").then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"type").then(Commands.func_197057_a((String)"primary").then(Commands.func_197056_a((String)"type", (ArgumentType)new BlocklingTypeArgument()).executes(context -> BlocklingsCommands.executeTypeCommand((CommandContext<CommandSource>)context, false))))).then(Commands.func_197057_a((String)"natural").then(Commands.func_197056_a((String)"type", (ArgumentType)new BlocklingTypeArgument()).executes(context -> BlocklingsCommands.executeTypeCommand((CommandContext<CommandSource>)context, true)))))).then(Commands.func_197057_a((String)"level").then(Commands.func_197056_a((String)"level", (ArgumentType)new BlocklingLevelArgument()).then(Commands.func_197056_a((String)"value", (ArgumentType)IntegerArgumentType.integer((int)1, (int)100)).executes(context -> BlocklingsCommands.executeLevelCommand((CommandContext<CommandSource>)context)))))).then(Commands.func_197057_a((String)"xp").then(Commands.func_197056_a((String)"level", (ArgumentType)new BlocklingLevelArgument()).then(Commands.func_197056_a((String)"value", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(context -> BlocklingsCommands.executeXpCommand((CommandContext<CommandSource>)context)))))));
    }

    private static int executeTypeCommand(@Nonnull CommandContext<CommandSource> context, boolean natural) {
        CommandSource source = (CommandSource)context.getSource();
        PlayerEntity player = (PlayerEntity)source.func_197022_f();
        if (player == null) {
            return 1;
        }
        BlocklingType blocklingType = (BlocklingType)context.getArgument("type", BlocklingType.class);
        NetworkHandler.sendToClient(player, new SetTypeCommandMessage(blocklingType.key, natural));
        return 0;
    }

    private static int executeLevelCommand(@Nonnull CommandContext<CommandSource> context) {
        CommandSource source = (CommandSource)context.getSource();
        PlayerEntity player = (PlayerEntity)source.func_197022_f();
        if (player == null) {
            return 1;
        }
        BlocklingAttributes.Level level = (BlocklingAttributes.Level)((Object)context.getArgument("level", BlocklingAttributes.Level.class));
        int value = (Integer)context.getArgument("value", Integer.class);
        NetworkHandler.sendToClient(player, new SetLevelCommandMessage(level, value));
        return 0;
    }

    private static int executeXpCommand(@Nonnull CommandContext<CommandSource> context) {
        CommandSource source = (CommandSource)context.getSource();
        PlayerEntity player = (PlayerEntity)source.func_197022_f();
        if (player == null) {
            return 1;
        }
        BlocklingAttributes.Level level = (BlocklingAttributes.Level)((Object)context.getArgument("level", BlocklingAttributes.Level.class));
        int value = (Integer)context.getArgument("value", Integer.class);
        NetworkHandler.sendToClient(player, new SetXpCommandMessage(level, value));
        return 0;
    }

    public static class BlocklingLevelArgument
    implements ArgumentType<BlocklingAttributes.Level> {
        public static final DynamicCommandExceptionType ERROR_INVALID_VALUE = new DynamicCommandExceptionType(obj -> new BlocklingsTranslationTextComponent("argument.level.invalid", obj));

        public BlocklingAttributes.Level parse(StringReader stringReader) throws CommandSyntaxException {
            String argString = stringReader.readUnquotedString();
            try {
                if (argString.equalsIgnoreCase("all")) {
                    return BlocklingAttributes.Level.TOTAL;
                }
                BlocklingAttributes.Level level = BlocklingAttributes.Level.valueOf(argString.toUpperCase());
                if (level != BlocklingAttributes.Level.TOTAL) {
                    return level;
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            throw ERROR_INVALID_VALUE.create((Object)argString);
        }

        public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder suggestionsBuilder) {
            List levels = Arrays.stream(BlocklingAttributes.Level.values()).filter(level -> level != BlocklingAttributes.Level.TOTAL).map(level -> level.name().toLowerCase()).collect(Collectors.toList());
            levels.add("all");
            return ISuggestionProvider.func_197005_b(levels, (SuggestionsBuilder)suggestionsBuilder);
        }
    }

    public static class BlocklingTypeArgument
    implements ArgumentType<BlocklingType> {
        private static final Collection<String> EXAMPLES = Arrays.asList("oak_log", "stone", "diamond");

        public BlocklingType parse(StringReader stringReader) throws CommandSyntaxException {
            String argString = stringReader.readUnquotedString();
            return BlocklingType.find(argString.toLowerCase());
        }

        public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder suggestionsBuilder) {
            return ISuggestionProvider.func_197013_a(BlocklingType.TYPES.stream().map(blocklingType -> blocklingType.key), (SuggestionsBuilder)suggestionsBuilder);
        }

        public Collection<String> getExamples() {
            return EXAMPLES;
        }
    }
}

