/*
 * Decompiled with CFR 0.152.
 */
package com.willr27.blocklings.config;

import com.electronwill.nightconfig.core.Config;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.commons.lang3.tuple.Pair;

public class BlocklingsConfig {
    @Nonnull
    public static final Common COMMON;
    @Nonnull
    public static final ForgeConfigSpec COMMON_SPEC;
    @Nonnull
    public static final Client CLIENT;
    @Nonnull
    public static final ForgeConfigSpec CLIENT_SPEC;

    public static void init() {
        ModContainer activeContainer = ModLoadingContext.get().getActiveContainer();
        activeContainer.addConfig(new ModConfig(ModConfig.Type.COMMON, COMMON_SPEC, activeContainer));
        activeContainer.addConfig(new ModConfig(ModConfig.Type.CLIENT, CLIENT_SPEC, activeContainer));
    }

    static {
        Pair commonSpecPair = new ForgeConfigSpec.Builder().configure(Common::new);
        COMMON = (Common)commonSpecPair.getLeft();
        COMMON_SPEC = (ForgeConfigSpec)commonSpecPair.getRight();
        Pair clientSpecPair = new ForgeConfigSpec.Builder().configure(Client::new);
        CLIENT = (Client)clientSpecPair.getLeft();
        CLIENT_SPEC = (ForgeConfigSpec)clientSpecPair.getRight();
    }

    public static class Client {
        public final ForgeConfigSpec.ConfigValue<Boolean> disableDirtyBlocklings;

        public Client(@Nonnull ForgeConfigSpec.Builder builder) {
            Config.setInsertionOrderPreserved((boolean)true);
            builder.push("Misc");
            this.disableDirtyBlocklings = builder.comment("Set this to true to disable the mixed blockling type textures.").define("disableDirtyBlocklings", false);
            builder.pop();
        }
    }

    public static class Common {
        @Nonnull
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> additionalOres;
        @Nonnull
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> excludedOres;
        @Nonnull
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> customTrees;
        @Nonnull
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> additionalCrops;
        @Nonnull
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> excludedCrops;

        public Common(@Nonnull ForgeConfigSpec.Builder builder) {
            Config.setInsertionOrderPreserved((boolean)true);
            builder.push("Mining");
            this.additionalOres = builder.comment(new String[]{"The list of blocks (as registry names) to ensure are included in the list of blocks that are regarded as ores.", "Any block with an ores tag will automatically be added, so only include ores without that tag here.", "NOT ALL BLOCKS ARE GUARANTEED TO WORK.", "Example: [\"minecraft:stone\", \"minecraft:obsidian\"]"}).worldRestart().defineList("additionalOres", () -> new ArrayList(), s -> true);
            this.excludedOres = builder.comment(new String[]{"The list of blocks (as registry names) to ensure are excluded from the list of blocks that regarded as ores.", "Any block with an ores tag will automatically be added unless specified here.", "This is useful if you notice modded blocks that are tagged as ores that you don't want/think should be.", "Example: [\"minecraft:coal_ore\", \"minecraft:diamond_ore\"]"}).worldRestart().defineList("excludedOres", () -> new ArrayList(), s -> true);
            builder.pop();
            builder.push("Woodcutting");
            this.customTrees = builder.comment(new String[]{"The list of tuples of blocks that you want to additionally add as trees", "This is useful for modded trees that don't already have support.", "NOT ALL BLOCKS ARE GUARANTEED TO WORK.", "Example: [\"[minecraft:oak_log; minecraft:oak_leaves; minecraft:oak_sapling]\", \"[...]\"]", "This would add oak trees as a custom tree (but they already have support so you don't need to add them here)."}).worldRestart().defineList("customTrees", () -> new ArrayList(), s -> true);
            builder.pop();
            builder.push("Farming");
            this.additionalCrops = builder.comment(new String[]{"The list of blocks (as registry names) to ensure are included in the list of blocks that are regarded as crops.", "NOT ALL BLOCKS ARE GUARANTEED TO WORK.", "Example: [\"minecraft:wheat\", \"minecraft:melon\"]"}).worldRestart().defineList("additionalCrops", () -> new ArrayList(), s -> true);
            this.excludedCrops = builder.comment(new String[]{"The list of blocks (as registry names) to ensure are excluded from the list of blocks that regarded as crops.", "This is useful if you notice modded blocks that have been added as crops that you don't want/think should be.", "Example: [\"minecraft:wheat\", \"minecraft:melon\"]"}).worldRestart().defineList("excludedCrops", () -> new ArrayList(), s -> true);
            builder.pop();
        }
    }
}

